/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.japanese;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.japanese.MapleTrunkBlock;
import org.dawnoftimebuilder.block.templates.BlockAA;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.jetbrains.annotations.NotNull;

public class MapleLeavesBlock
extends BlockAA {
    public static final IntegerProperty MULTIBLOCK_X = BlockStatePropertiesAA.MULTIBLOCK_3X;
    public static final IntegerProperty MULTIBLOCK_Y = BlockStatePropertiesAA.MULTIBLOCK_2Y;
    public static final IntegerProperty MULTIBLOCK_Z = BlockStatePropertiesAA.MULTIBLOCK_3Z;
    private static final VoxelShape VS = Block.box((double)0.1, (double)0.1, (double)0.1, (double)15.9, (double)15.9, (double)15.9);

    public MapleLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)MapleTrunkBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)MULTIBLOCK_X, (Comparable)Integer.valueOf(0))).setValue((Property)MULTIBLOCK_Y, (Comparable)Integer.valueOf(0))).setValue((Property)MULTIBLOCK_Z, (Comparable)Integer.valueOf(0)));
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos blockPosIn, BlockState blockStateIn, Player playerEntityIn) {
        if (!worldIn.isClientSide) {
            float currentX = -((Integer)blockStateIn.getValue((Property)MULTIBLOCK_X)).intValue();
            float currentY = -((Integer)blockStateIn.getValue((Property)MULTIBLOCK_Y)).intValue();
            float currentZ = -((Integer)blockStateIn.getValue((Property)MULTIBLOCK_Z)).intValue();
            for (int x = 0; x <= 2; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = 0; z <= 2; ++z) {
                        BlockPos baseBlockPos = new BlockPos((int)((float)(blockPosIn.getX() + x) + currentX), (int)((float)(blockPosIn.getY() + y) + currentY), (int)((float)(blockPosIn.getZ() + z) + currentZ));
                        BlockState state = worldIn.getBlockState(baseBlockPos);
                        worldIn.setBlock(baseBlockPos, Blocks.AIR.defaultBlockState(), 35);
                        worldIn.levelEvent(playerEntityIn, 2001, blockPosIn, Block.getId((BlockState)state));
                    }
                }
            }
            if (!playerEntityIn.isCreative()) {
                BlockPos trunkBlockPos = new BlockPos((int)((float)blockPosIn.getX() + currentX + 1.0f), (int)((float)blockPosIn.getY() + currentY - 1.0f), (int)((float)blockPosIn.getZ() + currentZ + 1.0f));
                worldIn.destroyBlock(trunkBlockPos, true);
            } else {
                BlockPos trunkBlockPos = new BlockPos((int)((float)blockPosIn.getX() + currentX + 1.0f), (int)((float)blockPosIn.getY() + currentY - 1.0f), (int)((float)blockPosIn.getZ() + currentZ + 1.0f));
                BlockState state = worldIn.getBlockState(trunkBlockPos);
                worldIn.setBlock(trunkBlockPos, Blocks.AIR.defaultBlockState(), 35);
                worldIn.levelEvent(playerEntityIn, 2001, blockPosIn, Block.getId((BlockState)state));
            }
        }
        return super.playerWillDestroy(worldIn, blockPosIn, blockStateIn, playerEntityIn);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MapleTrunkBlock.FACING, MULTIBLOCK_X, MULTIBLOCK_Y, MULTIBLOCK_Z});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState state;
        Direction currentFacing = (Direction)stateIn.getValue((Property)MapleTrunkBlock.FACING);
        float multiblockX = ((Integer)stateIn.getValue((Property)MULTIBLOCK_X)).intValue();
        float multiblockY = ((Integer)stateIn.getValue((Property)MULTIBLOCK_Y)).intValue();
        float multiblockZ = ((Integer)stateIn.getValue((Property)MULTIBLOCK_Z)).intValue();
        if (Direction.DOWN.equals((Object)facing) ? (multiblockX == 1.0f && multiblockY == 0.0f && multiblockZ == 1.0f ? !((state = worldIn.getBlockState(currentPos.offset(0, -1, 0))).getBlock() instanceof MapleTrunkBlock) || currentFacing == null || !currentFacing.equals((Object)state.getValue((Property)MapleTrunkBlock.FACING)) : multiblockY == 1.0f && (!((state = worldIn.getBlockState(currentPos.offset(0, -1, 0))).getBlock() instanceof MapleLeavesBlock) || currentFacing == null || !currentFacing.equals((Object)state.getValue((Property)MapleTrunkBlock.FACING)))) : (Direction.UP.equals((Object)facing) && multiblockY == 0.0f ? !((state = worldIn.getBlockState(currentPos.offset(0, 1, 0))).getBlock() instanceof MapleLeavesBlock) || currentFacing == null || !currentFacing.equals((Object)state.getValue((Property)MapleTrunkBlock.FACING)) : (Direction.WEST.equals((Object)facing) && multiblockX > 0.0f ? !((state = worldIn.getBlockState(currentPos.offset(-1, 0, 0))).getBlock() instanceof MapleLeavesBlock) || currentFacing == null || !currentFacing.equals((Object)state.getValue((Property)MapleTrunkBlock.FACING)) : (Direction.EAST.equals((Object)facing) ? multiblockX < 2.0f && (!((state = worldIn.getBlockState(currentPos.offset(1, 0, 0))).getBlock() instanceof MapleLeavesBlock) || currentFacing == null || !currentFacing.equals((Object)state.getValue((Property)MapleTrunkBlock.FACING))) : (Direction.NORTH.equals((Object)facing) ? multiblockZ > 0.0f && (!((state = worldIn.getBlockState(currentPos.offset(0, 0, -1))).getBlock() instanceof MapleLeavesBlock) || currentFacing == null || !currentFacing.equals((Object)state.getValue((Property)MapleTrunkBlock.FACING))) : Direction.SOUTH.equals((Object)facing) && multiblockZ < 2.0f && (!((state = worldIn.getBlockState(currentPos.offset(0, 0, 1))).getBlock() instanceof MapleLeavesBlock) || currentFacing == null || !currentFacing.equals((Object)state.getValue((Property)MapleTrunkBlock.FACING)))))))) {
            return Blocks.AIR.defaultBlockState();
        }
        return stateIn;
    }

    public VoxelShape getBlockSupportShape(BlockState p_230335_1_, BlockGetter p_230335_2_, BlockPos p_230335_3_) {
        return Shapes.empty();
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return VS;
    }

    public boolean useShapeForLightOcclusion(BlockState p_220074_1_In) {
        return false;
    }

    public float getShadeBrightness(BlockState p_220080_1_, BlockGetter p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState p_200123_1_, BlockGetter p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }
}

