/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.japanese;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.templates.PaneBlockAA;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.jetbrains.annotations.NotNull;

public class LittleFlagBlock
extends PaneBlockAA {
    public static final BooleanProperty AXIS_Y = BlockStatePropertiesAA.AXIS_Y;
    private final VoxelShape[] VS_PILLAR;

    public LittleFlagBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.VS_PILLAR = this.makePillarShapes(this.shapeByIndex);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AXIS_Y, (Comparable)Boolean.valueOf(true))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS_Y});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState newState = super.getStateForPlacement(context);
        if (newState == null) {
            newState = this.defaultBlockState();
        }
        if (this.hasNoConnection(newState)) {
            newState = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)((Boolean)newState.getValue((Property)WATERLOGGED)));
        }
        return (BlockState)newState.setValue((Property)AXIS_Y, (Comparable)Boolean.valueOf(context.getClickedFace().getAxis().isVertical()));
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        if (facing.getAxis().isHorizontal()) {
            if (this.hasAllConnections(stateIn)) {
                BlockState northState = worldIn.getBlockState(currentPos.north());
                BlockState westState = worldIn.getBlockState(currentPos.west());
                BlockState southState = worldIn.getBlockState(currentPos.south());
                BlockState eastState = worldIn.getBlockState(currentPos.east());
                return (BlockState)((BlockState)((BlockState)((BlockState)stateIn.setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.canAttachPane((LevelReader)worldIn, currentPos.north(), Direction.SOUTH, northState)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.canAttachPane((LevelReader)worldIn, currentPos.west(), Direction.EAST, westState)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.canAttachPane((LevelReader)worldIn, currentPos.south(), Direction.NORTH, southState)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.canAttachPane((LevelReader)worldIn, currentPos.east(), Direction.WEST, eastState)));
            }
            if (this.hasNoConnection(stateIn = (BlockState)stateIn.setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(this.canAttachPane((LevelReader)worldIn, facingPos, facing.getOpposite(), facingState))))) {
                return (BlockState)((BlockState)((BlockState)((BlockState)stateIn.setValue((Property)NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)EAST, (Comparable)Boolean.valueOf(true));
            }
        }
        return stateIn;
    }

    private boolean hasNoConnection(BlockState state) {
        return (Boolean)state.getValue((Property)NORTH) == false && (Boolean)state.getValue((Property)WEST) == false && (Boolean)state.getValue((Property)SOUTH) == false && (Boolean)state.getValue((Property)EAST) == false;
    }

    private boolean hasAllConnections(BlockState state) {
        return (Boolean)state.getValue((Property)NORTH) != false && (Boolean)state.getValue((Property)WEST) != false && (Boolean)state.getValue((Property)SOUTH) != false && (Boolean)state.getValue((Property)EAST) != false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)AXIS_Y)).booleanValue()) {
            return this.VS_PILLAR[this.getAABBIndex(state)];
        }
        return super.getShape(state, worldIn, pos, context);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    private VoxelShape[] makePillarShapes(VoxelShape[] shapes) {
        VoxelShape[] shapesPillar = new VoxelShape[16];
        VoxelShape vsPillar = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        for (int index = 0; index < 16; ++index) {
            shapesPillar[index] = Shapes.or((VoxelShape)shapes[index], (VoxelShape)vsPillar);
        }
        return shapesPillar;
    }
}

