/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.japanese;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.dawnoftimebuilder.block.templates.CandleLampBlock;
import org.dawnoftimebuilder.util.VoxelShapes;

public class IroriFireplaceBlock
extends CandleLampBlock {
    public IroriFireplaceBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.FULL_SHAPE);
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                worldIn.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (rand.nextInt(10) == 0) {
                for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)(rand.nextFloat() / 4.0f), 2.5E-5, (double)(rand.nextFloat() / 4.0f));
                }
            }
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5 + rand.nextDouble() / 3.0 * (double)(rand.nextBoolean() ? 1 : -1), (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5 + rand.nextDouble() / 3.0 * (double)(rand.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        }
    }

    @Override
    public float getDisplayScale() {
        return 0.2f;
    }

    @Override
    public boolean emitsLight() {
        return false;
    }
}

