/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.german;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class WaxedOakCanopyBedBlock
extends BedBlock {
    public WaxedOakCanopyBedBlock(DyeColor pColor, BlockBehaviour.Properties pProperties) {
        super(pColor, pProperties);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Direction dir = context.getHorizontalDirection();
        Direction dirCW = dir.getClockWise();
        for (int y = 0; y <= 2; ++y) {
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (level.getBlockState(pos.relative(dir, a).relative(dirCW, b).above(y)).canBeReplaced(context)) continue;
                    return null;
                }
            }
        }
        return super.getStateForPlacement(context);
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, LivingEntity placer, @NotNull ItemStack stack) {
        if (!level.isClientSide()) {
            BlockPos otherBedPos = pos.relative((Direction)state.getValue((Property)FACING));
            level.setBlock(otherBedPos, (BlockState)state.setValue((Property)PART, (Comparable)BedPart.HEAD), 10);
            Direction dir = (Direction)state.getValue((Property)FACING);
            Direction dirCW = dir.getClockWise();
            for (int y = 0; y <= 1; ++y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (y != 0 || x > 0 || z != 0) continue;
                        level.setBlock(pos.relative(dir, x).relative(dirCW, z).above(y), (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir)).setValue((Property)PART, (Comparable)(z == 0 ? BedPart.HEAD : BedPart.FOOT)), 10);
                    }
                }
            }
        }
    }
}

