/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.german;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.IBlockGeneration;
import org.dawnoftimebuilder.block.templates.BlockAA;
import org.dawnoftimebuilder.platform.Services;
import org.dawnoftimebuilder.registry.DoTBTags;
import org.dawnoftimebuilder.util.Utils;
import org.dawnoftimebuilder.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class IvyBlock
extends BlockAA
implements IBlockGeneration {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    private static final IntegerProperty AGE = BlockStateProperties.AGE_2;

    public IvyBlock(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.DESTROY), VoxelShapes.IVY_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    private static ArrayList<Direction> getCurrentDirections(BlockState state) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            list.add(Direction.NORTH);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            list.add(Direction.EAST);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            list.add(Direction.SOUTH);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            list.add(Direction.WEST);
        }
        return list;
    }

    private static BooleanProperty getProperty(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
            default -> NORTH;
        };
    }

    private static boolean hasFullFace(LevelReader Level2, BlockPos currentPos, Direction face) {
        currentPos = currentPos.relative(face);
        return IvyBlock.hasFullFace(Level2.getBlockState(currentPos), Level2, currentPos, face);
    }

    private static boolean hasFullFace(BlockState state, LevelReader Level2, BlockPos pos, Direction face) {
        Block block = state.getBlock();
        if (block.defaultBlockState().is(BlockTags.DIRT) || block.defaultBlockState().is(BlockTags.SAND) || block.defaultBlockState().is(DoTBTags.INSTANCE.GRAVEL)) {
            return false;
        }
        return Block.isFaceFull((VoxelShape)state.getCollisionShape((BlockGetter)Level2, pos), (Direction)face.getOpposite());
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, AGE, PERSISTENT});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter levelIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = 0;
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            ++index;
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            index += 2;
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            index += 4;
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            index += 8;
        }
        if (index > 14) {
            index = 0;
        }
        return index;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Direction facing = context.getHorizontalDirection();
        if (!IvyBlock.hasFullFace(level.getBlockState(pos = pos.relative(facing)), (LevelReader)level, pos, facing)) {
            return null;
        }
        if (state.getBlock() != this) {
            state = this.defaultBlockState();
        }
        return (BlockState)state.setValue((Property)IvyBlock.getProperty(facing), (Comparable)Boolean.valueOf(true));
    }

    public boolean canBeReplaced(@NotNull BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.getItemInHand();
        if (useContext.getPlayer() != null && useContext.getPlayer().isCrouching()) {
            return false;
        }
        if (itemstack.getItem() == this.asItem()) {
            Direction newDirection = useContext.getHorizontalDirection();
            return switch (newDirection) {
                case Direction.WEST -> {
                    if (!((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.NORTH -> {
                    if (!((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.EAST -> {
                    if (!((Boolean)state.getValue((Property)EAST)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                default -> (Boolean)state.getValue((Property)SOUTH) == false;
            };
        }
        return false;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT) == false;
    }

    public void tick(@NotNull BlockState state, ServerLevel levelIn, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!levelIn.isClientSide()) {
            if (!levelIn.isLoaded(pos)) {
                return;
            }
            if (levelIn.getRawBrightness(pos, 0) >= 8) {
                int age = (Integer)state.getValue((Property)AGE);
                if (age < 2) {
                    if (random.nextInt(Services.PLATFORM.getConfig().climbingPlantGrowthChance) == 0) {
                        levelIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
                    }
                    return;
                }
                if (random.nextInt(Services.PLATFORM.getConfig().climbingPlantSpreadChance) == 0) {
                    ArrayList<Direction> list = IvyBlock.getCurrentDirections(state);
                    int faceIndex = list.size();
                    if (faceIndex == 0) {
                        return;
                    }
                    faceIndex = random.nextInt(faceIndex);
                    Direction face = list.get(faceIndex);
                    faceIndex = random.nextInt(4);
                    if (faceIndex < 2) {
                        Direction rotFace;
                        Direction direction = rotFace = faceIndex == 0 ? face.getCounterClockWise() : face.getClockWise();
                        if (IvyBlock.hasFullFace((LevelReader)levelIn, pos, rotFace)) {
                            if (!((Boolean)state.getValue((Property)IvyBlock.getProperty(rotFace))).booleanValue()) {
                                levelIn.setBlock(pos, (BlockState)state.setValue((Property)IvyBlock.getProperty(rotFace), (Comparable)Boolean.valueOf(true)), 2);
                            }
                        } else {
                            BlockPos studiedPos = pos.relative(rotFace);
                            if (levelIn.getBlockState(studiedPos).isAir()) {
                                if (IvyBlock.hasFullFace((LevelReader)levelIn, studiedPos, face)) {
                                    levelIn.setBlock(studiedPos, (BlockState)this.defaultBlockState().setValue((Property)IvyBlock.getProperty(face), (Comparable)Boolean.valueOf(true)), 2);
                                } else if (levelIn.getBlockState(studiedPos = studiedPos.relative(face)).isAir()) {
                                    Direction direction2 = rotFace = faceIndex == 0 ? face.getClockWise() : face.getCounterClockWise();
                                    if (IvyBlock.hasFullFace((LevelReader)levelIn, studiedPos, rotFace)) {
                                        levelIn.setBlock(studiedPos, (BlockState)this.defaultBlockState().setValue((Property)IvyBlock.getProperty(rotFace), (Comparable)Boolean.valueOf(true)), 2);
                                    }
                                }
                            }
                        }
                    } else {
                        BlockPos studiedPos;
                        BlockPos blockPos = studiedPos = faceIndex == 2 ? pos.above() : pos.below();
                        if (levelIn.getBlockState(studiedPos).isAir() && IvyBlock.hasFullFace((LevelReader)levelIn, studiedPos, face)) {
                            levelIn.setBlock(studiedPos, (BlockState)this.defaultBlockState().setValue((Property)IvyBlock.getProperty(face), (Comparable)Boolean.valueOf(true)), 2);
                        }
                    }
                }
            }
        }
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState stateIn, Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor levelIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing.getAxis().isHorizontal()) {
            if (facing == Direction.NORTH && ((Boolean)stateIn.getValue((Property)NORTH)).booleanValue() && !IvyBlock.hasFullFace(facingState, (LevelReader)levelIn, facingPos, facing)) {
                stateIn = (BlockState)stateIn.setValue((Property)NORTH, (Comparable)Boolean.valueOf(false));
            }
            if (facing == Direction.EAST && ((Boolean)stateIn.getValue((Property)EAST)).booleanValue() && !IvyBlock.hasFullFace(facingState, (LevelReader)levelIn, facingPos, facing)) {
                stateIn = (BlockState)stateIn.setValue((Property)EAST, (Comparable)Boolean.valueOf(false));
            }
            if (facing == Direction.SOUTH && ((Boolean)stateIn.getValue((Property)SOUTH)).booleanValue() && !IvyBlock.hasFullFace(facingState, (LevelReader)levelIn, facingPos, facing)) {
                stateIn = (BlockState)stateIn.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false));
            }
            if (facing == Direction.WEST && ((Boolean)stateIn.getValue((Property)WEST)).booleanValue() && !IvyBlock.hasFullFace(facingState, (LevelReader)levelIn, facingPos, facing)) {
                stateIn = (BlockState)stateIn.setValue((Property)WEST, (Comparable)Boolean.valueOf(false));
            }
        }
        if (IvyBlock.getCurrentDirections(stateIn).isEmpty()) {
            return Blocks.AIR.defaultBlockState();
        }
        return stateIn;
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, @NotNull Level levelIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            if (player.isCreative()) {
                int age = (Integer)state.getValue((Property)AGE);
                if (player.isCrouching()) {
                    if (age > 0) {
                        levelIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age - 1)), 10);
                        return InteractionResult.SUCCESS;
                    }
                } else if (age < 2) {
                    levelIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 10);
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (Utils.useLighter(levelIn, pos, player, player.getUsedItemHand())) {
            Random rand = new Random();
            for (int i = 0; i < 5; ++i) {
                levelIn.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + rand.nextDouble(), (double)pos.getY() + 0.5 + rand.nextDouble() / 2.0, (double)pos.getZ() + rand.nextDouble(), 0.0, 0.07, 0.0);
            }
            levelIn.setBlock(pos, (BlockState)state.setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 10);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Utils.addTooltip(tooltip, "crop");
    }

    @Override
    public boolean generateOnPos(WorldGenLevel world, BlockPos pos, BlockState state, RandomSource random) {
        int trunkSize;
        if (!world.getBlockState(pos).is(BlockTags.LOGS)) {
            if (world.getBlockState(pos.north()).is(BlockTags.LOGS)) {
                pos = pos.north();
            } else if (world.getBlockState(pos.east()).is(BlockTags.LOGS)) {
                pos = pos.east();
            } else if (world.getBlockState(pos.south()).is(BlockTags.LOGS)) {
                pos = pos.south();
            } else if (world.getBlockState(pos.west()).is(BlockTags.LOGS)) {
                pos = pos.west();
            } else {
                return false;
            }
        }
        BlockPos.MutableBlockPos mutPos = pos.mutable().move(Direction.DOWN);
        for (int yDown = 0; yDown < 20; ++yDown) {
            if (!world.getBlockState((BlockPos)mutPos).is(BlockTags.LOGS)) {
                mutPos.move(Direction.UP);
                break;
            }
            mutPos.move(Direction.DOWN);
        }
        for (trunkSize = 0; trunkSize <= 20 && world.getBlockState((BlockPos)mutPos).is(BlockTags.LOGS); ++trunkSize) {
            mutPos.move(Direction.UP);
        }
        if (trunkSize > 0) {
            return this.tryPlaceOnTrunk(world, pos.north(), (BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true)), random, trunkSize) && this.tryPlaceOnTrunk(world, pos.east(), (BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(true)), random, trunkSize) && this.tryPlaceOnTrunk(world, pos.south(), (BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(true)), random, trunkSize) && this.tryPlaceOnTrunk(world, pos.west(), (BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(true)), random, trunkSize);
        }
        return false;
    }

    private boolean tryPlaceOnTrunk(WorldGenLevel world, BlockPos pos, BlockState state, RandomSource random, int trunkSize) {
        int sideSize;
        BlockPos.MutableBlockPos mutPos = pos.mutable();
        for (sideSize = 0; sideSize < trunkSize && world.getBlockState((BlockPos)mutPos).isAir(); ++sideSize) {
            mutPos.move(Direction.UP);
        }
        mutPos = pos.mutable();
        if (sideSize > 0) {
            sideSize = random.nextInt(1, sideSize + 1);
            for (int yOffset = 0; yOffset < sideSize; ++yOffset) {
                int age = yOffset + 1 == sideSize ? random.nextInt(3) : 2;
                world.setBlock((BlockPos)mutPos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age)), 2);
                mutPos.move(Direction.UP);
            }
            return true;
        }
        return false;
    }
}

