/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.general;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.templates.BlockAA;
import org.dawnoftimebuilder.block.templates.PoolBlock;
import org.dawnoftimebuilder.registry.DoTBBlocksRegistry;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.dawnoftimebuilder.util.CustomBlockPlaceContext;
import org.jetbrains.annotations.Nullable;

public abstract class WaterTrickleBlock
extends BlockAA {
    public WaterTrickleBlock(BlockBehaviour.Properties propertiesIn) {
        super(propertiesIn.pushReaction(PushReaction.DESTROY).lightLevel(state -> 1));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStatePropertiesAA.NORTH_TRICKLE, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStatePropertiesAA.EAST_TRICKLE, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStatePropertiesAA.SOUTH_TRICKLE, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStatePropertiesAA.WEST_TRICKLE, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStatePropertiesAA.CENTER_TRICKLE, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.UNSTABLE, (Comparable)Boolean.valueOf(true))).setValue(BlockStatePropertiesAA.WATER_TRICKLE_END, (Comparable)((Object)BlockStatePropertiesAA.WaterTrickleEnd.FADE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStatePropertiesAA.NORTH_TRICKLE, BlockStatePropertiesAA.EAST_TRICKLE, BlockStatePropertiesAA.SOUTH_TRICKLE, BlockStatePropertiesAA.WEST_TRICKLE, BlockStatePropertiesAA.CENTER_TRICKLE, BlockStateProperties.UNSTABLE, BlockStatePropertiesAA.WATER_TRICKLE_END});
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        if (!pLevel.isClientSide() && ((Boolean)pState.getValue((Property)BlockStateProperties.UNSTABLE)).booleanValue()) {
            pLevel.scheduleTick(pPos, (Block)this, 5);
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction directionIn, BlockState facingStateIn, LevelAccessor worldIn, BlockPos currentPosIn, BlockPos facingPosIn) {
        if (directionIn == Direction.UP && facingStateIn.getBlock() instanceof WaterTrickleBlock) {
            if (!worldIn.isClientSide()) {
                worldIn.scheduleTick(currentPosIn, (Block)this, 5);
            }
            return (BlockState)stateIn.setValue((Property)BlockStateProperties.UNSTABLE, (Comparable)Boolean.valueOf(true));
        }
        if (directionIn == Direction.DOWN && worldIn instanceof Level) {
            if (!worldIn.isClientSide()) {
                worldIn.scheduleTick(currentPosIn, (Block)this, 5);
            }
            return (BlockState)((BlockState)stateIn.setValue(BlockStatePropertiesAA.WATER_TRICKLE_END, (Comparable)((Object)this.getWaterTrickleEnd((Level)worldIn, facingPosIn, facingStateIn)))).setValue((Property)BlockStateProperties.UNSTABLE, (Comparable)Boolean.valueOf(true));
        }
        return stateIn;
    }

    public boolean[] getWaterTrickleOutPut(BlockState currentState) {
        return new boolean[]{(Boolean)currentState.getValue((Property)BlockStatePropertiesAA.NORTH_TRICKLE), (Boolean)currentState.getValue((Property)BlockStatePropertiesAA.EAST_TRICKLE), (Boolean)currentState.getValue((Property)BlockStatePropertiesAA.SOUTH_TRICKLE), (Boolean)currentState.getValue((Property)BlockStatePropertiesAA.WEST_TRICKLE), (Boolean)currentState.getValue((Property)BlockStatePropertiesAA.CENTER_TRICKLE)};
    }

    public BlockState inheritWaterTrickles(BlockState currentState, BlockState aboveState) {
        boolean[] trickles = ((WaterTrickleBlock)aboveState.getBlock()).getWaterTrickleOutPut(aboveState);
        BooleanProperty[] properties = new BooleanProperty[]{BlockStatePropertiesAA.NORTH_TRICKLE, BlockStatePropertiesAA.EAST_TRICKLE, BlockStatePropertiesAA.SOUTH_TRICKLE, BlockStatePropertiesAA.WEST_TRICKLE, BlockStatePropertiesAA.CENTER_TRICKLE};
        int i = 0;
        BlockState updatedState = currentState;
        for (BooleanProperty property : properties) {
            if ((Boolean)currentState.getValue((Property)property) != trickles[i]) {
                updatedState = (BlockState)((BlockState)updatedState.setValue((Property)property, (Comparable)Boolean.valueOf(trickles[i]))).setValue((Property)BlockStateProperties.UNSTABLE, (Comparable)Boolean.valueOf(true));
            }
            ++i;
        }
        return updatedState;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        BlockState updatedState;
        super.tick(state, world, pos, rand);
        state = (BlockState)state.setValue((Property)BlockStateProperties.UNSTABLE, (Comparable)Boolean.valueOf(false));
        BlockPos bottomPos = pos.below();
        BlockState bottomState = world.getBlockState(bottomPos);
        BlockPos abovePos = pos.above();
        BlockState aboveState = world.getBlockState(abovePos);
        if (bottomState.getBlock() instanceof WaterTrickleBlock) {
            updatedState = this.inheritWaterTrickles(bottomState, state);
            if (((Boolean)updatedState.getValue((Property)BlockStateProperties.UNSTABLE)).booleanValue()) {
                world.setBlock(bottomPos, (BlockState)bottomState.setValue((Property)BlockStateProperties.UNSTABLE, (Comparable)Boolean.valueOf(true)), 10);
            }
        } else if (bottomState.canBeReplaced(this.generateContext((Level)world, bottomPos)) && world.getFluidState(bottomPos).getType().equals(Fluids.EMPTY)) {
            bottomState = this.createFlowingTrickle(bottomState, this.getWaterTrickleOutPut(state), (Level)world, bottomPos);
        } else if (bottomState.getBlock() instanceof LiquidBlockContainer && ((LiquidBlockContainer)bottomState.getBlock()).canPlaceLiquid(null, (BlockGetter)world, bottomPos, bottomState, (Fluid)Fluids.WATER)) {
            ((LiquidBlockContainer)bottomState.getBlock()).placeLiquid((LevelAccessor)world, bottomPos, bottomState, Fluids.WATER.getSource(false));
        }
        updatedState = this.updateWaterTrickle((Level)world, state, bottomPos, bottomState, aboveState);
        world.setBlock(pos, updatedState, 10);
    }

    public BlockState updateWaterTrickle(Level world, BlockState currentState, BlockPos bottomPos, BlockState bottomState, BlockState aboveState) {
        BlockStatePropertiesAA.WaterTrickleEnd lowerEnd = this.getWaterTrickleEnd(world, bottomPos, bottomState);
        currentState = (BlockState)currentState.setValue(BlockStatePropertiesAA.WATER_TRICKLE_END, (Comparable)((Object)lowerEnd));
        currentState = aboveState.getBlock() instanceof WaterTrickleBlock ? this.inheritWaterTrickles(currentState, aboveState) : this.inheritWaterTrickles(currentState, this.defaultBlockState());
        return currentState;
    }

    public BlockState createFlowingTrickle(BlockState currentState, boolean[] trickles, Level world, BlockPos waterTricklePos) {
        BooleanProperty[] properties = new BooleanProperty[]{BlockStatePropertiesAA.NORTH_TRICKLE, BlockStatePropertiesAA.EAST_TRICKLE, BlockStatePropertiesAA.SOUTH_TRICKLE, BlockStatePropertiesAA.WEST_TRICKLE, BlockStatePropertiesAA.CENTER_TRICKLE};
        int i = 0;
        int numberOfTrickle = 0;
        BlockState waterTrickleState = DoTBBlocksRegistry.INSTANCE.WATER_FLOWING_TRICKLE.get().defaultBlockState();
        for (BooleanProperty property : properties) {
            waterTrickleState = (BlockState)waterTrickleState.setValue((Property)property, (Comparable)Boolean.valueOf(trickles[i]));
            if (trickles[i]) {
                ++numberOfTrickle;
            }
            ++i;
        }
        if (numberOfTrickle > 0) {
            world.setBlock(waterTricklePos, waterTrickleState, 10);
            return waterTrickleState;
        }
        return currentState;
    }

    public void animateTick(BlockState state, Level worldIn, BlockPos pos, RandomSource rand) {
        super.animateTick(state, worldIn, pos, rand);
        boolean[] trickles = this.getWaterTrickleOutPut(state);
        if (state.getValue(BlockStatePropertiesAA.WATER_TRICKLE_END) == BlockStatePropertiesAA.WaterTrickleEnd.SPLASH) {
            this.spawnFullParticles(worldIn, pos, trickles[0], rand, 0.5, 0.4);
            this.spawnFullParticles(worldIn, pos, trickles[1], rand, 0.6, 0.5);
            this.spawnFullParticles(worldIn, pos, trickles[2], rand, 0.5, 0.6);
            this.spawnFullParticles(worldIn, pos, trickles[3], rand, 0.5, 0.6);
            this.spawnFullParticles(worldIn, pos, trickles[4], rand, 0.5, 0.5);
            return;
        }
        BlockState belowState = worldIn.getBlockState(pos.below());
        if (belowState.getBlock() instanceof PoolBlock && (Integer)belowState.getValue((Property)BlockStatePropertiesAA.LEVEL) > ((PoolBlock)belowState.getBlock()).faucetLevel) {
            this.spawnLimitedParticles(worldIn, pos, trickles[0], rand, 0.5, 0.4);
            this.spawnLimitedParticles(worldIn, pos, trickles[1], rand, 0.6, 0.5);
            this.spawnLimitedParticles(worldIn, pos, trickles[2], rand, 0.5, 0.6);
            this.spawnLimitedParticles(worldIn, pos, trickles[3], rand, 0.5, 0.6);
            this.spawnLimitedParticles(worldIn, pos, trickles[4], rand, 0.5, 0.5);
        }
    }

    private void spawnLimitedParticles(Level worldIn, BlockPos pos, boolean isOn, RandomSource rand, double xOffset, double zOffset) {
        if (isOn) {
            double offset = 0.75;
            worldIn.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, true, (double)pos.getX() + xOffset + (rand.nextDouble() * offset - offset / 2.0), (double)pos.getY() + 0.1, (double)pos.getZ() + zOffset + (rand.nextDouble() * offset - offset / 2.0), 0.0125, 0.075, 0.0125);
            offset = 0.6;
            worldIn.addParticle((ParticleOptions)ParticleTypes.CLOUD, true, (double)pos.getX() + xOffset + (rand.nextDouble() * offset - offset / 2.0), (double)pos.getY() + 0.0, (double)pos.getZ() + zOffset + (rand.nextDouble() * offset - offset / 2.0), 5.0E-4, 0.01, 5.0E-4);
        }
    }

    private void spawnFullParticles(Level worldIn, BlockPos pos, boolean isOn, RandomSource rand, double xOffset, double zOffset) {
        if (isOn) {
            for (int i = 0; i < 4; ++i) {
                double offset = 0.75;
                worldIn.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, true, (double)pos.getX() + xOffset + (rand.nextDouble() * offset - offset / 2.0), (double)pos.getY() + 0.1, (double)pos.getZ() + zOffset + (rand.nextDouble() * offset - offset / 2.0), 0.0125, 0.075, 0.0125);
                offset = 0.6;
                worldIn.addParticle((ParticleOptions)ParticleTypes.CLOUD, true, (double)pos.getX() + xOffset + (rand.nextDouble() * offset - offset / 2.0), (double)pos.getY() + 0.0, (double)pos.getZ() + zOffset + (rand.nextDouble() * offset - offset / 2.0), 5.0E-4, 0.01, 5.0E-4);
            }
        }
    }

    protected BlockStatePropertiesAA.WaterTrickleEnd getWaterTrickleEnd(Level level, BlockPos bottomPos, BlockState bottomState) {
        if (bottomState.getBlock() instanceof WaterTrickleBlock) {
            return BlockStatePropertiesAA.WaterTrickleEnd.STRAIGHT;
        }
        if (!level.getFluidState(bottomPos).getType().equals(Fluids.EMPTY)) {
            return BlockStatePropertiesAA.WaterTrickleEnd.SPLASH;
        }
        return BlockStatePropertiesAA.WaterTrickleEnd.FADE;
    }

    private BlockPlaceContext generateContext(Level level, BlockPos fromPos) {
        Vec3 vec = new Vec3((double)fromPos.getX() + 0.5, (double)fromPos.getY(), (double)fromPos.getZ() + 0.5);
        return new CustomBlockPlaceContext(level, null, InteractionHand.MAIN_HAND, ItemStack.EMPTY, new BlockHitResult(vec, Direction.DOWN, fromPos, false));
    }

    protected static BooleanProperty getPropertyFromDirection(Direction facing) {
        return switch (facing) {
            default -> BlockStatePropertiesAA.CENTER;
            case Direction.NORTH -> BlockStateProperties.NORTH;
            case Direction.SOUTH -> BlockStateProperties.SOUTH;
            case Direction.WEST -> BlockStateProperties.WEST;
            case Direction.EAST -> BlockStateProperties.EAST;
        };
    }

    public int getLightBlock(BlockState p_200011_1_In, BlockGetter p_200011_2_In, BlockPos p_200011_3_In) {
        return 1;
    }

    public boolean useShapeForLightOcclusion(BlockState p_220074_1_In) {
        return false;
    }

    public VoxelShape getOcclusionShape(BlockState p_196247_1_In, BlockGetter p_196247_2_In, BlockPos p_196247_3_In) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState p_220080_1_, BlockGetter p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState p_200123_1_In, BlockGetter p_200123_2_In, BlockPos p_200123_3_In) {
        return true;
    }
}

