/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.general;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftimebuilder.block.templates.PlateBlock;
import org.dawnoftimebuilder.util.Utils;
import org.dawnoftimebuilder.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class IronFenceBlock
extends PlateBlock {
    private static final BooleanProperty UP = BlockStateProperties.UP;

    public IronFenceBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.IRON_FENCE_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PlateBlock.FACING, (Comparable)Direction.NORTH)).setValue(PlateBlock.SHAPE, (Comparable)StairsShape.STRAIGHT)).setValue((Property)UP, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = (((Direction)state.getValue((Property)FACING)).get2DDataValue() + 2) % 4;
        index *= 3;
        switch ((StairsShape)state.getValue((Property)SHAPE)) {
            case OUTER_RIGHT: {
                index += 3;
                break;
            }
            case STRAIGHT: {
                ++index;
                break;
            }
            case INNER_LEFT: {
                index += 2;
                break;
            }
            case INNER_RIGHT: {
                index += 5;
                break;
            }
        }
        return (Boolean)state.getValue((Property)UP) != false ? index + 12 : (index %= 12);
    }

    @Override
    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{UP});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)UP, (Comparable)Boolean.valueOf(!context.getLevel().getBlockState(context.getClickedPos().above()).is((Block)this)));
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing == Direction.UP) {
            stateIn = (BlockState)stateIn.setValue((Property)UP, (Comparable)Boolean.valueOf(!facingState.is((Block)this)));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        BlockPos topPos;
        ItemStack heldItemStack = player.getItemInHand(player.getUsedItemHand());
        if (player.isCrouching()) {
            if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
                return super.useWithoutItem(state, worldIn, pos, player, hit);
            }
            BlockPos topPos2 = this.getHighestColumnPos(worldIn, pos);
            if (topPos2 != pos) {
                if (!worldIn.isClientSide()) {
                    worldIn.setBlock(topPos2, Blocks.AIR.defaultBlockState(), 35);
                    if (!player.isCreative()) {
                        Block.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)heldItemStack);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else if (!heldItemStack.isEmpty() && heldItemStack.getItem() == this.asItem() && (topPos = this.getHighestColumnPos(worldIn, pos).above()).getY() <= 255) {
            if (!worldIn.isClientSide() && worldIn.getBlockState(topPos).isAir()) {
                worldIn.setBlock(topPos, state, 11);
                if (!player.isCreative()) {
                    heldItemStack.shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, worldIn, pos, player, hit);
    }

    private BlockPos getHighestColumnPos(Level worldIn, BlockPos pos) {
        int yOffset = 0;
        while (yOffset + pos.getY() <= 255 && worldIn.getBlockState(pos.above(yOffset)).getBlock() == this) {
            ++yOffset;
        }
        return pos.above(yOffset - 1);
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Utils.addTooltip(tooltip, "column");
    }
}

