/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.french;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftimebuilder.block.templates.ConnectedVerticalBlock;
import org.dawnoftimebuilder.block.templates.PlateBlock;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.dawnoftimebuilder.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class ReinforcedIronFenceBlock
extends ConnectedVerticalBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;

    public ReinforcedIronFenceBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.REINFORCED_IRON_FENCE_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT)).setValue((Property)VERTICAL_CONNECTION, (Comparable)((Object)BlockStatePropertiesAA.VerticalConnection.NONE)));
    }

    private static StairsShape getShapeProperty(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Direction adjacentDirection;
        Direction direction = (Direction)state.getValue((Property)PlateBlock.FACING);
        BlockState adjacentState = worldIn.getBlockState(pos.relative(direction));
        if (adjacentState.getBlock() instanceof ReinforcedIronFenceBlock && (adjacentDirection = (Direction)adjacentState.getValue((Property)PlateBlock.FACING)).getAxis() != ((Direction)state.getValue((Property)PlateBlock.FACING)).getAxis()) {
            return adjacentDirection == direction.getCounterClockWise() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        adjacentState = worldIn.getBlockState(pos.relative(direction.getOpposite()));
        if (adjacentState.getBlock() instanceof ReinforcedIronFenceBlock && (adjacentDirection = (Direction)adjacentState.getValue((Property)PlateBlock.FACING)).getAxis() != ((Direction)state.getValue((Property)PlateBlock.FACING)).getAxis()) {
            return adjacentDirection == direction.getCounterClockWise() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, SHAPE});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = (((Direction)state.getValue((Property)PlateBlock.FACING)).get2DDataValue() + 2) % 4;
        index *= 3;
        switch ((StairsShape)state.getValue(PlateBlock.SHAPE)) {
            case OUTER_RIGHT: {
                index += 3;
                break;
            }
            case STRAIGHT: {
                ++index;
                break;
            }
            case INNER_LEFT: {
                index += 2;
                break;
            }
            case INNER_RIGHT: {
                index += 5;
                break;
            }
        }
        return state.getValue((Property)VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.NONE || state.getValue((Property)VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.ABOVE ? index : (index %= 12) + 12;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)super.getStateForPlacement(context).setValue((Property)PlateBlock.FACING, (Comparable)context.getHorizontalDirection());
        return (BlockState)state.setValue(PlateBlock.SHAPE, (Comparable)ReinforcedIronFenceBlock.getShapeProperty(state, (BlockGetter)context.getLevel(), context.getClickedPos()));
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return facing.getAxis().isHorizontal() ? (BlockState)stateIn.setValue(PlateBlock.SHAPE, (Comparable)ReinforcedIronFenceBlock.getShapeProperty(stateIn, (BlockGetter)worldIn, currentPos)) : stateIn;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)PlateBlock.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)PlateBlock.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.getValue((Property)PlateBlock.FACING);
        StairsShape stairsshape = (StairsShape)state.getValue(PlateBlock.SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                return switch (stairsshape) {
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(PlateBlock.SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(PlateBlock.SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(PlateBlock.SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(PlateBlock.SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    default -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                return switch (stairsshape) {
                    default -> throw new MatchException(null, null);
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(PlateBlock.SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(PlateBlock.SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(PlateBlock.SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(PlateBlock.SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.mirror(state, mirrorIn);
    }
}

