/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.dawnoftimebuilder.platform.Services;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.dawnoftimebuilder.util.Utils;

public interface IBlockClimbingPlant {
    default public void tickPlant(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.isClientSide()) {
            if (((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.getValue(BlockStatePropertiesAA.CLIMBING_PLANT))).hasNoPlant() || ((Boolean)stateIn.getValue((Property)LeavesBlock.PERSISTENT)).booleanValue()) {
                return;
            }
            if (!worldIn.isLoaded(pos)) {
                return;
            }
            if (worldIn.getRawBrightness(pos, 0) >= 8) {
                IBlockClimbingPlant newBlock;
                int index;
                int age = (Integer)stateIn.getValue((Property)BlockStatePropertiesAA.AGE_0_6);
                if (random.nextInt(Services.PLATFORM.getConfig().climbingPlantGrowthChance) == 0) {
                    if (age < 2) {
                        this.placePlant((BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.AGE_0_6, (Comparable)Integer.valueOf(age + 1)), worldIn, pos, 2);
                        return;
                    }
                    if (((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.getValue(BlockStatePropertiesAA.CLIMBING_PLANT))).canGrow(worldIn, age)) {
                        this.placePlant((BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.AGE_0_6, (Comparable)Integer.valueOf(2 + (age - 1) % 5)), worldIn, pos, 2);
                        return;
                    }
                }
                if (age < 2 || random.nextInt(Services.PLATFORM.getConfig().climbingPlantSpreadChance) != 0) {
                    return;
                }
                BlockPos[] positions = new BlockPos[]{pos.north(), pos.east(), pos.south(), pos.west(), pos.above()};
                BlockState newState = worldIn.getBlockState(positions[index = random.nextInt(5)]);
                Block block = newState.getBlock();
                if (block instanceof IBlockClimbingPlant && (newBlock = (IBlockClimbingPlant)block).canHavePlant(newState) && ((BlockStatePropertiesAA.ClimbingPlant)((Object)newState.getValue(BlockStatePropertiesAA.CLIMBING_PLANT))).hasNoPlant()) {
                    newBlock.placePlant((BlockState)newState.setValue(BlockStatePropertiesAA.CLIMBING_PLANT, (Comparable)((Object)((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.getValue(BlockStatePropertiesAA.CLIMBING_PLANT))))), worldIn, positions[index], 2);
                }
            }
        }
    }

    default public boolean tryPlacingPlant(BlockState stateIn, Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        BlockStatePropertiesAA.ClimbingPlant plant;
        if (player.isCrouching()) {
            return false;
        }
        ItemStack heldItemStack = player.getItemInHand(handIn);
        if (this.canHavePlant(stateIn) && ((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.getValue(BlockStatePropertiesAA.CLIMBING_PLANT))).hasNoPlant() && !(plant = BlockStatePropertiesAA.ClimbingPlant.getFromItem(heldItemStack.getItem())).hasNoPlant()) {
            stateIn = (BlockState)stateIn.setValue(BlockStatePropertiesAA.CLIMBING_PLANT, (Comparable)((Object)plant));
            if (!player.isCreative()) {
                heldItemStack.shrink(1);
            }
            this.placePlant(stateIn, worldIn, pos, 10);
            return true;
        }
        return false;
    }

    default public void placePlant(BlockState state, Level world, BlockPos pos, int option) {
        world.setBlock(pos, state, option);
    }

    default public InteractionResult harvestPlant(BlockState stateIn, Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        if (player.isCreative() && ((Boolean)stateIn.getValue((Property)LeavesBlock.PERSISTENT)).booleanValue() && !((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.getValue(BlockStatePropertiesAA.CLIMBING_PLANT))).hasNoPlant()) {
            if (player.isCrouching()) {
                if ((Integer)stateIn.getValue((Property)BlockStatePropertiesAA.AGE_0_6) > 0) {
                    this.placePlant((BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.AGE_0_6, (Comparable)Integer.valueOf((Integer)stateIn.getValue((Property)BlockStatePropertiesAA.AGE_0_6) - 1)), worldIn, pos, 10);
                } else {
                    this.placePlant((BlockState)((BlockState)stateIn.setValue(BlockStatePropertiesAA.CLIMBING_PLANT, (Comparable)((Object)BlockStatePropertiesAA.ClimbingPlant.NONE))).setValue((Property)BlockStatePropertiesAA.AGE_0_6, (Comparable)Integer.valueOf(0)), worldIn, pos, 10);
                }
                return InteractionResult.SUCCESS;
            }
            if ((Integer)stateIn.getValue((Property)BlockStatePropertiesAA.AGE_0_6) < ((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.getValue(BlockStatePropertiesAA.CLIMBING_PLANT))).maxAge()) {
                this.placePlant((BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.AGE_0_6, (Comparable)Integer.valueOf((Integer)stateIn.getValue((Property)BlockStatePropertiesAA.AGE_0_6) + 1)), worldIn, pos, 10);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if ((Integer)stateIn.getValue((Property)BlockStatePropertiesAA.AGE_0_6) > 2 && this.dropPlant(stateIn, (LevelAccessor)worldIn, pos, player.getItemInHand(handIn), true)) {
            stateIn = (BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.AGE_0_6, (Comparable)Integer.valueOf(2));
            this.placePlant(stateIn, worldIn, pos, 10);
            worldIn.playSound(null, pos, SoundEvents.GRASS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching()) {
            return this.tryRemovingPlant(stateIn, worldIn, pos, player.getItemInHand(handIn));
        }
        return InteractionResult.PASS;
    }

    default public InteractionResult tryRemovingPlant(BlockState stateIn, Level worldIn, BlockPos pos, ItemStack heldItemStack) {
        if (!((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.getValue(BlockStatePropertiesAA.CLIMBING_PLANT))).hasNoPlant()) {
            stateIn = this.removePlant(stateIn, (LevelAccessor)worldIn, pos, heldItemStack);
            this.placePlant(stateIn, worldIn, pos, 10);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    default public BlockState removePlant(BlockState stateIn, LevelAccessor worldIn, BlockPos pos, ItemStack heldItemStack) {
        this.dropPlant(stateIn, worldIn, pos, heldItemStack, true);
        worldIn.playSound(null, pos, SoundEvents.GRASS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        stateIn = (BlockState)((BlockState)stateIn.setValue(BlockStatePropertiesAA.CLIMBING_PLANT, (Comparable)((Object)BlockStatePropertiesAA.ClimbingPlant.NONE))).setValue((Property)BlockStatePropertiesAA.AGE_0_6, (Comparable)Integer.valueOf(0));
        return stateIn;
    }

    default public boolean dropPlant(BlockState stateIn, LevelAccessor worldIn, BlockPos pos, ItemStack heldItemStack, boolean bool) {
        if (worldIn.isClientSide()) {
            return false;
        }
        BlockStatePropertiesAA.ClimbingPlant plant = (BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.getValue(BlockStatePropertiesAA.CLIMBING_PLANT));
        if (plant.hasNoPlant()) {
            return false;
        }
        List<ItemStack> drops = Utils.getLootList((ServerLevel)worldIn, stateIn, heldItemStack, plant.getSerializedName() + "_" + String.valueOf(stateIn.getValue((Property)BlockStatePropertiesAA.AGE_0_6)));
        return Utils.dropLootFromList(worldIn, pos, drops, 1.0f);
    }

    default public boolean canHavePlant(BlockState state) {
        if (state.getBlock() instanceof SimpleWaterloggedBlock) {
            return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false;
        }
        return true;
    }

    default public boolean canSustainClimbingPlant(BlockState stateUnder) {
        Block block = stateUnder.getBlock();
        return block == Blocks.GRASS_BLOCK || stateUnder.is(BlockTags.DIRT);
    }
}

