/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.dawnoftimebuilder.block.IBlockPillar;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;

public interface IBlockChain
extends IBlockPillar {
    public static boolean canBeChained(BlockState state, boolean tryConnectUnder) {
        Block block = state.getBlock();
        if (block == Blocks.CHAIN) {
            return state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y;
        }
        if (block instanceof IBlockChain) {
            return tryConnectUnder ? ((IBlockChain)block).canConnectToChainUnder(state) : ((IBlockChain)block).canConnectToChainAbove(state);
        }
        return false;
    }

    default public boolean canConnectToChainAbove(BlockState state) {
        return true;
    }

    default public boolean canConnectToChainUnder(BlockState state) {
        return true;
    }

    @Override
    default public BlockStatePropertiesAA.PillarConnection getBlockPillarConnectionAbove(BlockState state) {
        return this.canConnectToChainAbove(state) ? BlockStatePropertiesAA.PillarConnection.FOUR_PX : BlockStatePropertiesAA.PillarConnection.NOTHING;
    }

    @Override
    default public BlockStatePropertiesAA.PillarConnection getBlockPillarConnectionUnder(BlockState state) {
        return this.canConnectToChainUnder(state) ? BlockStatePropertiesAA.PillarConnection.FOUR_PX : BlockStatePropertiesAA.PillarConnection.NOTHING;
    }
}

