/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.registry.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.createmod.catnip.lang.Lang;
import net.dakotapride.garnished.CreateGarnished;
import net.dakotapride.garnished.recipe.BlackDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.BlueDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.BrownDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.CyanDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.FreezingFanRecipe;
import net.dakotapride.garnished.recipe.GrayDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.GreenDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.LightBlueDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.LightGrayDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.LimeDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.MagentaDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.OrangeDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.PinkDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.PurpleDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.RedDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.WhiteDyeBlowingFanRecipe;
import net.dakotapride.garnished.recipe.YellowDyeBlowingFanRecipe;
import net.dakotapride.garnished.registry.recipe.md.CustomProcessingSerializer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public enum GarnishedRecipeTypes implements IRecipeTypeInfo,
StringRepresentable
{
    FREEZING(FreezingFanRecipe::new),
    RED_DYE_BLOWING(RedDyeBlowingFanRecipe::new),
    ORANGE_DYE_BLOWING(OrangeDyeBlowingFanRecipe::new),
    YELLOW_DYE_BLOWING(YellowDyeBlowingFanRecipe::new),
    GREEN_DYE_BLOWING(GreenDyeBlowingFanRecipe::new),
    LIME_DYE_BLOWING(LimeDyeBlowingFanRecipe::new),
    BLUE_DYE_BLOWING(BlueDyeBlowingFanRecipe::new),
    LIGHT_BLUE_DYE_BLOWING(LightBlueDyeBlowingFanRecipe::new),
    CYAN_DYE_BLOWING(CyanDyeBlowingFanRecipe::new),
    PURPLE_DYE_BLOWING(PurpleDyeBlowingFanRecipe::new),
    MAGENTA_DYE_BLOWING(MagentaDyeBlowingFanRecipe::new),
    PINK_DYE_BLOWING(PinkDyeBlowingFanRecipe::new),
    BLACK_DYE_BLOWING(BlackDyeBlowingFanRecipe::new),
    GRAY_DYE_BLOWING(GrayDyeBlowingFanRecipe::new),
    LIGHT_GRAY_DYE_BLOWING(LightGrayDyeBlowingFanRecipe::new),
    WHITE_DYE_BLOWING(WhiteDyeBlowingFanRecipe::new),
    BROWN_DYE_BLOWING(BrownDyeBlowingFanRecipe::new);

    public final ResourceLocation id;
    public final Supplier<RecipeSerializer<?>> serializerSupplier;
    public final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> serializerObject;
    public final Supplier<RecipeType<?>> type;
    public static final Codec<GarnishedRecipeTypes> CODEC;
    private boolean isProcessingRecipe;

    private GarnishedRecipeTypes(Supplier<RecipeSerializer<?>> serializerSupplier) {
        DeferredHolder typeObject;
        String name = Lang.asId((String)this.name());
        this.id = CreateGarnished.asResource(name);
        this.serializerObject = Registers.SERIALIZER_REGISTER.register(name, serializerSupplier);
        this.type = typeObject = Registers.TYPE_REGISTER.register(name, () -> RecipeType.simple((ResourceLocation)this.id));
        this.serializerSupplier = serializerSupplier;
        this.isProcessingRecipe = false;
    }

    private GarnishedRecipeTypes(ProcessingRecipeBuilder.ProcessingRecipeFactory<?> processingFactory) {
        this(() -> new CustomProcessingSerializer(processingFactory));
        this.isProcessingRecipe = true;
    }

    public static void register(IEventBus modEventBus) {
        ShapedRecipePattern.setCraftingSize((int)9, (int)9);
        Registers.SERIALIZER_REGISTER.register(modEventBus);
        Registers.TYPE_REGISTER.register(modEventBus);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public <T extends RecipeSerializer<?>> T getSerializer() {
        return (T)((RecipeSerializer)this.serializerObject.get());
    }

    public <I extends RecipeInput, R extends Recipe<I>> RecipeType<R> getType() {
        return this.type.get();
    }

    public <I extends RecipeInput, R extends Recipe<I>> Optional<RecipeHolder<R>> find(I inv, Level world) {
        return world.getRecipeManager().getRecipeFor(this.getType(), inv, world);
    }

    @NotNull
    public String getSerializedName() {
        return this.id.toString();
    }

    public <T extends ProcessingRecipe<?>> MapCodec<T> processingCodec() {
        if (!this.isProcessingRecipe) {
            throw new AssertionError((Object)("GarnishedRecipeTypes#processingCodec called on " + this.name() + ", which is not a processing recipe"));
        }
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)Ingredient.CODEC, (Codec)FluidIngredient.CODEC).listOf().fieldOf("ingredients").forGetter(i -> {
            ArrayList list = new ArrayList();
            i.getIngredients().forEach(o -> list.add(Either.left((Object)o)));
            i.getFluidIngredients().forEach(o -> list.add(Either.right((Object)o)));
            return list;
        }), (App)Codec.either((Codec)ProcessingOutput.CODEC, (Codec)FluidStack.CODEC).listOf().fieldOf("results").forGetter(i -> {
            ArrayList list = new ArrayList();
            i.getRollableResults().forEach(o -> list.add(Either.left((Object)o)));
            i.getFluidResults().forEach(o -> list.add(Either.right((Object)o)));
            return list;
        }), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("processing_time", (Object)0).forGetter(ProcessingRecipe::getProcessingDuration), (App)StringRepresentable.fromEnum(HeatCondition::values).optionalFieldOf("heat_requirement", (Object)HeatCondition.NONE).forGetter(ProcessingRecipe::getRequiredHeat)).apply((Applicative)instance, (ingredients, results, processingTime, heatRequirement) -> {
            RecipeSerializer<?> patt0$temp = this.serializerSupplier.get();
            if (!(patt0$temp instanceof CustomProcessingSerializer)) {
                throw new RuntimeException("Not a processing recipe serializer " + String.valueOf(this.serializerSupplier.get()));
            }
            CustomProcessingSerializer processingRecipeSerializer = (CustomProcessingSerializer)patt0$temp;
            ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(processingRecipeSerializer.getFactory(), this.id);
            NonNullList ingredientList = NonNullList.create();
            NonNullList fluidIngredientList = NonNullList.create();
            NonNullList processingOutputList = NonNullList.create();
            NonNullList fluidStackOutputList = NonNullList.create();
            for (Either either : ingredients) {
                either.left().ifPresent(arg_0 -> ingredientList.add(arg_0));
                either.right().ifPresent(arg_0 -> fluidIngredientList.add(arg_0));
            }
            for (Either either : results) {
                either.left().ifPresent(arg_0 -> processingOutputList.add(arg_0));
                either.right().ifPresent(arg_0 -> fluidStackOutputList.add(arg_0));
            }
            builder.withItemIngredients(ingredientList).withItemOutputs(processingOutputList).withFluidIngredients(fluidIngredientList).withFluidOutputs(fluidStackOutputList).duration(processingTime.intValue()).requiresHeat(heatRequirement);
            return builder.build();
        }));
    }

    static {
        CODEC = StringRepresentable.fromEnum(GarnishedRecipeTypes::values);
    }

    private static class Registers {
        private static final DeferredRegister<RecipeSerializer<?>> SERIALIZER_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"garnished");
        private static final DeferredRegister<RecipeType<?>> TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"garnished");

        private Registers() {
        }
    }
}

