/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.registry;

import net.dakotapride.garnished.item.IGarnishedUtilities;
import net.dakotapride.garnished.registry.GarnishedEffects;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;

public enum GarnishedFoodValues implements IGarnishedUtilities
{
    OVERWORLD_MIN(1, 0.25f),
    OVERWORLD_MAX(8, 0.65f),
    NETHER_MIN(6, 0.4f),
    NETHER_MAX(12, 0.8f),
    END_MIN(10, 0.55f),
    END_MAX(16, 1.0f);

    public final int nutrition;
    public final float saturation;
    public static final FoodProperties UNGARNISHED_NUT;
    public static final FoodProperties GARNISHED_NUT;
    public static final FoodProperties SWEETENED_NUT;
    public static final FoodProperties CHOCOLATE_GLAZED_NUT;
    public static final FoodProperties HONEYED_NUT;
    public static final FoodProperties GARNISHED_NUT_MIX;
    public static final FoodProperties SWEETENED_NUT_MIX;
    public static final FoodProperties CHOCOLATE_GLAZED_NUT_MIX;
    public static final FoodProperties HONEYED_NUT_MIX;
    public static final FoodProperties GARNISHED_BERRIES;
    public static final FoodProperties HONEYED_BERRIES;
    public static final FoodProperties MELTED_CINDER_FLOUR_NUT;
    public static final FoodProperties MELTED_CINDER_FLOUR_PEANUT;
    public static final FoodProperties MELTED_CINDER_FLOUR_WALNUT;
    public static final FoodProperties MELTED_CINDER_FLOUR_ALMOND;
    public static final FoodProperties MELTED_CINDER_FLOUR_HAZELNUT;
    public static final FoodProperties MELTED_CINDER_FLOUR_CHESTNUT;
    public static final FoodProperties MELTED_CINDER_FLOUR_PISTACHIO;
    public static final FoodProperties MELTED_CINDER_FLOUR_MACADAMIA;
    public static final FoodProperties MELTED_CINDER_FLOUR_PECAN;
    public static final FoodProperties MELTED_CINDER_FLOUR_CASHEW;
    public static final FoodProperties GARNISHED_MEAL;
    public static final FoodProperties SALAD;
    public static final FoodProperties CASHEW_APPLE;
    public static final FoodProperties BITTER_ALMOND;
    public static final FoodProperties WALNUT_BROWNIE;
    public static final FoodProperties PECAN_PIE;
    public static final FoodProperties CASHEW_COOKIE;
    public static final FoodProperties ALMOND_CHEESE;
    public static final FoodProperties PUTRID_STEW;
    public static final FoodProperties NUT_NACHO;
    public static final FoodProperties NUT_NACHO_BOWL;
    public static final FoodProperties ILLUMINATING_COCKTAIL;
    public static final FoodProperties BITTER_APPLE_CIDER;
    public static final FoodProperties CRYPTIC_APPLE_CIDER;
    public static final FoodProperties MULCH;
    public static final FoodProperties MUD_PIE;
    public static final FoodProperties BAKLAVA;
    public static final FoodProperties RAW_TENEBROUS_MEAT;
    public static final FoodProperties COOKED_TENEBROUS_MEAT;
    public static final FoodProperties GLOOMY_GATHERING;
    public static final FoodProperties ACHING_TENEBROUS_CLUMP;
    public static final FoodProperties GHANDERCKEN;
    public static final FoodProperties FISHY_SURPRISE;
    public static final FoodProperties WHEAT_GRAZE;
    public static final FoodProperties PORKCHOP_AND_GRAZE;
    public static final FoodProperties MURKY_JELLY;
    public static final FoodProperties MURKY_MACADAMIA_MALICE;
    public static final FoodProperties NUTTY_MELODY;
    public static final FoodProperties YAM_O_GLOW_PUFFS;
    public static final FoodProperties CACKLING_PIE;
    public static final FoodProperties SHINING_DISH;
    public static final FoodProperties MUESLI;
    public static final FoodProperties GENERIC_DRIED_KELP;
    public static final FoodProperties DRIED_DULSE_KELP;
    public static final FoodProperties VAST_BREW;
    public static final FoodProperties VERMILION_STEW;
    public static final FoodProperties GALVANIC_HAUNTING;
    public static final FoodProperties BEWILDERED_PASTRY;
    public static final FoodProperties INCENDIARY_STEW;
    public static final FoodProperties BAMBOO_CLOD;
    public static final FoodProperties OVERGROWN_BREW;
    public static final FoodProperties MEAT_SCRAPS;
    public static final FoodProperties BOK_CHOY;
    public static final FoodProperties BOARDED_PULP;
    public static final FoodProperties COAL_TRUFFLE;
    public static final FoodProperties MASTIC_PASTE;
    public static final FoodProperties SLIME_DROP;
    public static final FoodProperties MASTIC_COVERED_SLIME_DROP;
    public static final FoodProperties VENERABLE_DELICACY;
    public static final FoodProperties ICY_MASTIC_CHUNK;
    public static final FoodProperties CASHEW_SORBET_SCOOP;
    public static final FoodProperties CASHEW_SORBET_DELIGHT;
    public static final FoodProperties WALNUT_GORGE_CREAM;
    public static final FoodProperties MERRY_TREAT;
    public static final FoodProperties FROSTED_DESSERT;
    public static final FoodProperties VOID_STROGANOFF;
    public static final FoodProperties CHILLED_APPLE;
    public static final FoodProperties RAW_POLAR_BEAR_MEAT;
    public static final FoodProperties COOKED_POLAR_BEAR_MEAT;
    public static final FoodProperties EXPLORERS_CONCOCTION;
    public static final FoodProperties PRICKLY_PEAR;
    public static final FoodProperties NOPALITO_WRAP;
    public static final FoodProperties NOPALITO_WRAP_SUPREME;
    public static final FoodProperties PRICKLY_PEAR_STEW;
    public static final FoodProperties SINOPIA_ROCK_SWEET;
    public static final FoodProperties THORN_ON_A_STICK;
    public static final FoodProperties ROSY_COCKTAIL;
    public static final FoodProperties DUSTY_REGALE;
    public static final FoodProperties STEW_OF_THE_DAMNED;
    public static final FoodProperties PEANUT_OIL_AND_CINDER_SANDWICH;
    public static final FoodProperties TOPHET_BREW;
    public static final FoodProperties GRIM_STEW;
    public static final FoodProperties WEEPING_TANGLE;
    public static final FoodProperties CINDER_ROLL;
    public static final FoodProperties WARPED_BREW;
    public static final FoodProperties BOTTLED_MALODOROUS_MIXTURE;
    public static final FoodProperties PIQUANT_PRETZEL;
    public static final FoodProperties INIQUITOUS_BREW;
    public static final FoodProperties OMNISCIENT_STEW;
    public static final FoodProperties WARPED_TANGLE;
    public static final FoodProperties CRIMSON_TANGLE;
    public static final FoodProperties SEPIA_TANGLE;
    public static final FoodProperties FERMENTED_CASHEW_MIXTURE;
    public static final FoodProperties SOUL_KHANA;
    public static final FoodProperties SPIRITED_CONCOCTION;
    public static final FoodProperties MOLTEN_STEW;
    public static final FoodProperties STURDY_WAFFLE;
    public static final FoodProperties PHANTOM_STEAK;
    public static final FoodProperties BLAZING_DELIGHT;
    public static final FoodProperties SENILE_SWEET;
    public static final FoodProperties CHORUS_COCKTAIL;
    public static final FoodProperties CHAMPIONS_OMELETTE;
    public static final FoodProperties FARSEER_BREW;
    public static final FoodProperties SHELLED_DUMPLING;
    public static final FoodProperties BOTTLED_ENDER_JELLY;
    public static final FoodProperties COSMIC_BREW;
    public static final FoodProperties DESOLATE_STEW;
    public static final FoodProperties ETHEREAL_CONCOCTION;
    public static final FoodProperties VOID_MIXTURE;
    public static final FoodProperties CHORUS_BOWL;
    public static final FoodProperties CHORUS_COOKIE;
    public static final FoodProperties GALACTIC_CANE;
    public static final FoodProperties ENDER_JELLY;
    public static final FoodProperties PECAN_PIE_SLICE;
    public static final FoodProperties PHANTOM_BURGER;
    public static final FoodProperties PHANTOM_BEEF_PATTY;
    public static final FoodProperties GLOW_INK_ROLL;
    public static final FoodProperties GLOW_INK_ROLL_SLICE;
    public static final FoodProperties ANNIVERSARY_CAKE_SLICE;
    public static final FoodProperties BROWNIE_PIECE;

    private GarnishedFoodValues(int nutrition, float saturation) {
        this.nutrition = nutrition;
        this.saturation = saturation;
    }

    private static float mod(float value, boolean isSaturation) {
        if (isSaturation) {
            return value + 0.2f;
        }
        return value + 2.0f;
    }

    public static FoodProperties.Builder ow_min() {
        return new FoodProperties.Builder().nutrition(GarnishedFoodValues.OVERWORLD_MIN.nutrition).saturationModifier(GarnishedFoodValues.OVERWORLD_MIN.saturation);
    }

    public static FoodProperties.Builder ow_max() {
        return new FoodProperties.Builder().nutrition(GarnishedFoodValues.OVERWORLD_MAX.nutrition).saturationModifier(GarnishedFoodValues.OVERWORLD_MAX.saturation);
    }

    public static FoodProperties.Builder nether_min() {
        return new FoodProperties.Builder().nutrition(GarnishedFoodValues.NETHER_MIN.nutrition).saturationModifier(GarnishedFoodValues.NETHER_MIN.saturation);
    }

    public static FoodProperties.Builder nether_max() {
        return new FoodProperties.Builder().nutrition(GarnishedFoodValues.NETHER_MAX.nutrition).saturationModifier(GarnishedFoodValues.NETHER_MAX.saturation);
    }

    public static FoodProperties.Builder end_min() {
        return new FoodProperties.Builder().nutrition(GarnishedFoodValues.END_MIN.nutrition).saturationModifier(GarnishedFoodValues.END_MIN.saturation);
    }

    public static FoodProperties.Builder end_max() {
        return new FoodProperties.Builder().nutrition(GarnishedFoodValues.END_MAX.nutrition).saturationModifier(GarnishedFoodValues.END_MAX.saturation);
    }

    public static FoodProperties.Builder generic(int nutrition, float saturation) {
        return new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturation);
    }

    public static FoodProperties.Builder meltedCinderFlourNut() {
        return GarnishedFoodValues.generic(7, 0.4f);
    }

    public static FoodProperties.Builder wrappedTangle(Holder<MobEffect> effect) {
        return GarnishedFoodValues.nether_min().effect(() -> new MobEffectInstance(effect, 900, 1), 0.8f);
    }

    public static FoodProperties.Builder senileSweet() {
        return new FoodProperties.Builder().nutrition(GarnishedFoodValues.NETHER_MIN.nutrition - 2).saturationModifier(GarnishedFoodValues.NETHER_MIN.saturation - 0.2f);
    }

    public static void setRegister() {
    }

    static {
        UNGARNISHED_NUT = GarnishedFoodValues.ow_min().effect(() -> new MobEffectInstance(MobEffects.CONFUSION, 240), 1.0f).build();
        GARNISHED_NUT = GarnishedFoodValues.generic(4, 0.2f).build();
        SWEETENED_NUT = GarnishedFoodValues.generic((int)GarnishedFoodValues.mod(4.0f, false), 0.2f).build();
        CHOCOLATE_GLAZED_NUT = GarnishedFoodValues.generic(4, GarnishedFoodValues.mod(0.2f, true)).build();
        HONEYED_NUT = GarnishedFoodValues.generic((int)GarnishedFoodValues.mod(4.0f, false), GarnishedFoodValues.mod(0.2f, true)).build();
        GARNISHED_NUT_MIX = GarnishedFoodValues.generic(7, 0.4f).build();
        SWEETENED_NUT_MIX = GarnishedFoodValues.generic((int)GarnishedFoodValues.mod(7.0f, false), 0.4f).build();
        CHOCOLATE_GLAZED_NUT_MIX = GarnishedFoodValues.generic(7, GarnishedFoodValues.mod(0.4f, true)).build();
        HONEYED_NUT_MIX = GarnishedFoodValues.generic((int)GarnishedFoodValues.mod(7.0f, false), GarnishedFoodValues.mod(0.4f, true)).build();
        GARNISHED_BERRIES = GarnishedFoodValues.generic(5, 0.3f).build();
        HONEYED_BERRIES = GarnishedFoodValues.generic((int)GarnishedFoodValues.mod(5.0f, false), GarnishedFoodValues.mod(0.3f, true)).build();
        MELTED_CINDER_FLOUR_NUT = GarnishedFoodValues.meltedCinderFlourNut().build();
        MELTED_CINDER_FLOUR_PEANUT = GarnishedFoodValues.meltedCinderFlourNut().effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 1800), 1.0f).effect(() -> new MobEffectInstance(MobEffects.INVISIBILITY, 1800), 1.0f).build();
        MELTED_CINDER_FLOUR_WALNUT = GarnishedFoodValues.meltedCinderFlourNut().effect(() -> new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1800), 1.0f).build();
        MELTED_CINDER_FLOUR_ALMOND = GarnishedFoodValues.meltedCinderFlourNut().effect(() -> new MobEffectInstance(MobEffects.DIG_SPEED, 1800), 1.0f).build();
        MELTED_CINDER_FLOUR_HAZELNUT = GarnishedFoodValues.meltedCinderFlourNut().effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1800, 1), 1.0f).build();
        MELTED_CINDER_FLOUR_CHESTNUT = GarnishedFoodValues.meltedCinderFlourNut().effect(() -> new MobEffectInstance(MobEffects.SLOW_FALLING, 1800), 1.0f).build();
        MELTED_CINDER_FLOUR_PISTACHIO = GarnishedFoodValues.meltedCinderFlourNut().effect(() -> new MobEffectInstance(MobEffects.NIGHT_VISION, 1800), 1.0f).build();
        MELTED_CINDER_FLOUR_MACADAMIA = GarnishedFoodValues.meltedCinderFlourNut().effect(() -> new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 1800), 1.0f).build();
        MELTED_CINDER_FLOUR_PECAN = GarnishedFoodValues.meltedCinderFlourNut().effect(() -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1800), 1.0f).build();
        MELTED_CINDER_FLOUR_CASHEW = GarnishedFoodValues.meltedCinderFlourNut().effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1800), 1.0f).build();
        GARNISHED_MEAL = GarnishedFoodValues.ow_max().build();
        SALAD = GarnishedFoodValues.generic(8, 0.4f).build();
        CASHEW_APPLE = GarnishedFoodValues.ow_min().effect(() -> new MobEffectInstance(MobEffects.POISON, 1000), 0.25f).fast().build();
        BITTER_ALMOND = GarnishedFoodValues.generic(4, 0.2f).effect(() -> new MobEffectInstance(MobEffects.POISON, 500), 1.0f).build();
        WALNUT_BROWNIE = GarnishedFoodValues.ow_max().build();
        PECAN_PIE = GarnishedFoodValues.ow_max().build();
        CASHEW_COOKIE = GarnishedFoodValues.generic(6, 0.2f).build();
        ALMOND_CHEESE = GarnishedFoodValues.generic(6, 0.4f).build();
        PUTRID_STEW = GarnishedFoodValues.generic(8, 0.6f).effect(() -> new MobEffectInstance(MobEffects.CONFUSION, 200), 1.0f).build();
        NUT_NACHO = GarnishedFoodValues.ow_min().fast().build();
        NUT_NACHO_BOWL = GarnishedFoodValues.ow_max().build();
        ILLUMINATING_COCKTAIL = GarnishedFoodValues.generic(4, 0.8f).effect(() -> new MobEffectInstance(MobEffects.GLOWING, 600, 0), 1.0f).build();
        BITTER_APPLE_CIDER = GarnishedFoodValues.generic(3, 0.2f).effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 800, 1), 1.0f).effect(() -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 800, 2), 1.0f).build();
        CRYPTIC_APPLE_CIDER = GarnishedFoodValues.generic(3, 0.2f).build();
        MULCH = GarnishedFoodValues.ow_min().build();
        MUD_PIE = GarnishedFoodValues.generic(8, 0.15f).build();
        BAKLAVA = GarnishedFoodValues.ow_max().build();
        RAW_TENEBROUS_MEAT = GarnishedFoodValues.generic(4, GarnishedFoodValues.OVERWORLD_MAX.saturation).effect(() -> new MobEffectInstance(MobEffects.DARKNESS, 200), 1.0f).build();
        COOKED_TENEBROUS_MEAT = GarnishedFoodValues.generic(6, GarnishedFoodValues.OVERWORLD_MAX.saturation).effect(() -> new MobEffectInstance(MobEffects.REGENERATION, 200), 0.85f).build();
        GLOOMY_GATHERING = GarnishedFoodValues.ow_max().effect(() -> new MobEffectInstance(MobEffects.REGENERATION, 600), 1.0f).effect(() -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 300), 1.0f).build();
        ACHING_TENEBROUS_CLUMP = GarnishedFoodValues.generic(7, GarnishedFoodValues.OVERWORLD_MAX.saturation).build();
        GHANDERCKEN = GarnishedFoodValues.ow_max().build();
        FISHY_SURPRISE = new FoodProperties.Builder().nutrition(8).saturationModifier(0.4f).effect(() -> new MobEffectInstance(MobEffects.CONFUSION, 300), 1.0f).effect(() -> new MobEffectInstance(MobEffects.POISON, 40), 0.15f).build();
        WHEAT_GRAZE = GarnishedFoodValues.generic(3, 0.1f).build();
        PORKCHOP_AND_GRAZE = GarnishedFoodValues.ow_max().build();
        MURKY_JELLY = GarnishedFoodValues.generic(4, 0.3f).build();
        MURKY_MACADAMIA_MALICE = GarnishedFoodValues.generic(6, 0.4f).build();
        NUTTY_MELODY = GarnishedFoodValues.end_min().build();
        YAM_O_GLOW_PUFFS = GarnishedFoodValues.generic(GarnishedFoodValues.OVERWORLD_MIN.nutrition, 0.2f).fast().build();
        CACKLING_PIE = GarnishedFoodValues.ow_max().build();
        SHINING_DISH = GarnishedFoodValues.generic(GarnishedFoodValues.OVERWORLD_MAX.nutrition, 0.4f).effect(() -> new MobEffectInstance(MobEffects.GLOWING, 300), 0.45f).build();
        MUESLI = GarnishedFoodValues.generic(GarnishedFoodValues.OVERWORLD_MAX.nutrition, 0.6f).build();
        GENERIC_DRIED_KELP = GarnishedFoodValues.generic(2, 0.3f).fast().build();
        DRIED_DULSE_KELP = GarnishedFoodValues.generic(4, GENERIC_DRIED_KELP.saturation()).fast().build();
        VAST_BREW = GarnishedFoodValues.generic(6, 0.3f).effect(() -> new MobEffectInstance(MobEffects.WATER_BREATHING, 400, 0), 0.5f).build();
        VERMILION_STEW = GarnishedFoodValues.generic(7, 0.4f).effect(() -> new MobEffectInstance(MobEffects.WATER_BREATHING, 400, 0), 0.75f).build();
        GALVANIC_HAUNTING = GarnishedFoodValues.ow_max().effect(() -> new MobEffectInstance(MobEffects.WATER_BREATHING, 400, 0), 1.0f).build();
        BEWILDERED_PASTRY = GarnishedFoodValues.generic(6, 0.4f).effect(() -> new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 400, 0), 0.65f).build();
        INCENDIARY_STEW = GarnishedFoodValues.ow_max().build();
        BAMBOO_CLOD = GarnishedFoodValues.generic(4, 0.2f).build();
        OVERGROWN_BREW = GarnishedFoodValues.ow_max().build();
        MEAT_SCRAPS = GarnishedFoodValues.ow_max().build();
        BOK_CHOY = GarnishedFoodValues.ow_min().build();
        BOARDED_PULP = GarnishedFoodValues.generic(6, 0.2f).build();
        COAL_TRUFFLE = GarnishedFoodValues.generic(2, 0.4f).build();
        MASTIC_PASTE = GarnishedFoodValues.ow_min().fast().build();
        SLIME_DROP = GarnishedFoodValues.generic(4, 0.3f).fast().build();
        MASTIC_COVERED_SLIME_DROP = GarnishedFoodValues.generic(6, 0.4f).fast().build();
        VENERABLE_DELICACY = GarnishedFoodValues.ow_max().build();
        ICY_MASTIC_CHUNK = GarnishedFoodValues.ow_min().effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 2), 1.0f).effect(() -> new MobEffectInstance(MobEffects.REGENERATION, 160, 1), 1.0f).fast().build();
        CASHEW_SORBET_SCOOP = GarnishedFoodValues.generic(2, 0.1f).fast().build();
        CASHEW_SORBET_DELIGHT = GarnishedFoodValues.generic(8, 0.4f).build();
        WALNUT_GORGE_CREAM = GarnishedFoodValues.generic(8, 0.6f).build();
        MERRY_TREAT = GarnishedFoodValues.generic(6, 0.4f).effect(() -> new MobEffectInstance(GarnishedEffects.SUGAR_HIGH, 500, 1), 1.0f).build();
        FROSTED_DESSERT = GarnishedFoodValues.generic(6, 0.3f).build();
        VOID_STROGANOFF = GarnishedFoodValues.ow_max().build();
        CHILLED_APPLE = GarnishedFoodValues.generic(5, 0.4f).build();
        RAW_POLAR_BEAR_MEAT = GarnishedFoodValues.generic(5, 0.2f).build();
        COOKED_POLAR_BEAR_MEAT = GarnishedFoodValues.ow_max().build();
        EXPLORERS_CONCOCTION = GarnishedFoodValues.ow_max().build();
        PRICKLY_PEAR = GarnishedFoodValues.generic(GarnishedFoodValues.OVERWORLD_MIN.nutrition, 0.1f).build();
        NOPALITO_WRAP = GarnishedFoodValues.generic(6, 0.65f).build();
        NOPALITO_WRAP_SUPREME = GarnishedFoodValues.generic(8, 0.8f).build();
        PRICKLY_PEAR_STEW = GarnishedFoodValues.generic(6, 0.35f).build();
        SINOPIA_ROCK_SWEET = GarnishedFoodValues.generic(4, 0.2f).build();
        THORN_ON_A_STICK = GarnishedFoodValues.generic(8, 0.4f).build();
        ROSY_COCKTAIL = GarnishedFoodValues.ow_max().effect(() -> new MobEffectInstance(MobEffects.REGENERATION, 100, 4), 1.0f).build();
        DUSTY_REGALE = GarnishedFoodValues.generic(6, 0.2f).build();
        STEW_OF_THE_DAMNED = GarnishedFoodValues.generic(GarnishedFoodValues.OVERWORLD_MAX.nutrition, 0.4f).effect(() -> new MobEffectInstance(GarnishedEffects.THORNS, 700, 4), 1.0f).build();
        PEANUT_OIL_AND_CINDER_SANDWICH = GarnishedFoodValues.generic(7, 0.7f).build();
        TOPHET_BREW = GarnishedFoodValues.generic(7, 0.6f).build();
        GRIM_STEW = GarnishedFoodValues.generic(9, 0.6f).build();
        WEEPING_TANGLE = GarnishedFoodValues.generic(8, 0.4f).build();
        CINDER_ROLL = GarnishedFoodValues.generic(6, 0.25f).build();
        WARPED_BREW = GarnishedFoodValues.generic(8, 0.7f).build();
        BOTTLED_MALODOROUS_MIXTURE = GarnishedFoodValues.nether_min().build();
        PIQUANT_PRETZEL = GarnishedFoodValues.nether_min().build();
        INIQUITOUS_BREW = GarnishedFoodValues.generic(8, 0.7f).effect(() -> new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 1200, 1), 0.8f).build();
        OMNISCIENT_STEW = GarnishedFoodValues.nether_max().effect(() -> new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0), 0.5f).effect(() -> new MobEffectInstance(GarnishedEffects.COGNATE, 1200, 0), 0.75f).build();
        WARPED_TANGLE = GarnishedFoodValues.wrappedTangle((Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE).build();
        CRIMSON_TANGLE = GarnishedFoodValues.wrappedTangle((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).build();
        SEPIA_TANGLE = GarnishedFoodValues.wrappedTangle(GarnishedEffects.SPIRITED_RESISTANCE).build();
        FERMENTED_CASHEW_MIXTURE = GarnishedFoodValues.generic(3, 0.2f).effect(() -> new MobEffectInstance(MobEffects.CONFUSION, 3600, 2), 0.05f).effect(() -> new MobEffectInstance(MobEffects.DAMAGE_BOOST, 3600, 2), 0.05f).build();
        SOUL_KHANA = GarnishedFoodValues.generic(8, 0.6f).effect(() -> new MobEffectInstance(MobEffects.INVISIBILITY, 2400), 1.0f).effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 3000), 1.0f).build();
        SPIRITED_CONCOCTION = GarnishedFoodValues.generic(8, 0.6f).effect(() -> new MobEffectInstance(GarnishedEffects.SPIRITED_RESISTANCE, 900), 1.0f).build();
        MOLTEN_STEW = GarnishedFoodValues.nether_min().effect(() -> new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400), 1.0f).build();
        STURDY_WAFFLE = GarnishedFoodValues.nether_min().effect(() -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 400), 0.75f).build();
        PHANTOM_STEAK = GarnishedFoodValues.nether_max().build();
        BLAZING_DELIGHT = GarnishedFoodValues.nether_max().build();
        SENILE_SWEET = GarnishedFoodValues.senileSweet().fast().build();
        CHORUS_COCKTAIL = GarnishedFoodValues.end_min().build();
        CHAMPIONS_OMELETTE = GarnishedFoodValues.end_max().build();
        FARSEER_BREW = GarnishedFoodValues.generic(12, 0.8f).build();
        SHELLED_DUMPLING = GarnishedFoodValues.end_min().build();
        BOTTLED_ENDER_JELLY = GarnishedFoodValues.generic(3, 0.2f).effect(() -> new MobEffectInstance(GarnishedEffects.COGNATE, 600, 1), 0.5f).build();
        COSMIC_BREW = GarnishedFoodValues.end_min().effect(() -> new MobEffectInstance(MobEffects.NIGHT_VISION, 600, 0), 1.0f).build();
        DESOLATE_STEW = GarnishedFoodValues.end_min().effect(() -> new MobEffectInstance(GarnishedEffects.COGNATE, 1200, 1), 0.2f).build();
        ETHEREAL_CONCOCTION = GarnishedFoodValues.generic(12, 0.6f).effect(() -> new MobEffectInstance(GarnishedEffects.COGNATE, 1200, 1), 0.2f).build();
        VOID_MIXTURE = GarnishedFoodValues.end_min().build();
        CHORUS_BOWL = GarnishedFoodValues.end_max().build();
        CHORUS_COOKIE = GarnishedFoodValues.generic(3, 0.2f).effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200, 1), 0.5f).build();
        GALACTIC_CANE = GarnishedFoodValues.end_min().effect(() -> new MobEffectInstance(GarnishedEffects.COGNATE, 200, 1), 1.0f).build();
        ENDER_JELLY = GarnishedFoodValues.generic(4, 0.3f).build();
        PECAN_PIE_SLICE = GarnishedFoodValues.generic(3, 0.2f).build();
        PHANTOM_BURGER = GarnishedFoodValues.nether_max().build();
        PHANTOM_BEEF_PATTY = GarnishedFoodValues.nether_min().build();
        GLOW_INK_ROLL = GarnishedFoodValues.generic(10, 0.4f).fast().build();
        GLOW_INK_ROLL_SLICE = GarnishedFoodValues.generic(4, 0.3f).fast().build();
        ANNIVERSARY_CAKE_SLICE = GarnishedFoodValues.generic(4, 0.2f).fast().build();
        BROWNIE_PIECE = GarnishedFoodValues.generic(3, 0.2f).fast().build();
    }
}

