/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.item.hatchet.tier.integrated;

import java.util.List;
import net.dakotapride.garnished.GarnishedUtils;
import net.dakotapride.garnished.item.hatchet.IntegratedHatchetToolItem;
import net.dakotapride.garnished.item.hatchet.IntegratedMaterials;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlazingHatchetToolItem
extends IntegratedHatchetToolItem {
    public BlazingHatchetToolItem(Item.Properties properties) {
        super(GarnishedUtils.stuffAndAdditions(), IntegratedMaterials.BLAZING, properties);
    }

    public boolean mineBlock(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull BlockState blockstate, BlockPos pos, @NotNull LivingEntity entity) {
        BlazingHatchetToolItem.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)entity, itemstack);
        return super.mineBlock(itemstack, world, blockstate, pos, entity);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        BlazingHatchetToolItem.execute((Entity)target, stack);
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext ctx, List<Component> components, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.literal((String)"\u00a78Hold [\u00a7fShift\u00a78] for Summary"));
            components.add((Component)Component.literal((String)" "));
            components.add((Component)Component.literal((String)"\u00a75As hot as an authentic blaze !"));
            components.add((Component)Component.literal((String)" "));
            components.add((Component)Component.literal((String)"\u00a77When Used"));
            components.add((Component)Component.literal((String)"\u00a7d Smelt\u00a75 the block the tools break"));
        } else {
            components.add((Component)Component.literal((String)"\u00a78Hold [\u00a77Shift\u00a78] for Summary"));
        }
        super.appendHoverText(stack, ctx, components, tooltipFlag);
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
    }

    public static void execute(Entity entity, ItemStack itemstack) {
        if (entity != null) {
            entity.setRemainingFireTicks(15);
            if (entity.level().dimension() == Level.NETHER) {
                itemstack.setDamageValue(itemstack.getDamageValue() - 1);
            }
        }
    }
}

