/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.item;

import java.util.List;
import net.dakotapride.garnished.item.IGarnishedUtilities;
import net.dakotapride.garnished.registry.GarnishedFoodValues;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class IncendiaryStewFoodItem
extends Item
implements IGarnishedUtilities {
    public IncendiaryStewFoodItem(Item.Properties properties) {
        super(properties.food(GarnishedFoodValues.INCENDIARY_STEW).stacksTo(1));
    }

    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext context, List<Component> tooltip, @NotNull TooltipFlag adv) {
        tooltip.add((Component)Component.translatable((String)"text.garnished.incendiary_stew.desc").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, Level level, @NotNull LivingEntity entity) {
        if (!level.isClientSide) {
            PrimedTnt primedtnt = new PrimedTnt(level, (double)entity.blockPosition().getX() + 0.5, (double)entity.blockPosition().getY(), (double)entity.blockPosition().getZ() + 0.5, entity);
            int i = primedtnt.getFuse();
            primedtnt.setFuse((int)((short)(level.random.nextInt(i / 4) + i / 8)));
            level.addFreshEntity((Entity)primedtnt);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getCooldowns().addCooldown(stack.getItem(), 30);
        }
        return super.finishUsingItem(stack, level, entity);
    }
}

