/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.item;

import java.util.List;
import net.dakotapride.garnished.item.IGarnishedUtilities;
import net.dakotapride.garnished.registry.GarnishedEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ConditionalEffectItem
extends Item
implements IGarnishedUtilities {
    int value;
    float chance;

    public ConditionalEffectItem(int value, float chance, Item.Properties pProperties) {
        super(pProperties);
        this.value = value;
        this.chance = chance;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity entity) {
        Player playerentity;
        Player player = playerentity = entity instanceof Player ? (Player)entity : null;
        if (playerentity instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)playerentity, stack);
        }
        if (!world.isClientSide) {
            this.triggerConditionalEffect(this.value, this.chance, entity);
        }
        return super.finishUsingItem(stack, world, entity);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (this.value == 0) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"text.garnished.conditional_effect.from_sugar_high").withStyle(ChatFormatting.GRAY));
            this.addEffectTooltipConditionalPositive(tooltip, MobEffects.REGENERATION, 240.0f);
        }
        if (this.value == 1) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"text.garnished.conditional_effect.from_freezing").withStyle(ChatFormatting.GRAY));
            this.addEffectTooltipConditionalPositive(tooltip, MobEffects.REGENERATION, 240.0f);
        }
        if (this.value == 2) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"text.garnished.conditional_effect.from_hunger").withStyle(ChatFormatting.GRAY));
            this.addEffectTooltipConditionalPositive(tooltip, (Holder)GarnishedEffects.THORNS, 480.0f);
        }
        if (this.value == 3) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"text.garnished.conditional_effect.from_levitation").withStyle(ChatFormatting.GRAY));
            this.addEffectTooltipConditionalPositive(tooltip, MobEffects.SLOW_FALLING, 480.0f);
        }
        if (this.value == 4) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"text.garnished.conditional_effect.from_bad_omen_conditions.not_present").withStyle(ChatFormatting.GRAY));
            this.addEffectTooltipConditionalPositive(tooltip, MobEffects.DAMAGE_RESISTANCE, 720.0f);
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"text.garnished.conditional_effect.from_bad_omen_conditions.present").withStyle(ChatFormatting.GRAY));
            this.addEffectTooltipConditionalNegative(tooltip, MobEffects.WEAKNESS, 720.0f);
        }
        if (this.value == 5) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"text.garnished.conditional_effect.from_flame").withStyle(ChatFormatting.GRAY));
            this.addEffectTooltipConditionalPositive(tooltip, MobEffects.FIRE_RESISTANCE, 480.0f);
        }
        if (this.value == 6) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"text.garnished.conditional_effect.upon_consumption").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"text.garnished.conditional_effect.cryptic_apple_cider"));
        }
    }
}

