/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.datagen;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.dakotapride.garnished.datagen.CreateGarnishedAdvancement;
import net.dakotapride.garnished.registry.GarnishedItems;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public class CreateGarnishedAdvancements
implements DataProvider {
    public static final List<CreateGarnishedAdvancement> ENTRIES = new ArrayList<CreateGarnishedAdvancement>();
    public static final CreateGarnishedAdvancement START = null;
    public static final CreateGarnishedAdvancement ROOT = CreateGarnishedAdvancements.create("nut_tree", b -> b.icon((ItemProviderEntry<?, ?>)GarnishedItems.UNGARNISHED_WALNUT).title("Vast Wilderness").description("Obtain Ungarnished Nuts by exploring the world").special(CreateGarnishedAdvancement.TaskType.SILENT));
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    private static CreateGarnishedAdvancement create(String id, UnaryOperator<CreateGarnishedAdvancement.Builder> b) {
        return new CreateGarnishedAdvancement(id, b);
    }

    public CreateGarnishedAdvancements(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this.output = output;
        this.registries = registries;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.registries.thenCompose(provider -> {
            PackOutput.PathProvider pathProvider = this.output.createPathProvider(PackOutput.Target.DATA_PACK, "advancement");
            ArrayList futures = new ArrayList();
            HashSet set = Sets.newHashSet();
            Consumer<AdvancementHolder> consumer = advancement -> {
                ResourceLocation id = advancement.id();
                if (!set.add(id)) {
                    throw new IllegalStateException("Duplicate advancement " + String.valueOf(id));
                }
                Path path = pathProvider.json(id);
                LOGGER.info("Saving advancement {}", (Object)id);
                futures.add(DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)provider, (Codec)Advancement.CODEC, (Object)advancement.value(), (Path)path));
            };
            for (CreateGarnishedAdvancement advancement2 : ENTRIES) {
                advancement2.save(consumer, (HolderLookup.Provider)provider);
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "Create: Garnished's Advancements";
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (CreateGarnishedAdvancement advancement : ENTRIES) {
            advancement.provideLang(consumer);
        }
    }

    public static void register() {
    }
}

