/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.block;

import com.mojang.serialization.MapCodec;
import java.util.function.ToIntFunction;
import net.dakotapride.garnished.block.ISenileSpread;
import net.dakotapride.garnished.registry.GarnishedBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;

public class NetherLichenBlock
extends MultifaceBlock
implements ISenileSpread {
    public static final MapCodec<NetherLichenBlock> CODEC = NetherLichenBlock.simpleCodec(NetherLichenBlock::new);
    private final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceBlock)this);

    public NetherLichenBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected MapCodec<? extends MultifaceBlock> codec() {
        return CODEC;
    }

    public static ToIntFunction<BlockState> emission(int pLight) {
        return p_181221_ -> MultifaceBlock.hasAnyFace((BlockState)p_181221_) ? pLight : 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        return !pUseContext.getItemInHand().is(((NetherLichenBlock)GarnishedBlocks.SORROWFUL_LICHEN.get()).asItem()) || super.canBeReplaced(pState, pUseContext);
    }

    @Override
    public boolean isValidTarget(BlockGetter pLevel, BlockPos pPos, BlockState pState, boolean isClient) {
        return Direction.stream().anyMatch(p_153316_ -> this.spreader.canSpreadInAnyDirection(pState, pLevel, pPos, p_153316_.getOpposite()));
    }

    @Override
    public boolean isSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    @Override
    public void performSpread(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        this.spreader.spreadFromRandomFaceTowardRandomDirection(pState, (LevelAccessor)pLevel, pPos, pRandom);
    }

    @Override
    public SimpleParticleType getParticle() {
        return ParticleTypes.SOUL;
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.getFluidState().isEmpty();
    }

    public MultifaceSpreader getSpreader() {
        return this.spreader;
    }
}

