/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished;

import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import net.createmod.catnip.lang.FontHelper;
import net.dakotapride.garnished.block.cake.AnniversaryCakeBlockRenderer;
import net.dakotapride.garnished.entity.render.NutBoatRenderer;
import net.dakotapride.garnished.neoforge.LootModifiers;
import net.dakotapride.garnished.recipe.GarnishedFanProcessing;
import net.dakotapride.garnished.registry.GarnishedAdvancementUtils;
import net.dakotapride.garnished.registry.GarnishedBlockEntities;
import net.dakotapride.garnished.registry.GarnishedBlocks;
import net.dakotapride.garnished.registry.GarnishedCT;
import net.dakotapride.garnished.registry.GarnishedEffects;
import net.dakotapride.garnished.registry.GarnishedEntities;
import net.dakotapride.garnished.registry.GarnishedFeatures;
import net.dakotapride.garnished.registry.GarnishedFluids;
import net.dakotapride.garnished.registry.GarnishedFoodValues;
import net.dakotapride.garnished.registry.GarnishedItemAttributeTypes;
import net.dakotapride.garnished.registry.GarnishedItems;
import net.dakotapride.garnished.registry.GarnishedSetTypes;
import net.dakotapride.garnished.registry.GarnishedTabs;
import net.dakotapride.garnished.registry.GarnishedTags;
import net.dakotapride.garnished.registry.GarnishedWoodType;
import net.dakotapride.garnished.registry.ZultaniteStoneTypes;
import net.dakotapride.garnished.registry.recipe.GarnishedRecipeTypes;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="garnished")
public class CreateGarnished {
    public static final String ID = "garnished";
    public static final String NAME = "Create: Garnished";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Create: Garnished");
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"garnished").defaultCreativeTab((ResourceKey)null);

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public CreateGarnished(IEventBus eventBus, ModContainer modContainer) {
        GarnishedEntities.register(eventBus);
        GarnishedEffects.setRegister(eventBus);
        GarnishedSetTypes.setRegister();
        GarnishedItems.setRegister();
        GarnishedBlocks.setRegister();
        GarnishedBlockEntities.register(eventBus);
        GarnishedCT.setRegister();
        GarnishedTabs.setRegister(eventBus);
        GarnishedFluids.setRegister();
        GarnishedFoodValues.setRegister();
        GarnishedFeatures.setRegister(eventBus);
        GarnishedTags.setRegister();
        GarnishedRecipeTypes.register(eventBus);
        LootModifiers.register(eventBus);
        GarnishedAdvancementUtils.register(eventBus);
        GarnishedFanProcessing.register(eventBus);
        GarnishedItemAttributeTypes.register(eventBus);
        REGISTRATE.registerEventListeners(eventBus);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::enqueueIMC);
        eventBus.addListener(this::processIMC);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onBrewingRecipeRegister(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.AWKWARD, (Item)GarnishedItems.BRITTLE_DUST.get(), GarnishedEffects.AVERSION_POTION);
        builder.addMix(GarnishedEffects.AVERSION_POTION, Items.REDSTONE, GarnishedEffects.LONG_AVERSION_POTION);
        builder.addMix(Potions.AWKWARD, (Item)GarnishedItems.ENDER_JELLY_BLOB.get(), GarnishedEffects.FLAGRANT_POTION);
        builder.addMix(Potions.AWKWARD, (Item)GarnishedItems.SENILE_SWEET_BLACKSTONE.get(), GarnishedEffects.BLINDNESS_POTION);
        builder.addMix(Potions.AWKWARD, (Item)GarnishedItems.SENILE_SWEET_BASALT.get(), Potions.WEAKNESS);
        builder.addMix(Potions.AWKWARD, (Item)GarnishedItems.SENILE_SWEET_SCORIA.get(), Potions.POISON);
        builder.addMix(Potions.AWKWARD, (Item)GarnishedItems.SENILE_SWEET_SCORCHIA.get(), Potions.SLOWNESS);
        builder.addMix(Potions.AWKWARD, (Item)GarnishedItems.VOLATILE_DUST.get(), GarnishedEffects.SANCTITY_POTION);
        builder.addMix(Potions.MUNDANE, (Item)GarnishedItems.SOLEMN_DUST.get(), GarnishedEffects.MUMMIFICATION_POTION);
        builder.addMix(Potions.THICK, (Item)GarnishedItems.FROST.get(), GarnishedEffects.FREEZING_POTION);
        builder.addMix(GarnishedEffects.FREEZING_POTION, Items.REDSTONE, GarnishedEffects.LONG_FREEZING_POTION);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(GarnishedFluids::registerFluidInteractions);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(GarnishedBlocks.SEPIA_FUNGUS.getId(), GarnishedBlocks.POTTED_SEPIA_FUNGUS);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(GarnishedBlocks.SOUL_ROOTS.getId(), GarnishedBlocks.POTTED_SOUL_ROOTS);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(GarnishedBlocks.BARREN_ROOTS.getId(), GarnishedBlocks.POTTED_BARREN_ROOTS);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(GarnishedBlocks.SMALL_CHORUS_PLANT.getId(), GarnishedBlocks.POTTED_SMALL_CHORUS_PLANT);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(GarnishedBlocks.PANSOPHICAL_DAISY.getId(), GarnishedBlocks.POTTED_PANSOPHICAL_DAISY);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(GarnishedBlocks.INCANDESCENT_LILY.getId(), GarnishedBlocks.POTTED_INCANDESCENT_LILY);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(GarnishedBlocks.AUREATE_SHRUB.getId(), GarnishedBlocks.POTTED_AUREATE_SHRUB);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE));
    }

    @EventBusSubscriber(modid="garnished", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        public static final ModelLayerLocation NUT_BOAT_LAYER = new ModelLayerLocation(CreateGarnished.asResource("boat/nut"), "main");
        public static final ModelLayerLocation NUT_CHEST_BOAT_LAYER = new ModelLayerLocation(CreateGarnished.asResource("chest_boat/nut"), "main");

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            Sheets.addWoodType((WoodType)GarnishedWoodType.NUT);
            Sheets.addWoodType((WoodType)GarnishedWoodType.SEPIA);
            EntityRenderers.register((EntityType)((EntityType)GarnishedEntities.NUT_BOAT.get()), pContext -> new NutBoatRenderer(pContext, false));
            EntityRenderers.register((EntityType)((EntityType)GarnishedEntities.NUT_CHEST_BOAT.get()), pContext -> new NutBoatRenderer(pContext, true));
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.NUT_PLANT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.NUT_LEAVES.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.UNASSIGNED_NUT_LEAVES.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.ALMOND_LEAVES.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.CASHEW_LEAVES.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.WALNUT_LEAVES.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.PECAN_LEAVES.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.BUHG_LEAVES.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.PISTACHIO_LEAVES.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.MACADAMIA_LEAVES.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.HAZELNUT_LEAVES.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.CHESTNUT_LEAVES.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.ALMOND_SAPLING.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.CASHEW_SAPLING.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.WALNUT_SAPLING.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.PECAN_SAPLING.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.BUHG_SAPLING.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.PISTACHIO_SAPLING.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.MACADAMIA_SAPLING.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.HAZELNUT_SAPLING.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.CHESTNUT_SAPLING.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.SEPIA_FUNGUS.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.SEPIA_DOOR.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.SEPIA_TRAPDOOR.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.SEPIA_WINDOW.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.SEPIA_WINDOW_PANE.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.SOUL_ROOTS.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.BLOCK_OF_ENDER_JELLY.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.BARREN_ROOTS.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.SMALL_CHORUS_PLANT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.NUT_DOOR.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.NUT_TRAPDOOR.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.NUT_WINDOW.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.NUT_WINDOW_PANE.get()), (RenderType)RenderType.cutout());
            for (ZultaniteStoneTypes types : ZultaniteStoneTypes.values()) {
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)types.getSlimeLikeBlock().get()), (RenderType)RenderType.translucent());
            }
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.VERMILION_KELP.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.VERMILION_KELP_PLANT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.DULSE_KELP.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.DULSE_KELP_PLANT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.VOLTAIC_SEA_GRASS.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.PANSOPHICAL_DAISY.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.POTTED_PANSOPHICAL_DAISY.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.INCANDESCENT_LILY.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.POTTED_INCANDESCENT_LILY.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.SORROWFUL_LICHEN.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.AUREATE_SHRUB.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.POTTED_SEPIA_FUNGUS.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.POTTED_SOUL_ROOTS.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.POTTED_BARREN_ROOTS.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.POTTED_SMALL_CHORUS_PLANT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.POTTED_AUREATE_SHRUB.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)GarnishedBlocks.BOK_CHOY_PLANT.get()), (RenderType)RenderType.cutout());
        }

        @SubscribeEvent
        public static void registerEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)GarnishedBlockEntities.SIGN.get(), SignRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)GarnishedBlockEntities.HANGING_SIGN.get(), HangingSignRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)GarnishedBlockEntities.CAKE.get(), AnniversaryCakeBlockRenderer::new);
        }

        @SubscribeEvent
        public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(NUT_BOAT_LAYER, BoatModel::createBodyModel);
            event.registerLayerDefinition(NUT_CHEST_BOAT_LAYER, ChestBoatModel::createBodyModel);
        }

        @SubscribeEvent
        public static void onAddPackFinders(AddPackFindersEvent event) {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                ClientModEvents.registerBuiltinResourcePack(event, "legacy_amber");
            }
        }

        private static void registerBuiltinResourcePack(AddPackFindersEvent event, String folder) {
            event.addPackFinders(CreateGarnished.asResource("resourcepacks/" + folder), PackType.CLIENT_RESOURCES, (Component)Component.literal((String)("garnished/" + folder)), PackSource.BUILT_IN, false, Pack.Position.TOP);
        }
    }
}

