/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.buddy.items;

import de.keksuccino.fancymenu.customization.layout.editor.buddy.TamagotchiBuddy;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class PlayBall {
    public static final ResourceLocation TEXTURE_BALL = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/buddy/ball.png");
    public static final int CATCH_DISTANCE = 25;
    public static final int INACTIVITY_TIMEOUT = 400;
    public static final int USER_INACTIVITY_TIMEOUT = 200;
    public int x;
    public int y;
    public float velocityX = 0.0f;
    public float velocityY = 0.0f;
    public int inactivityTimer = 0;
    public int userInactivityTimer = 0;
    public final int size = 12;
    public int kickCooldown = 0;
    public boolean isUp = false;
    public boolean isRolling = false;
    public boolean isGrabbedByBuddy = false;
    public boolean wasKickedByUser = false;
    public boolean isDragged = false;
    public float gravity = 0.2f;
    public float groundY;
    public int holdTimer = 0;
    public float playBouncePhase = 0.0f;
    public float playBounceSpeed = 0.15f;
    public static final int VELOCITY_SAMPLE_SIZE = 5;
    public int[] recentMouseX = new int[5];
    public int[] recentMouseY = new int[5];
    public long[] recentMouseTimes = new long[5];
    public int mouseSampleIndex = 0;
    public boolean hasFullSamples = false;
    public final TamagotchiBuddy buddy;
    public final Random random;
    public boolean stickToCursor = false;
    public boolean justCreated = true;

    public PlayBall(int x, int y, TamagotchiBuddy buddy) {
        this.x = x;
        this.y = y;
        this.buddy = buddy;
        this.groundY = buddy.getBuddyPosY() + buddy.getSpriteHeight() - 12;
        this.inactivityTimer = 0;
        this.userInactivityTimer = 0;
        this.random = new Random();
    }

    public void resetInactivityTimer() {
        this.inactivityTimer = 0;
    }

    public void resetUserInactivityTimer() {
        this.userInactivityTimer = 0;
        this.inactivityTimer = 0;
    }

    public void render(GuiGraphics graphics) {
        float speed;
        if (this.isGrabbedByBuddy) {
            this.x = this.buddy.getBuddyPosX() + this.buddy.getSpriteWidth() / 2;
            this.playBouncePhase += this.playBounceSpeed;
            if ((double)this.playBouncePhase > Math.PI * 2) {
                this.playBouncePhase = (float)((double)this.playBouncePhase - Math.PI * 2);
            }
            float amplitude = 10 + this.buddy.getCurrentFrame() % 2 * 5;
            this.y = this.buddy.getBuddyPosY() - 20 - (int)(Math.sin(this.playBouncePhase) * (double)amplitude);
        }
        int drawY = this.y;
        if (this.isRolling && this.buddy.getAnimationRenderTicks() % 20 < 10) {
            drawY -= 2;
        }
        if ((speed = (float)Math.sqrt(this.velocityX * this.velocityX + this.velocityY * this.velocityY)) > 5.0f && !this.isGrabbedByBuddy && !this.isDragged && !this.stickToCursor) {
            float trailLength = Math.min(speed / 2.0f, 3.0f);
            int i = 1;
            while ((float)i <= trailLength) {
                float alpha = 0.7f - (float)i / trailLength * 0.6f;
                int trailColor = (int)(alpha * 255.0f) << 24 | 0xFFFFFF;
                int trailX = this.x - (int)(this.velocityX * 0.5f * (float)i);
                int trailY = this.y - (int)(this.velocityY * 0.5f * (float)i);
                DrawableColor.of(new Color(trailColor)).setAsShaderColor(graphics);
                graphics.blit(TEXTURE_BALL, trailX - 6, trailY - 6, 0.0f, 0.0f, 12, 12, 12, 12);
                RenderingUtils.resetShaderColor(graphics);
                ++i;
            }
        }
        graphics.blit(TEXTURE_BALL, this.x - 6, drawY - 6, 0.0f, 0.0f, 12, 12, 12, 12);
    }

    public void tick() {
        boolean isFarFromBuddy;
        this.justCreated = false;
        ++this.inactivityTimer;
        ++this.userInactivityTimer;
        if (this.isDragged || this.stickToCursor) {
            if (this.stickToCursor) {
                this.x = MouseInput.getMouseX();
                this.y = MouseInput.getMouseY();
            }
            return;
        }
        if (this.isGrabbedByBuddy) {
            this.resetInactivityTimer();
            ++this.holdTimer;
            if (this.holdTimer > 40) {
                this.buddyThrowBallUp();
            }
            return;
        }
        if (this.kickCooldown > 0) {
            --this.kickCooldown;
        }
        if (this.isUp) {
            this.velocityY += this.gravity;
            this.y = (int)((float)this.y + this.velocityY);
            this.x = (int)((float)this.x + this.velocityX);
            if ((float)this.y >= this.groundY) {
                this.y = (int)this.groundY;
                if (Math.abs(this.velocityY) < 1.0f) {
                    this.isUp = false;
                    this.isRolling = true;
                    this.velocityX = (this.buddy.isFacingLeft() ? -1 : 1) * 2;
                } else {
                    this.velocityY = -this.velocityY * 0.6f;
                }
            }
            if (this.x < 10 || this.x > this.buddy.getScreenWidth() - 10) {
                this.velocityX = -this.velocityX * 0.8f;
                this.x = Math.max(10, Math.min(this.buddy.getScreenWidth() - 10, this.x));
            }
        } else if (this.isRolling) {
            this.x = (int)((float)this.x + this.velocityX);
            this.velocityX *= 0.98f;
            if (Math.abs(this.velocityX) < 0.1f) {
                this.velocityX = 0.0f;
                this.isRolling = false;
            }
            if (this.x < 10 || this.x > this.buddy.getScreenWidth() - 10) {
                this.velocityX = -this.velocityX * 0.8f;
                this.x = Math.max(10, Math.min(this.buddy.getScreenWidth() - 10, this.x));
            }
        }
        boolean bl = isFarFromBuddy = !this.isNearBuddy(this.buddy.getBuddyPosX() + this.buddy.getSpriteWidth() / 2, this.buddy.getBuddyPosY() + this.buddy.getSpriteHeight() / 2);
        if (isFarFromBuddy && !this.buddy.isChasingBall() && !this.wasKickedByUser) {
            this.buddy.setChasingBall(true);
            this.buddy.setPlaying(false);
            this.resetInactivityTimer();
        }
        if (this.wasKickedByUser && this.kickCooldown <= 0) {
            this.wasKickedByUser = false;
        }
    }

    public void buddyThrowBallUp() {
        if (this.justCreated) {
            return;
        }
        this.isGrabbedByBuddy = false;
        this.holdTimer = 0;
        this.isUp = true;
        this.resetInactivityTimer();
        this.velocityY = -6.0f;
        this.velocityX = (this.buddy.isFacingLeft() ? -2.0f : 2.0f) + (this.random.nextFloat() - 0.5f) * 2.0f;
        this.kickCooldown = 30;
    }

    public void setGrabbedByBuddy(boolean grabbedByBuddy) {
        this.isGrabbedByBuddy = grabbedByBuddy;
        if (grabbedByBuddy) {
            this.resetInactivityTimer();
            this.holdTimer = 0;
            this.isUp = false;
            this.isRolling = false;
            this.velocityX = 0.0f;
            this.velocityY = 0.0f;
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)(this.x - 6) && mouseX < (double)(this.x + 6) && mouseY >= (double)(this.y - 6) && mouseY < (double)(this.y + 6);
    }

    public void pickup(int mouseX, int mouseY) {
        if (this.justCreated) {
            return;
        }
        this.setBeingDragged(true);
        this.resetUserInactivityTimer();
        for (int i = 0; i < 5; ++i) {
            this.recentMouseX[i] = mouseX;
            this.recentMouseY[i] = mouseY;
            this.recentMouseTimes[i] = System.currentTimeMillis();
        }
        this.mouseSampleIndex = 0;
        this.hasFullSamples = false;
        this.x = mouseX;
        this.y = mouseY;
        if (this.isGrabbedByBuddy) {
            this.isGrabbedByBuddy = false;
            this.buddy.setHoldingBall(false);
        }
        this.buddy.increaseFunLevel(2.0f);
    }

    public void updateDragPosition(int mouseX, int mouseY) {
        if (!this.isDragged) {
            return;
        }
        this.x = mouseX;
        this.y = mouseY;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.recentMouseTimes[this.mouseSampleIndex] > 20L) {
            this.mouseSampleIndex = (this.mouseSampleIndex + 1) % 5;
            this.recentMouseX[this.mouseSampleIndex] = mouseX;
            this.recentMouseY[this.mouseSampleIndex] = mouseY;
            this.recentMouseTimes[this.mouseSampleIndex] = currentTime;
            if (this.mouseSampleIndex == 0) {
                this.hasFullSamples = true;
            }
        }
    }

    public void throwBall(int mouseX, int mouseY) {
        if (this.justCreated) {
            return;
        }
        this.isDragged = false;
        this.resetUserInactivityTimer();
        float throwPowerX = 0.0f;
        float throwPowerY = 0.0f;
        if (this.hasFullSamples) {
            int oldestIdx = (this.mouseSampleIndex + 1) % 5;
            int deltaX = this.recentMouseX[this.mouseSampleIndex] - this.recentMouseX[oldestIdx];
            int deltaY = this.recentMouseY[this.mouseSampleIndex] - this.recentMouseY[oldestIdx];
            long deltaTime = this.recentMouseTimes[this.mouseSampleIndex] - this.recentMouseTimes[oldestIdx];
            if (deltaTime > 10L) {
                float velocityScale = 0.2f;
                throwPowerX = (float)deltaX * velocityScale / ((float)deltaTime / 60.0f);
                throwPowerY = (float)deltaY * velocityScale / ((float)deltaTime / 60.0f);
            }
        }
        if (Math.abs(throwPowerX) < 0.5f && Math.abs(throwPowerY) < 0.5f) {
            throwPowerX = this.buddy.isFacingLeft() ? -3.0f : 3.0f;
            throwPowerY = -4.0f;
        }
        float maxPower = 12.0f;
        float currentPower = (float)Math.sqrt(throwPowerX * throwPowerX + throwPowerY * throwPowerY);
        if (currentPower > maxPower) {
            float scaleFactor = maxPower / currentPower;
            throwPowerX *= scaleFactor;
            throwPowerY *= scaleFactor;
        }
        this.x = mouseX;
        this.y = mouseY;
        this.isUp = true;
        this.velocityX = throwPowerX;
        this.velocityY = throwPowerY;
        this.kickCooldown = 20;
        this.wasKickedByUser = true;
        if (this.buddy.isPlaying()) {
            this.buddy.setPlaying(false);
            this.buddy.setChasingBall(true);
        }
        this.buddy.increaseFunLevel(10.0f);
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean isBeingDragged() {
        return this.isDragged;
    }

    public void setBeingDragged(boolean dragged) {
        this.isDragged = dragged;
    }

    public boolean shouldRemove() {
        return this.inactivityTimer > 400 || this.userInactivityTimer > 200;
    }

    public boolean isNearBuddy(int buddyX, int buddyY) {
        int dx = this.x - buddyX;
        int dy = this.y - buddyY;
        return Math.sqrt(dx * dx + dy * dy) < 25.0;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isGrabbedByBuddy() {
        return this.isGrabbedByBuddy;
    }
}

