/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.commands.variable.command.VariableCommandPacket;
import de.keksuccino.konkrete.command.CommandUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class VariableCommand {
    public static final Map<String, List<String>> CACHED_VARIABLE_SUGGESTIONS = Collections.synchronizedMap(new HashMap());

    public static void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fmvariable").then(Commands.literal((String)"get").then(Commands.argument((String)"variable_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CommandUtils.getStringSuggestions((SuggestionsBuilder)builder, (String[])VariableCommand.getVariableNameSuggestions(((CommandSourceStack)context.getSource()).getPlayerOrException()))).executes(stack -> VariableCommand.getVariable((CommandSourceStack)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"variable_name")))))).then(Commands.literal((String)"set").then(Commands.argument((String)"variable_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CommandUtils.getStringSuggestions((SuggestionsBuilder)builder, (String[])VariableCommand.getVariableNameSuggestions(((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"send_chat_feedback", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"set_to_value", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> CommandUtils.getStringSuggestions((SuggestionsBuilder)builder, (String[])new String[]{"<set_to_value>"})).executes(stack -> VariableCommand.setVariable((CommandSourceStack)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"variable_name"), StringArgumentType.getString((CommandContext)stack, (String)"set_to_value"), BoolArgumentType.getBool((CommandContext)stack, (String)"send_chat_feedback"))))))));
    }

    private static String[] getVariableNameSuggestions(ServerPlayer sender) {
        ArrayList<String> l = new ArrayList<String>(Objects.requireNonNullElse(CACHED_VARIABLE_SUGGESTIONS.get(sender.getUUID().toString()), new ArrayList()));
        if (l.isEmpty()) {
            l.add("<no_variables_found>");
        }
        return l.toArray(new String[0]);
    }

    private static int getVariable(CommandSourceStack stack, String variableName) {
        try {
            if (variableName != null) {
                ServerPlayer sender = stack.getPlayerOrException();
                VariableCommandPacket packet = new VariableCommandPacket();
                packet.set = false;
                packet.variable_name = variableName;
                PacketHandler.sendToClient(sender, packet);
            }
        }
        catch (Exception ex) {
            stack.sendFailure((Component)Component.literal((String)"Error while executing command!"));
            ex.printStackTrace();
        }
        return 1;
    }

    private static int setVariable(CommandSourceStack stack, String variableName, String setToValue, boolean sendFeedback) {
        try {
            if (variableName != null && setToValue != null) {
                ServerPlayer sender = stack.getPlayerOrException();
                VariableCommandPacket packet = new VariableCommandPacket();
                packet.set = true;
                packet.variable_name = variableName;
                packet.set_to_value = setToValue;
                packet.feedback = sendFeedback;
                PacketHandler.sendToClient(sender, packet);
            }
        }
        catch (Exception ex) {
            stack.sendFailure((Component)Component.literal((String)"Error while executing command!"));
            ex.printStackTrace();
        }
        return 1;
    }
}

