/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour;

import com.mojang.serialization.DataResult;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrinterBlockEntity;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.PrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.registry.CEIDataMaps;
import plus.dragons.createenchantmentindustry.config.CEIConfig;
import plus.dragons.createenchantmentindustry.util.CEILang;

public class CustomNamePrintingBehaviour
implements PrintingBehaviour {
    private final SmartFluidTankBehaviour tank;
    private final Component name;

    private CustomNamePrintingBehaviour(SmartFluidTankBehaviour tank, Component name) {
        this.tank = tank;
        this.name = name;
    }

    public static Optional<DataResult<PrintingBehaviour>> create(Level level, SmartFluidTankBehaviour tank, ItemStack stack) {
        if (stack.is(Items.NAME_TAG)) {
            Component name = (Component)stack.get(DataComponents.CUSTOM_NAME);
            if (name == null) {
                return Optional.empty();
            }
            return Optional.of(DataResult.success((Object)new CustomNamePrintingBehaviour(tank, (Component)name.copy())));
        }
        return Optional.empty();
    }

    @Override
    public int getRequiredItemCount(Level level, ItemStack stack) {
        return stack.getCount();
    }

    @Override
    public int getRequiredFluidAmount(Level level, ItemStack stack, FluidStack fluidStack) {
        Integer amount = (Integer)fluidStack.getFluidHolder().getData(CEIDataMaps.PRINTING_CUSTOM_NAME_INGREDIENT);
        return amount == null ? 0 : amount;
    }

    @Override
    public ItemStack getResult(Level level, ItemStack stack, FluidStack fluidStack) {
        ItemStack result = stack.copy();
        MutableComponent name = this.getCustomName(fluidStack);
        if (((Boolean)CEIConfig.fluids().printingCustomNameAsItemName.get()).booleanValue()) {
            result.set(DataComponents.ITEM_NAME, (Object)name);
        } else {
            result.set(DataComponents.CUSTOM_NAME, (Object)name);
        }
        return result;
    }

    @Override
    public void onFinished(Level level, BlockPos pos, PrinterBlockEntity printer) {
        level.levelEvent(1030, pos.below(), 0);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        FluidStack fluidStack = this.tank.getPrimaryHandler().getFluid();
        MutableComponent name = this.getCustomName(fluidStack);
        if (!((Boolean)CEIConfig.fluids().printingCustomNameAsItemName.get()).booleanValue()) {
            name.withStyle(ChatFormatting.ITALIC);
        }
        CEILang.translate("gui.goggles.printing.custom_name", new Object[0]).forGoggles(tooltip);
        CEILang.builder().add(name).forGoggles(tooltip, 1);
        Integer cost = (Integer)this.tank.getPrimaryHandler().getFluid().getFluidHolder().getData(CEIDataMaps.PRINTING_PATTERN_INGREDIENT);
        if (cost != null) {
            CEILang.translate("gui.goggles.printing.cost", CEILang.number(cost.intValue()).add(CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).style(cost <= (Integer)CEIConfig.fluids().printerFluidCapacity.get() ? ChatFormatting.GREEN : ChatFormatting.RED)).forGoggles(tooltip, 1);
        } else if (!this.tank.getPrimaryHandler().getFluid().isEmpty()) {
            CEILang.translate("gui.goggles.printing.incorrect_liquid", new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip);
        }
        return true;
    }

    private MutableComponent getCustomName(FluidStack fluidStack) {
        MutableComponent name = this.name.copy();
        Style style = (Style)fluidStack.getFluidHolder().getData(CEIDataMaps.PRINTING_CUSTOM_NAME_STYLE);
        if (style != null) {
            name.withStyle(style);
        }
        return name;
    }
}

