/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_extruder.components.extruder.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.oierbravo.create_mechanical_extruder.components.extruder.recipe.ExtrudingRecipe;
import com.oierbravo.create_mechanical_extruder.components.extruder.recipe.ExtrudingRecipeBuilder;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipe;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import java.util.List;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.data.Couple;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class ExtrudingRecipeSerializer
implements RecipeSerializer<ExtrudingRecipe> {
    public static final ExtrudingRecipeSerializer INSTANCE = new ExtrudingRecipeSerializer();
    public static final StreamCodec<RegistryFriendlyByteBuf, NonNullList<BlockPredicate>> STREAM_CODEC_BLOCK_PREDICATE_LIST = CatnipStreamCodecBuilders.nonNullList((StreamCodec)BlockPredicate.STREAM_CODEC, (int)2);
    public static final Codec<NonNullList<BlockPredicate>> CODEC_BLOCK_PREDICATE_LIST = NonNullList.codecOf((Codec)BlockPredicate.CODEC);
    public final StreamCodec<RegistryFriendlyByteBuf, ExtrudingRecipe> STREAM_CODEC = StreamCodec.of(this::toNetwork, this::fromNetwork);
    public static final MapCodec<ExtrudingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Couple.codec((Codec)BlockPredicate.CODEC).fieldOf("blockIngredients").forGetter(ExtrudingRecipe::getBlockPredicateIngredients), (App)ProcessingOutput.CODEC.fieldOf("result").forGetter(ExtrudingRecipe::getResult), (App)BlockPredicate.CODEC.optionalFieldOf("catalyst", (Object)BlockPredicate.Builder.block().build()).forGetter(ExtrudingRecipe::getCatalyst), (App)Codec.INT.optionalFieldOf("requiredBonks", (Object)1).forGetter(ExtrudingRecipe::getRequiredBonks), (App)Codec.BOOL.optionalFieldOf("advanced", (Object)false).forGetter(ExtrudingRecipe::isAdvanced), (App)Couple.codec((Codec)Codec.BOOL).optionalFieldOf("consumeBlocks", (Object)Couple.create((Object)false, (Object)false)).forGetter(ExtrudingRecipe::getConsumeBlocks), (App)IRecipeRequirement.LIST_CODEC.optionalFieldOf("requirements", List.of()).forGetter(ExtrudingRecipe::getRecipeRequirements), (App)ICondition.LIST_CODEC.optionalFieldOf("neoforge:conditions", List.of()).forGetter(AbstractMechanicalRecipe::getConditions)).apply((Applicative)instance, (blockIngredients, processingOutput, catalyst, requiredBonks, isAdvanced, consumeBlocks, requirements, iConditions) -> ((ExtrudingRecipeBuilder)new ExtrudingRecipeBuilder().withBlockIngredients((Couple<BlockPredicate>)blockIngredients).withSingleItemOutput((ProcessingOutput)processingOutput).withCatalyst((BlockPredicate)catalyst).requiredBonks((int)requiredBonks).isAdvanced((boolean)isAdvanced).consumeBlocks((Couple<Boolean>)consumeBlocks).withRequirements((List)requirements)).build()));

    private ExtrudingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        Couple blockPredicateList = (Couple)Couple.streamCodec((StreamCodec)BlockPredicate.STREAM_CODEC).decode((Object)buffer);
        ProcessingOutput result = (ProcessingOutput)ProcessingOutput.STREAM_CODEC.decode((Object)buffer);
        int requiredBonks = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
        boolean isAdvanced = (Boolean)ByteBufCodecs.BOOL.decode((Object)buffer);
        Couple consubleBlocks = (Couple)Couple.streamCodec((StreamCodec)ByteBufCodecs.BOOL).decode((Object)buffer);
        BlockPredicate catalystBlockPredicate = (BlockPredicate)BlockPredicate.STREAM_CODEC.decode((Object)buffer);
        List recipeRequirements = (List)IRecipeRequirement.LIST_STREAM_CODEC.decode((Object)buffer);
        return ((ExtrudingRecipeBuilder)new ExtrudingRecipeBuilder().withSingleItemOutput(result).withBlockIngredients((Couple<BlockPredicate>)blockPredicateList).requiredBonks(requiredBonks).isAdvanced(isAdvanced).consumeBlocks((Couple<Boolean>)consubleBlocks).withCatalyst(catalystBlockPredicate).withRequirements(recipeRequirements)).build();
    }

    private void toNetwork(RegistryFriendlyByteBuf buffer, ExtrudingRecipe extrudingRecipe) {
        Couple.streamCodec((StreamCodec)BlockPredicate.STREAM_CODEC).encode((Object)buffer, extrudingRecipe.getBlockPredicateIngredients());
        ProcessingOutput.STREAM_CODEC.encode((Object)buffer, (Object)extrudingRecipe.getResult());
        ByteBufCodecs.INT.encode((Object)buffer, (Object)extrudingRecipe.getRequiredBonks());
        ByteBufCodecs.BOOL.encode((Object)buffer, (Object)extrudingRecipe.isAdvanced());
        Couple.streamCodec((StreamCodec)ByteBufCodecs.BOOL).encode((Object)buffer, extrudingRecipe.getConsumeBlocks());
        BlockPredicate.STREAM_CODEC.encode((Object)buffer, (Object)extrudingRecipe.getCatalyst());
        IRecipeRequirement.LIST_STREAM_CODEC.encode((Object)buffer, extrudingRecipe.getRecipeRequirements());
    }

    @NotNull
    public MapCodec<ExtrudingRecipe> codec() {
        return CODEC;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, ExtrudingRecipe> streamCodec() {
        return this.STREAM_CODEC;
    }
}

