/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_extruder.components.extruder;

import com.mojang.math.Axis;
import com.oierbravo.create_mechanical_extruder.components.extruder.AbstractExtruderBlockEntity;
import com.oierbravo.mechanicals.MechanicalPartials;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class AbstractExtruderVisual<EX extends AbstractExtruderBlockEntity>
extends KineticBlockEntityVisual<EX>
implements SimpleDynamicVisual {
    private final OrientedInstance extruderPole;
    protected final RotatingInstance shaft;
    final Direction direction;
    private final Direction opposite;

    protected abstract PartialModel getPoleModel();

    public AbstractExtruderVisual(VisualizationContext context, EX blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        this.direction = (Direction)this.blockState.getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        this.opposite = this.direction.getOpposite();
        this.shaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)MechanicalPartials.SHAFT_QUARTER)).createInstance();
        this.shaft.setup(blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, this.opposite).setChanged();
        this.extruderPole = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)this.getPoleModel())).createInstance();
        Quaternionf q = Axis.YP.rotationDegrees(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.getValue(HorizontalKineticBlock.HORIZONTAL_FACING))));
        this.extruderPole.rotation((Quaternionfc)q);
        this.transformModels(partialTick);
    }

    private void transformModels(float pt) {
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        float renderedHeadOffset = this.getRenderedHeadOffset(pt);
        this.extruderPole.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
    }

    private float getRenderedHeadOffset(float pt) {
        return ((AbstractExtruderBlockEntity)this.blockEntity).getRenderedPoleOffset(pt) * ((AbstractExtruderBlockEntity)this.blockEntity).headOffset;
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.transformModels(ctx.partialTick());
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.extruderPole});
        this.relight(new FlatLit[]{this.shaft});
    }

    protected void _delete() {
        this.extruderPole.delete();
        this.shaft.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.extruderPole);
        consumer.accept((Instance)this.shaft);
    }
}

