/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd.compiler;

import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import io.wispforest.lavendermd.util.TextBuilder;
import io.wispforest.lavendermd.util.TextureSizeLookup;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.OptionalInt;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class OwoUICompiler
implements MarkdownCompiler<ParentComponent> {
    protected final Deque<FlowLayout> components = new ArrayDeque<FlowLayout>();
    protected final TextBuilder textBuilder = new TextBuilder();

    public OwoUICompiler() {
        this.components.push(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()));
    }

    public void visitText(String text) {
        this.textBuilder.append(class_2561.method_43470((String)text));
    }

    public void visitStyle(UnaryOperator<class_2583> style) {
        this.textBuilder.pushStyle(style);
    }

    public void visitStyleEnd() {
        this.textBuilder.popStyle();
    }

    public void visitBlockQuote() {
        this.textBuilder.pushStyle(style -> style.method_27706(class_124.field_1080));
        FlowLayout quotation = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        quotation.padding(Insets.of((int)5, (int)5, (int)7, (int)5)).surface((context, component) -> context.method_25294(component.x(), component.y() + 3, component.x() + 2, component.y() + component.height() - 3, -8947849));
        this.push(quotation);
    }

    public void visitBlockQuoteEnd() {
        this.textBuilder.popStyle();
        this.pop();
    }

    public void visitHorizontalRule() {
        this.append((Component)new BoxComponent(Sizing.fill((int)100), Sizing.fixed((int)2)).color(Color.ofRgb((int)0x777777)).fill(true));
    }

    public void visitImage(class_2960 image, String description, boolean fit) {
        if (fit) {
            this.append((Component)Containers.stack((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).child(Components.texture((class_2960)image, (int)0, (int)0, (int)256, (int)256, (int)256, (int)256).blend(true).tooltip((class_2561)class_2561.method_43470((String)description)).sizing(Sizing.fixed((int)100))).horizontalAlignment(HorizontalAlignment.CENTER));
        } else {
            TextureSizeLookup.Size textureSize = TextureSizeLookup.sizeOf(image);
            if (textureSize == null) {
                textureSize = new TextureSizeLookup.Size(64, 64);
            }
            this.append(Components.texture((class_2960)image, (int)0, (int)0, (int)textureSize.width(), (int)textureSize.height(), (int)textureSize.width(), (int)textureSize.height()).blend(true).tooltip((class_2561)class_2561.method_43470((String)description)));
        }
    }

    public void visitListItem(OptionalInt ordinal) {
        FlowLayout element = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        element.child((Component)this.makeLabel(class_2561.method_43470((String)(ordinal.isPresent() ? " " + ordinal.getAsInt() + ". " : " \u2022 ")).method_27692(class_124.field_1080)).margins(Insets.left((int)-11))).margins(Insets.vertical((int)1));
        element.padding(Insets.left((int)11)).allowOverflow(true);
        FlowLayout container = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        element.child((Component)container);
        this.push((Component)element, container);
    }

    public void visitListItemEnd() {
        this.pop();
    }

    public void visitComponent(Component component) {
        this.append(component);
    }

    protected void append(Component component) {
        this.flushText();
        this.components.peek().child(component);
    }

    protected void push(FlowLayout component) {
        this.push((Component)component, component);
    }

    protected void push(Component element, FlowLayout contentPanel) {
        this.append(element);
        this.components.push(contentPanel);
    }

    protected void pop() {
        this.flushText();
        this.components.pop();
    }

    protected LabelComponent makeLabel(class_5250 text) {
        return Components.label((class_2561)text);
    }

    protected void flushText() {
        if (this.textBuilder.empty()) {
            return;
        }
        this.components.peek().child(this.makeLabel(this.textBuilder.build()).horizontalSizing(Sizing.fill((int)100)));
    }

    public ParentComponent compile() {
        this.flushText();
        return (ParentComponent)this.components.getLast();
    }

    public String name() {
        return "lavender_builtin_owo_ui";
    }
}

