/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;

public class CreativeIngredientBlockTag
extends CreativeIngredient {
    public TagKey<Block> tag;

    public CreativeIngredientBlockTag(TagKey<Block> tag) {
        this.tag = tag;
    }

    public CreativeIngredientBlockTag() {
    }

    @Override
    protected void saveExtra(HolderLookup.Provider provider, CompoundTag nbt) {
        nbt.putString("tag", this.tag.location().toString());
    }

    @Override
    protected void loadExtra(HolderLookup.Provider provider, CompoundTag nbt) {
        this.tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("tag")));
    }

    @Override
    public boolean is(ItemStack stack) {
        Block block = Block.byItem((Item)stack.getItem());
        if (!(Block.byItem((Item)stack.getItem()) instanceof AirBlock)) {
            return block.builtInRegistryHolder().is(this.tag);
        }
        return false;
    }

    @Override
    public boolean is(CreativeIngredient info) {
        return info instanceof CreativeIngredientBlockTag && ((CreativeIngredientBlockTag)info).tag == this.tag;
    }

    @Override
    public ItemStack getExample() {
        Optional optional = BuiltInRegistries.BLOCK.getTag(this.tag);
        if (optional.isEmpty() || ((HolderSet.Named)optional.get()).size() == 0) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)((HolderSet.Named)optional.get()).get(0).value());
    }

    @Override
    public boolean equals(CreativeIngredient object) {
        return object instanceof CreativeIngredientBlockTag && ((CreativeIngredientBlockTag)object).tag == this.tag;
    }

    @Override
    public CreativeIngredient copy() {
        return new CreativeIngredientBlockTag(this.tag);
    }

    @Override
    public Component description() {
        return Component.literal((String)this.tag.location().toString());
    }

    @Override
    public Component descriptionDetail() {
        return Component.translatable((String)"minecraft.block_tag").append(": " + String.valueOf(ChatFormatting.YELLOW) + String.valueOf(this.tag.location()));
    }
}

