/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.commands.AccessoriesCommands;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.AccessoriesEventHandler;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.InstanceEndec;
import io.wispforest.accessories.menu.AccessoriesMenuTypes;
import io.wispforest.accessories.neoforge.AccessoriesInternalsImpl;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.utils.ManagedEndecDataLoader;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.owo.serialization.RegistriesAttribute;
import io.wispforest.owo.serialization.format.nbt.NbtDeserializer;
import io.wispforest.owo.serialization.format.nbt.NbtSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;

@Mod(value="accessories")
public class AccessoriesForge {
    public static final AttachmentType<AccessoriesHolderImpl> HOLDER_ATTACHMENT_TYPE = AttachmentType.builder(AccessoriesHolderImpl::of).serialize((IAttachmentSerializer)new IAttachmentSerializer<Tag, AccessoriesHolderImpl>(){
        private final Endec<AccessoriesHolderImpl> ENDEC = InstanceEndec.constructed(AccessoriesHolderImpl::new);

        public AccessoriesHolderImpl read(IAttachmentHolder holder, Tag tag, HolderLookup.Provider provider) {
            return (AccessoriesHolderImpl)this.ENDEC.decodeFully(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((RegistryAccess)((RegistryAccess)provider))}), NbtDeserializer::of, (Object)tag);
        }

        @Nullable
        public Tag write(AccessoriesHolderImpl object, HolderLookup.Provider provider) {
            return (Tag)this.ENDEC.encodeFully(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((RegistryAccess)((RegistryAccess)provider))}), NbtSerializer::of, (Object)object);
        }
    }).copyOnDeath().build();
    public static final EntityCapability<AccessoriesCapability, Void> CAPABILITY = EntityCapability.createVoid((ResourceLocation)Accessories.of("capability"), AccessoriesCapability.class);
    public static IEventBus BUS;

    public AccessoriesForge(IEventBus eventBus) {
        BUS = eventBus;
        Accessories.init();
        eventBus.addListener(this::registerStuff);
        eventBus.addListener(this::registerCapabilities);
        eventBus.addListener(this::commonInit);
        NeoForge.EVENT_BUS.addListener(this::attemptEquipFromUse);
        NeoForge.EVENT_BUS.addListener(this::attemptEquipOnEntity);
        NeoForge.EVENT_BUS.addListener(this::onEntityDeath);
        NeoForge.EVENT_BUS.addListener(this::onLivingEntityTick);
        NeoForge.EVENT_BUS.addListener(this::onDataSync);
        NeoForge.EVENT_BUS.addListener(this::onEntityLoad);
        NeoForge.EVENT_BUS.addListener(this::onStartTracking);
        NeoForge.EVENT_BUS.addListener(this::onWorldTick);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        NeoForge.EVENT_BUS.addListener(this::registerReloadListeners);
        NeoForge.EVENT_BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            AccessoriesEventHandler.onTracking((LivingEntity)serverPlayer, serverPlayer);
        });
        eventBus.addListener(event -> AccessoriesEventHandler.setupItems(new AccessoriesEventHandler.AddDataComponentCallback(){
            final /* synthetic */ ModifyDefaultComponentsEvent val$event;
            {
                this.val$event = modifyDefaultComponentsEvent;
            }

            @Override
            public <T> void addTo(Item item, DataComponentType<T> componentType, T component) {
                this.val$event.modify((ItemLike)item, builder -> builder.set(componentType, component));
            }
        }));
    }

    public void commonInit(FMLCommonSetupEvent event) {
        AccessoriesNetworking.init();
        ManagedEndecDataLoader.init(AccessoriesNetworking.CHANNEL, playerConsumer -> NeoForge.EVENT_BUS.addListener(syncEvent -> syncEvent.getRelevantPlayers().forEach(playerConsumer::accept)));
        Accessories.RULE_KEEP_ACCESSORY_INVENTORY = GameRules.register((String)"accessories.keepAccessoryInventory", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.create((boolean)false));
    }

    public void registerCommands(RegisterCommandsEvent event) {
        AccessoriesCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    public void registerStuff(RegisterEvent event) {
        event.register(Registries.MENU, helper -> AccessoriesMenuTypes.registerMenuType());
        event.register(Registries.TRIGGER_TYPE, helper -> Accessories.registerCriteria());
        event.register(Registries.DATA_COMPONENT_TYPE, helper -> AccessoriesDataComponents.init());
        event.register(Registries.COMMAND_ARGUMENT_TYPE, helper -> AccessoriesCommands.registerCommandArgTypes());
        event.register(NeoForgeRegistries.Keys.ATTACHMENT_TYPES, helper -> helper.register(Accessories.of("inventory_holder"), HOLDER_ATTACHMENT_TYPE));
    }

    public void registerReloadListeners(AddReloadListenerEvent event) {
        this.intermediateRegisterListeners(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
        AccessoriesInternalsImpl.setContext(event.getConditionContext());
        AccessoriesInternalsImpl.TO_BE_LOADED.forEach((managedEndecDataLoader, setupRegistryCallback) -> {
            setupRegistryCallback.accept(event.getRegistryAccess());
            event.addListener((PreparableReloadListener)managedEndecDataLoader);
        });
    }

    public void intermediateRegisterListeners(Consumer<PreparableReloadListener> registrationMethod) {
        registrationMethod.accept((PreparableReloadListener)SlotTypeLoader.INSTANCE);
        registrationMethod.accept((PreparableReloadListener)EntitySlotLoader.INSTANCE);
        registrationMethod.accept((PreparableReloadListener)SlotGroupLoader.INSTANCE);
        registrationMethod.accept((PreparableReloadListener)new SimplePreparableReloadListener<Void>(this){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                AccessoriesEventHandler.dataReloadOccurred = true;
                AccessoriesInternalsImpl.setContext(null);
            }
        });
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            if (event.isEntityRegistered(CAPABILITY, entityType)) continue;
            event.registerEntity(CAPABILITY, entityType, (entity, unused) -> {
                if (!(entity instanceof LivingEntity)) {
                    return null;
                }
                LivingEntity livingEntity = (LivingEntity)entity;
                Map<String, SlotType> slots = EntitySlotLoader.getEntitySlots(livingEntity);
                if (slots.isEmpty()) {
                    return null;
                }
                return new AccessoriesCapabilityImpl(livingEntity);
            });
        }
    }

    public void attemptEquipFromUse(PlayerInteractEvent.RightClickItem event) {
        InteractionResultHolder<ItemStack> resultHolder = AccessoriesEventHandler.attemptEquipFromUse(event.getEntity(), event.getHand());
        if (!resultHolder.getResult().consumesAction()) {
            return;
        }
        event.getEntity().setItemInHand(event.getHand(), (ItemStack)resultHolder.getObject());
        event.setCancellationResult(resultHolder.getResult());
    }

    public void attemptEquipOnEntity(PlayerInteractEvent.EntityInteract event) {
        AccessoriesEventHandler.attemptEquipOnEntity(event.getEntity(), event.getHand(), event.getTarget());
    }

    public void onEntityDeath(LivingDropsEvent event) {
        Collection<ItemStack> droppedStacks = AccessoriesEventHandler.onDeath(event.getEntity(), event.getSource());
        if (droppedStacks == null) {
            return;
        }
        event.getDrops().addAll(droppedStacks.stream().flatMap(stack -> AccessoriesForge.createDroppedEntity((Entity)event.getEntity(), stack)).toList());
    }

    private static Stream<ItemEntity> createDroppedEntity(Entity entity, ItemStack stack) {
        ArrayList<ItemEntity> itemEntities = new ArrayList<ItemEntity>();
        if (!stack.isEmpty()) {
            RandomSource random = entity.getRandom();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                double d = player.getEyeY() - (double)0.3f;
                ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), d, player.getZ(), stack);
                itemEntity.setPickUpDelay(40);
                float f = random.nextFloat() * 0.5f;
                float g = random.nextFloat() * ((float)Math.PI * 2);
                itemEntity.setDeltaMovement((double)(-Mth.sin((float)g) * f), (double)0.2f, (double)(Mth.cos((float)g) * f));
                itemEntities.add(itemEntity);
            } else {
                double itemWidth = EntityType.ITEM.getWidth();
                double e = 1.0 - itemWidth;
                double f = itemWidth / 2.0;
                double itemX = Math.floor(entity.getX()) + random.nextDouble() * e + f;
                double itemY = Math.floor(entity.getY()) + random.nextDouble() * e;
                double itemZ = Math.floor(entity.getZ()) + random.nextDouble() * e + f;
                while (!stack.isEmpty()) {
                    ItemEntity itemEntity = new ItemEntity(entity.level(), itemX, itemY, itemZ, stack.split(random.nextInt(21) + 10));
                    double max = 0.11485000171139836;
                    itemEntity.setDeltaMovement(random.triangle(0.0, max), random.triangle(0.2, max), random.triangle(0.0, max));
                    itemEntities.add(itemEntity);
                }
            }
        }
        return itemEntities.stream();
    }

    public void onLivingEntityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        AccessoriesEventHandler.onLivingEntityTick(livingEntity);
    }

    public void onDataSync(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        AccessoriesEventHandler.dataSync(player == null ? event.getPlayerList() : null, player);
    }

    public void onEntityLoad(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        AccessoriesEventHandler.entityLoad(livingEntity, event.getLevel());
    }

    public void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        AccessoriesEventHandler.onTracking(livingEntity, (ServerPlayer)event.getEntity());
    }

    public void onWorldTick(LevelTickEvent.Pre event) {
        AccessoriesEventHandler.onWorldTick(event.getLevel());
    }
}

