/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu.variants;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.menu.AccessoriesInternalSlot;
import io.wispforest.accessories.menu.AccessoriesMenuData;
import io.wispforest.accessories.menu.AccessoriesMenuTypes;
import io.wispforest.accessories.menu.ArmorSlotTypes;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import io.wispforest.accessories.mixin.SlotAccessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class AccessoriesMenu
extends AccessoriesMenuBase {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation BLOCK_ATLAS = ResourceLocation.withDefaultNamespace((String)"textures/atlas/blocks.png");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_SHIELD = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_shield");
    public int totalSlots = 0;
    public boolean overMaxVisibleSlots = false;
    public int scrolledIndex = 0;
    public float smoothScroll = 0.0f;
    private int maxScrollableIndex = 0;
    private int accessoriesSlotStartIndex = 0;
    private int cosmeticSlotStartIndex = 0;
    private final Set<SlotGroup> validGroups = new HashSet<SlotGroup>();
    private final Map<Integer, Boolean> slotToView = new HashMap<Integer, Boolean>();
    private Runnable onScrollToEvent = () -> {};
    @Nullable
    private Set<SlotType> usedSlots = null;
    private Map<AccessoriesInternalSlot, Integer> slotToPageIndex = new HashMap<AccessoriesInternalSlot, Integer>();

    public AccessoriesMenu(int containerId, Inventory inventory, @Nullable LivingEntity targetEntity) {
        super(AccessoriesMenuTypes.ORIGINAL_MENU, containerId, inventory, targetEntity);
        int i;
        LivingEntity accessoryTarget = targetEntity != null ? targetEntity : this.owner;
        AccessoriesCapability capability = AccessoriesCapability.get(accessoryTarget);
        if (capability == null) {
            return;
        }
        for (i = 0; i < 4; ++i) {
            EquipmentSlot equipmentSlot = ArmorSlotTypes.SLOT_IDS[i];
            ResourceLocation resourceLocation = ArmorSlotTypes.TEXTURE_EMPTY_SLOTS.get(equipmentSlot);
            this.addSlot((Slot)new ArmorSlot((Container)inventory, (LivingEntity)this.owner, equipmentSlot, 39 - i, 8, 8 + i * 18, resourceLocation));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + (i + 1) * 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
        this.addSlot(new Slot((Container)inventory, 40, 152, 62){

            public void setByPlayer(ItemStack newStack, ItemStack oldStack) {
                AccessoriesMenu.this.owner.onEquipItem(EquipmentSlot.OFFHAND, oldStack, newStack);
                super.setByPlayer(newStack, oldStack);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)BLOCK_ATLAS, (Object)EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        if (!this.areUnusedSlotsShown()) {
            this.usedSlots = ImmutableSet.copyOf(AccessoriesAPI.getUsedSlotsFor((LivingEntity)(targetEntity != null ? targetEntity : this.owner), (Container)this.owner.getInventory()));
        }
        int minX = -46;
        int maxX = 60;
        int minY = 8;
        int maxY = 152;
        int yIndex = 0;
        this.accessoriesSlotStartIndex = this.slots.size();
        HashMap<AccessoriesInternalSlot, Boolean> slotVisibility = new HashMap<AccessoriesInternalSlot, Boolean>();
        ArrayList<AccessoriesInternalSlot> accessoriesSlots = new ArrayList<AccessoriesInternalSlot>();
        ArrayList<AccessoriesInternalSlot> cosmeticSlots = new ArrayList<AccessoriesInternalSlot>();
        List<SlotGroup> groups = SlotGroupLoader.getGroups(inventory.player.level(), true);
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        List slotTypes = groups.stream().sorted(Comparator.comparingInt(SlotGroup::order).reversed()).flatMap(slotGroup -> {
            if (slotGroup.name().equals("accessories")) {
                return Stream.of(new SlotType[0]);
            }
            return slotGroup.slots().stream().map(s -> {
                SlotType slotType = SlotTypeLoader.getSlotType(this.owner.level(), s);
                if (this.usedSlots != null && !this.usedSlots.contains(slotType)) {
                    return null;
                }
                this.validGroups.add((SlotGroup)slotGroup);
                return slotType;
            }).filter(Objects::nonNull).sorted(Comparator.comparingInt(SlotType::order).reversed());
        }).toList();
        for (SlotType slot : slotTypes) {
            AccessoriesContainer accessoryContainer = containers.get(slot.name());
            if (accessoryContainer == null || accessoryContainer.slotType() == null) continue;
            int size = accessoryContainer.getSize();
            for (int i2 = 0; i2 < size; ++i2) {
                int currentY = yIndex * 18 + minY + 8;
                int currentX = minX;
                AccessoriesInternalSlot cosmeticSlot = new AccessoriesInternalSlot(accessoryContainer, true, i2, currentX, currentY).isActive(slot1 -> this.isCosmeticsOpen() && this.slotToView.getOrDefault(slot1.index, true) != false).isAccessible(slot1 -> slot1.isCosmetic && this.isCosmeticsOpen());
                this.slotToPageIndex.put(cosmeticSlot, yIndex);
                cosmeticSlots.add(cosmeticSlot);
                slotVisibility.put(cosmeticSlot, !this.overMaxVisibleSlots);
                AccessoriesInternalSlot baseSlot = new AccessoriesInternalSlot(accessoryContainer, false, i2, currentX += 20, currentY).isActive(slot1 -> this.slotToView.getOrDefault(slot1.index, true));
                this.slotToPageIndex.put(baseSlot, yIndex);
                accessoriesSlots.add(baseSlot);
                slotVisibility.put(baseSlot, !this.overMaxVisibleSlots);
                ++yIndex;
                if (this.overMaxVisibleSlots || currentY + 18 <= maxY) continue;
                this.overMaxVisibleSlots = true;
            }
        }
        for (AccessoriesInternalSlot accessoriesSlot : accessoriesSlots) {
            this.addSlot(accessoriesSlot);
            this.slotToView.put(accessoriesSlot.index, slotVisibility.getOrDefault(accessoriesSlot, false));
        }
        this.cosmeticSlotStartIndex = this.slots.size();
        for (AccessoriesInternalSlot cosmeticSlot : cosmeticSlots) {
            this.addSlot(cosmeticSlot);
            this.slotToView.put(cosmeticSlot.index, slotVisibility.getOrDefault(cosmeticSlot, false));
        }
        this.totalSlots = yIndex;
        this.maxScrollableIndex = this.totalSlots - 8;
    }

    public void setScrollEvent(Runnable event) {
        this.onScrollToEvent = event;
    }

    public boolean scrollTo(int i, boolean smooth) {
        int index = Math.min(Math.max(i, 0), this.maxScrollableIndex);
        if (index == this.scrolledIndex) {
            return false;
        }
        int diff = this.scrolledIndex - index;
        if (!smooth) {
            this.smoothScroll = Mth.clamp((float)((float)index / (float)this.maxScrollableIndex), (float)0.0f, (float)1.0f);
        }
        for (Slot slot : this.slots) {
            if (!(slot instanceof AccessoriesInternalSlot)) continue;
            AccessoriesInternalSlot accessoriesSlot = (AccessoriesInternalSlot)slot;
            ((SlotAccessor)((Object)accessoriesSlot)).accessories$setY(accessoriesSlot.y + diff * 18);
            Integer menuIndex = this.slotToPageIndex.get(accessoriesSlot);
            this.slotToView.put(accessoriesSlot.index, menuIndex >= index && menuIndex < index + 8);
        }
        this.scrolledIndex = index;
        this.onScrollToEvent.run();
        return true;
    }

    public int maxScrollableIndex() {
        return this.maxScrollableIndex;
    }

    public static AccessoriesMenu of(int containerId, Inventory inventory, AccessoriesMenuData data) {
        LivingEntity targetEntity = data.targetEntityId().map(i -> {
            Entity entity = inventory.player.level().getEntity(i.intValue());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                return livingEntity;
            }
            return null;
        }).orElse(null);
        return new AccessoriesMenu(containerId, inventory, targetEntity);
    }

    public boolean showingSlots() {
        return this.usedSlots == null || !this.usedSlots.isEmpty();
    }

    @Nullable
    public Set<SlotType> usedSlots() {
        return this.usedSlots;
    }

    public Set<SlotGroup> validGroups() {
        return this.validGroups;
    }

    public boolean isCosmeticsOpen() {
        return Optional.ofNullable(AccessoriesHolder.get((LivingEntity)this.owner)).map(AccessoriesHolder::cosmeticsShown).orElse(false);
    }

    public boolean areUnusedSlotsShown() {
        return Optional.ofNullable(AccessoriesHolder.get((LivingEntity)this.owner)).map(AccessoriesHolder::showUnusedSlots).orElse(false);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int clickedIndex) {
        int targetArmorSlotIndex;
        NonNullList slots = this.slots;
        Slot clickedSlot = (Slot)slots.get(clickedIndex);
        if (!clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack clickedStack = clickedSlot.getItem();
        ItemStack oldStack = clickedStack.copy();
        EquipmentSlot equipmentSlot = player.getEquipmentSlotForItem(oldStack);
        int armorSlots = 4;
        int hotbarSlots = 9;
        int invSlots = 27;
        int armorStart = 0;
        int armorEnd = armorStart - 1 + armorSlots;
        int invStart = armorEnd + 1;
        int invEnd = invStart - 1 + invSlots;
        int hotbarStart = invEnd + 1;
        int hotbarEnd = hotbarStart - 1 + hotbarSlots;
        int offhand = hotbarEnd + 1;
        if (clickedIndex < this.accessoriesSlotStartIndex ? !this.moveItemStackTo(clickedStack, this.accessoriesSlotStartIndex, this.slots.size(), false) && (clickedIndex >= armorStart && clickedIndex <= armorEnd ? !this.moveItemStackTo(clickedStack, invStart, hotbarEnd, false) : (equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR && !((Slot)this.slots.get(armorEnd - equipmentSlot.getIndex())).hasItem() ? !this.moveItemStackTo(clickedStack, targetArmorSlotIndex = armorEnd - equipmentSlot.getIndex(), targetArmorSlotIndex + 1, false) : (equipmentSlot == EquipmentSlot.OFFHAND && !((Slot)this.slots.get(offhand)).hasItem() ? !this.moveItemStackTo(clickedStack, offhand, offhand + 1, false) : (clickedIndex >= hotbarStart && clickedIndex <= hotbarEnd ? !this.moveItemStackTo(clickedStack, invStart, invEnd, false) : (clickedIndex >= invStart && clickedIndex <= invEnd ? !this.moveItemStackTo(clickedStack, hotbarStart, hotbarEnd, false) : !this.moveItemStackTo(clickedStack, invStart, hotbarEnd, false)))))) : !this.moveItemStackTo(clickedStack, invStart, hotbarEnd, false)) {
            return ItemStack.EMPTY;
        }
        if (clickedStack.isEmpty()) {
            clickedSlot.setByPlayer(ItemStack.EMPTY, oldStack);
        } else {
            clickedSlot.setChanged();
        }
        if (clickedStack.getCount() == oldStack.getCount()) {
            return ItemStack.EMPTY;
        }
        clickedSlot.onTake(player, clickedStack);
        return oldStack;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack itemStack;
        Slot slot;
        boolean bl = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                slot = (Slot)this.slots.get(i);
                if (slot.getMaxStackSize(itemStack = slot.getItem()) < itemStack.getCount() && !itemStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack)) {
                    int j = itemStack.getCount() + stack.getCount();
                    if (j <= stack.getMaxStackSize()) {
                        stack.setCount(0);
                        itemStack.setCount(j);
                        slot.setChanged();
                        bl = true;
                    } else if (itemStack.getCount() < stack.getMaxStackSize()) {
                        stack.shrink(stack.getMaxStackSize() - itemStack.getCount());
                        itemStack.setCount(stack.getMaxStackSize());
                        slot.setChanged();
                        bl = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                slot = (Slot)this.slots.get(i);
                itemStack = slot.getItem();
                if (itemStack.isEmpty() && slot.mayPlace(stack)) {
                    if (stack.getCount() > slot.getMaxStackSize(stack)) {
                        slot.setByPlayer(stack.split(slot.getMaxStackSize(stack)));
                    } else {
                        slot.setByPlayer(stack.split(stack.getCount()));
                    }
                    slot.setChanged();
                    bl = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return bl;
    }
}

