/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.mixin.client;

import com.corosus.watut.PlayerStatusManagerClient;
import com.corosus.watut.ShaderInstanceBlur;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererReloadShaders {
    @Shadow
    @Final
    private Map<String, ShaderInstance> shaders;

    @Inject(method={"reloadShaders"}, at={@At(value="RETURN")})
    private void onLoadShaders(ResourceProvider resourceProvider, CallbackInfo ci) {
        PlayerStatusManagerClient.particle = null;
        PlayerStatusManagerClient.positionTexBlur = null;
        PlayerStatusManagerClient.positionTexBlurHorizontal = null;
        PlayerStatusManagerClient.positionTexBlurVertical = null;
        try {
            PlayerStatusManagerClient.particle = new ShaderInstanceBlur(GameRendererReloadShaders.getResourceFactory(resourceProvider), "particle", DefaultVertexFormat.PARTICLE);
            PlayerStatusManagerClient.positionTexBlur = new ShaderInstanceBlur(GameRendererReloadShaders.getResourceFactory(resourceProvider), "position_tex_blur", DefaultVertexFormat.POSITION_TEX);
            PlayerStatusManagerClient.positionTexBlurHorizontal = new ShaderInstanceBlur(GameRendererReloadShaders.getResourceFactory(resourceProvider), "position_tex_blur_horizontal", DefaultVertexFormat.POSITION_TEX);
            PlayerStatusManagerClient.positionTexBlurVertical = new ShaderInstanceBlur(GameRendererReloadShaders.getResourceFactory(resourceProvider), "position_tex_blur_vertical", DefaultVertexFormat.POSITION_TEX);
            this.shaders.put(PlayerStatusManagerClient.particle.getName(), PlayerStatusManagerClient.particle);
            this.shaders.put(PlayerStatusManagerClient.positionTexBlur.getName(), PlayerStatusManagerClient.positionTexBlur);
            this.shaders.put(PlayerStatusManagerClient.positionTexBlurHorizontal.getName(), PlayerStatusManagerClient.positionTexBlurHorizontal);
            this.shaders.put(PlayerStatusManagerClient.positionTexBlurVertical.getName(), PlayerStatusManagerClient.positionTexBlurVertical);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ResourceProvider getResourceFactory(final ResourceProvider resourceManager) {
        ResourceProvider resourceFactory = new ResourceProvider(){

            public Optional<Resource> getResource(ResourceLocation resourceLocation) {
                ResourceLocation corrected = ResourceLocation.fromNamespaceAndPath((String)"watut", (String)resourceLocation.getPath());
                return resourceManager.getResource(corrected);
            }
        };
        return resourceFactory;
    }
}

