/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.world.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import net.lyof.phantasm.block.ModBlocks;
import net.lyof.phantasm.utils.BlockHelper;
import net.lyof.phantasm.world.feature.config.PurpurCabinFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class PurpurCabinFeature
extends Feature<PurpurCabinFeatureConfig> {
    public static final Feature<PurpurCabinFeatureConfig> INSTANCE = new PurpurCabinFeature(PurpurCabinFeatureConfig.CODEC);

    public PurpurCabinFeature(Codec<PurpurCabinFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<PurpurCabinFeatureConfig> context) {
        RandomSource random = context.random();
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        int width = ((PurpurCabinFeatureConfig)context.config()).width().sample(random) / 2;
        int length = ((PurpurCabinFeatureConfig)context.config()).length().sample(random) / 2;
        if (world.getBlockState(origin.atY(38)).is((Block)ModBlocks.RAW_PURPUR.get())) {
            origin = origin.atY(38);
        } else if (world.getBlockState(origin.atY(30)).is((Block)ModBlocks.RAW_PURPUR.get())) {
            origin = origin.atY(30);
        } else if (world.getBlockState(origin.atY(22)).is((Block)ModBlocks.RAW_PURPUR.get())) {
            origin = origin.atY(22);
        } else {
            return false;
        }
        origin.offset(-(origin.getX() % 16), 0, -(origin.getZ() % 16));
        for (int sx = -width; sx <= width; ++sx) {
            for (int sz = -length; sz <= length; ++sz) {
                BlockHelper.placeColumn((LevelAccessor)world, origin.east(sx).north(sz), 2, Blocks.AIR.defaultBlockState());
            }
        }
        PurpurCabinFeature.decorate(world, origin, width, length);
        return true;
    }

    static void decorate(WorldGenLevel level, BlockPos origin, int width, int length) {
        int i;
        BiPredicate<BlockGetter, BlockPos> condition = (a, b) -> a.getBlockState(b.below()).is((Block)ModBlocks.RAW_PURPUR.get()) || a.getBlockState(b.below(2)).is((Block)ModBlocks.RAW_PURPUR.get());
        BlockHelper.placeColumn((LevelAccessor)level, origin.east(-width).north(-length), 2, ((Block)ModBlocks.RAW_PURPUR_PILLAR.get()).defaultBlockState(), condition);
        BlockHelper.placeColumn((LevelAccessor)level, origin.east(width).north(-length), 2, ((Block)ModBlocks.RAW_PURPUR_PILLAR.get()).defaultBlockState(), condition);
        BlockHelper.placeColumn((LevelAccessor)level, origin.east(-width).north(length), 2, ((Block)ModBlocks.RAW_PURPUR_PILLAR.get()).defaultBlockState(), condition);
        BlockHelper.placeColumn((LevelAccessor)level, origin.east(width).north(length), 2, ((Block)ModBlocks.RAW_PURPUR_PILLAR.get()).defaultBlockState(), condition);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (i = 1 - width; i < width; ++i) {
            positions.add(origin.north(length).east(i));
            positions.add(origin.north(-length).east(i));
        }
        for (i = 1 - length; i < length; ++i) {
            positions.add(origin.east(width).north(i));
            positions.add(origin.east(-width).north(i));
        }
        ArrayList<BlockState> states = new ArrayList<BlockState>(List.of(Blocks.CRAFTING_TABLE.defaultBlockState(), Blocks.STONECUTTER.defaultBlockState(), Blocks.FURNACE.defaultBlockState(), Blocks.FURNACE.defaultBlockState().rotate(Rotation.CLOCKWISE_90), Blocks.FURNACE.defaultBlockState().rotate(Rotation.CLOCKWISE_180), Blocks.FURNACE.defaultBlockState().rotate(Rotation.COUNTERCLOCKWISE_90), (BlockState)Blocks.BARREL.defaultBlockState().setValue((Property)BarrelBlock.FACING, (Comparable)Direction.UP), (BlockState)Blocks.BARREL.defaultBlockState().setValue((Property)BarrelBlock.FACING, (Comparable)Direction.UP)));
        RandomSource rnd = RandomSource.create();
        for (int j = 0; j < rnd.nextIntBetweenInclusive(3, 6); ++j) {
            BlockPos pos = (BlockPos)positions.remove(rnd.nextIntBetweenInclusive(0, positions.size()));
            if (!level.getBlockState(pos.below()).is((Block)ModBlocks.RAW_PURPUR.get())) continue;
            level.setBlock(pos, (BlockState)states.remove(rnd.nextInt(0, states.size())), 3);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof BarrelBlockEntity)) continue;
            BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity;
            PurpurCabinFeature.setLootBarrel(barrel);
        }
        for (Direction direction : List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST)) {
            for (int i2 = 0; i2 < rnd.nextIntBetweenInclusive(12, 20); ++i2) {
                BlockHelper.placeColumn((LevelAccessor)level, BlockPos.of((long)BlockPos.offset((long)i2, (Direction)direction)), 2, Blocks.AIR.defaultBlockState(), (a, b) -> a.getBlockState(b).is((Block)ModBlocks.RAW_PURPUR.get()));
            }
        }
    }

    static int closestY(int base) {
        if (base >= 37) {
            return 38;
        }
        if (base >= 29) {
            return 30;
        }
        return 22;
    }

    static void setLootBarrel(BarrelBlockEntity barrel) {
        barrel.setLootTable(BuiltInLootTables.END_CITY_TREASURE, RandomSupport.generateUniqueSeed());
    }
}

