/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.world.feature;

import com.mojang.serialization.Codec;
import net.lyof.phantasm.setup.ModTags;
import net.lyof.phantasm.world.feature.config.DralgaeFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class DralgaeFeature
extends Feature<DralgaeFeatureConfig> {
    public static final Feature<DralgaeFeatureConfig> INSTANCE = new DralgaeFeature(DralgaeFeatureConfig.CODEC);

    public DralgaeFeature(Codec<DralgaeFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<DralgaeFeatureConfig> context) {
        FeaturePlaceContext contextnext;
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        int originy = origin.getY();
        RandomSource random = context.random();
        DralgaeFeatureConfig config = (DralgaeFeatureConfig)context.config();
        if (!world.getBlockState(origin.below()).is(ModTags.Blocks.DRALGAE_GROWABLE_ON)) {
            return false;
        }
        int size = config.size().sample(random);
        for (int i = 0; i < size; ++i) {
            if (originy + i > world.getHeight() || !world.getBlockState(origin.above(i)).isAir()) {
                return true;
            }
            this.setBlock((LevelWriter)world, origin.above(i), config.stem().getState(random, origin.above(i)));
        }
        if (random.nextInt(2) == 0) {
            this.setBlock((LevelWriter)world, origin.above(size), config.fruit().getState(random, origin.above(size)));
        }
        if (Math.random() < 0.7 && world.hasChunkAt((contextnext = new FeaturePlaceContext(context.topFeature(), context.level(), context.chunkGenerator(), context.random(), context.origin().east(random.nextIntBetweenInclusive(-5, 5)).north(random.nextIntBetweenInclusive(-5, 5)), (FeatureConfiguration)config)).origin())) {
            this.place((FeaturePlaceContext<DralgaeFeatureConfig>)contextnext);
        }
        return true;
    }
}

