/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.world.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import net.lyof.phantasm.setup.ModTags;
import net.lyof.phantasm.world.feature.config.BoulderFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class CeilingSpikeFeature
extends Feature<BoulderFeatureConfig> {
    public static final Feature<BoulderFeatureConfig> INSTANCE = new CeilingSpikeFeature(BoulderFeatureConfig.CODEC);

    public CeilingSpikeFeature(Codec<BoulderFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<BoulderFeatureConfig> context) {
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        BoulderFeatureConfig config = (BoulderFeatureConfig)context.config();
        int size = config.size().sample(random);
        ArrayList toPlace = new ArrayList();
        HashMap<Direction, Integer> sizes = new HashMap<Direction, Integer>();
        for (Direction dir : Direction.values()) {
            sizes.put(dir, size - random.nextIntBetweenInclusive(2, 4));
        }
        BlockPos pos = new BlockPos((Vec3i)origin).atY(0);
        while (!(pos.getY() >= world.getHeight() || world.getBlockState(pos.above()).is(ModTags.Blocks.END_PLANTS_GROWABLE_ON) && world.getBlockState(pos).is(Blocks.AIR))) {
            pos = pos.above();
        }
        if ((pos = pos.above()).getY() >= world.getHeight() - 2) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            BlockPos finalPos = pos;
            this.safeSetBlock(world, pos, config.block().getState(random, pos), block -> block.propagatesSkylightDown((BlockGetter)world, finalPos));
            for (int k = 0; k < 4; ++k) {
                if (i >= (Integer)sizes.get(Direction.from2DDataValue((int)k))) continue;
                this.safeSetBlock(world, pos.relative(Direction.from2DDataValue((int)k)), config.block().getState(random, pos), block -> block.propagatesSkylightDown((BlockGetter)world, finalPos));
            }
            pos = pos.below();
        }
        return true;
    }
}

