/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.mixin;

import javax.annotation.Nullable;
import net.lyof.phantasm.effect.ModEffects;
import net.lyof.phantasm.item.ModItems;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    public abstract boolean hasEffect(Holder<MobEffect> var1);

    @Shadow
    @Nullable
    public abstract MobEffectInstance getEffect(Holder<MobEffect> var1);

    public LivingEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Redirect(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;consume(ILnet/minecraft/world/entity/LivingEntity;)V"))
    public void keepOblifruit(ItemStack instance, int amount, LivingEntity entity) {
        if (instance.is((Item)ModItems.OBLIFRUIT.get()) && Math.random() < 0.05 && instance.getCount() < instance.getMaxStackSize()) {
            instance.grow(1);
            return;
        }
        if (instance.is((Item)ModItems.OBLIFRUIT.get()) && Math.random() < 0.4) {
            return;
        }
        instance.shrink(1);
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="RETURN")}, cancellable=true)
    public void applyVulnerability(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        if (!this.hasEffect((Holder<MobEffect>)ModEffects.CORROSION)) {
            return;
        }
        int i = this.getEffect((Holder<MobEffect>)ModEffects.CORROSION).getAmplifier() + 1;
        cir.setReturnValue((Object)Float.valueOf(amount * (1.0f + 0.2f * (float)i)));
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void cancelDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity attacker;
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity).hasEffect(ModEffects.CHARM)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getSpeed"}, at={@At(value="HEAD")}, cancellable=true)
    public void charmMovementSpeed(CallbackInfoReturnable<Float> cir) {
        if (this.hasEffect((Holder<MobEffect>)ModEffects.CHARM)) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="HEAD")}, cancellable=true)
    public void charmMovement(CallbackInfo ci) {
        if (this.hasEffect((Holder<MobEffect>)ModEffects.CHARM)) {
            ci.cancel();
        }
    }
}

