/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.entities.goals;

import java.util.EnumSet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;

public class FlyAroundGoal
extends Goal {
    public PathfinderMob self;

    public FlyAroundGoal(PathfinderMob entity) {
        this.self = entity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canContinueToUse() {
        return this.self.getNavigation().isInProgress();
    }

    public boolean canUse() {
        double d2;
        double d1;
        MoveControl movecontrol = this.self.getMoveControl();
        if (!movecontrol.hasWanted()) {
            return true;
        }
        double d0 = movecontrol.getWantedX() - this.self.getX();
        double d3 = d0 * d0 + (d1 = movecontrol.getWantedY() - this.self.getY()) * d1 + (d2 = movecontrol.getWantedZ() - this.self.getZ()) * d2;
        return d3 < 1.0 || d3 > 3600.0;
    }

    public void start() {
        RandomSource randomsource = this.self.getRandom();
        double d0 = this.self.getX() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 16.0f);
        double d1 = this.self.getY() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 16.0f);
        double d2 = this.self.getZ() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 16.0f);
        this.self.getMoveControl().setWantedPosition(d0, d1, d2, 1.0);
    }
}

