/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.entities.goals;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.lyof.phantasm.Phantasm;
import net.lyof.phantasm.entities.custom.CrystieEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DiveBombGoal
extends Goal {
    public CrystieEntity self;
    public int tick = 0;

    public DiveBombGoal(CrystieEntity entity) {
        this.self = entity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.self.isAngry && this.getNearestPlayer(32) != null;
    }

    public void start() {
        Player target = this.getNearestPlayer(32);
        if (target != null) {
            this.tick = 0;
            Phantasm.log("trying to attack " + String.valueOf(target));
            this.self.getNavigation().moveTo(this.self.getNavigation().createPath((Entity)target, 16), 1.0);
        } else {
            this.stop();
        }
    }

    public void stop() {
        this.self.getNavigation().stop();
        this.self.isAngry = false;
        this.tick = 0;
    }

    public void tick() {
        Player target;
        ++this.tick;
        if (this.tick > 100) {
            this.stop();
        }
        if ((target = this.getNearestPlayer(32)) == null) {
            this.stop();
            return;
        }
        this.self.getNavigation().moveTo(this.self.getNavigation().createPath((Entity)target, 16), 1.0);
        if (this.self.distanceTo((Entity)target) < 3.0f) {
            this.stop();
            this.self.explode();
        }
    }

    public Player getNearestPlayer(int radiusOfLooking) {
        Vec3 center = new Vec3(this.self.getX(), this.self.getY(), this.self.getZ());
        List<Entity> entityList = this.self.level().getEntitiesOfClass(Entity.class, new AABB(center, center).inflate((double)radiusOfLooking), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.distanceToSqr(center))).toList();
        for (Entity entityiterator : entityList) {
            if (!(entityiterator instanceof Player)) continue;
            Player player = (Player)entityiterator;
            return player;
        }
        return null;
    }
}

