/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.entities.custom;

import net.lyof.phantasm.client.particles.ModParticles;
import net.lyof.phantasm.config.ConfigEntries;
import net.lyof.phantasm.entities.ModEntities;
import net.lyof.phantasm.entities.animations.BehemothAnimation;
import net.lyof.phantasm.entities.goals.BehemothAttackGoal;
import net.lyof.phantasm.entities.goals.SleepGoal;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BehemothEntity
extends Monster
implements Enemy {
    public static final EntityDimensions SLEEPING_DIMENSIONS = EntityDimensions.fixed((float)2.0f, (float)1.0f);
    public static final EntityDimensions STANDARD_DIMENSIONS = EntityDimensions.fixed((float)0.95f, (float)1.95f);
    public int angryTicks = 0;
    public int animTicks = 0;
    public BehemothAnimation animation = BehemothAnimation.SLEEPING;
    public static int MAX_ANGRY_TICKS = 600;

    public BehemothEntity(EntityType<? extends BehemothEntity> type, Level level) {
        super((EntityType)ModEntities.BEHEMOTH.get(), level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SleepGoal(this));
        this.goalSelector.addGoal(1, (Goal)new BehemothAttackGoal(this, 1.0, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.ATTACK_DAMAGE, 15.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.KNOCKBACK_RESISTANCE, 10.0);
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return this.animation == BehemothAnimation.SLEEPING ? SLEEPING_DIMENSIONS : STANDARD_DIMENSIONS;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return super.getHurtSound(source);
    }

    protected SoundEvent getDeathSound() {
        return super.getDeathSound();
    }

    public boolean isAngry() {
        return this.getTarget() != null;
    }

    public boolean hurt(DamageSource source, float amount) {
        Player player;
        if (!source.isDirect()) {
            return false;
        }
        Entity entity = source.getEntity();
        if (entity instanceof Player && !(player = (Player)entity).isCreative() && !player.isSpectator()) {
            this.setTarget((LivingEntity)player);
            this.angryTicks = MAX_ANGRY_TICKS;
        }
        return super.hurt(source, amount);
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target == null && this.isAngry()) {
            this.setAnimation(BehemothAnimation.WAKING_DOWN);
        } else if (target != null && !this.isAngry()) {
            this.setAnimation(BehemothAnimation.WAKING_UP);
            this.playSound(SoundEvents.ENDER_DRAGON_GROWL, 1.0f, 1.0f);
        }
        super.setTarget(target);
        this.angryTicks = target == null ? 0 : MAX_ANGRY_TICKS;
    }

    public void setAnimation(BehemothAnimation anim) {
        if (anim != this.animation) {
            this.animTicks = 0;
        }
        this.animation = anim;
    }

    public void tick() {
        Player player;
        super.tick();
        if (this.tickCount % 20 == 0) {
            this.refreshDimensions();
        }
        ++this.animTicks;
        if (this.animation.maxTime > 0 && this.animTicks > this.animation.maxTime) {
            if (this.isAngry()) {
                this.setAnimation(BehemothAnimation.WALKING);
            } else {
                this.setAnimation(BehemothAnimation.SLEEPING);
            }
        }
        if (this.angryTicks > 0) {
            --this.angryTicks;
        } else if (this.isAngry()) {
            this.setTarget(null);
        } else if (!(this.tickCount % 20 != 0 || (player = this.level().getNearestPlayer((Entity)this, (double)ConfigEntries.behemothAggroRange)) == null || player.isCreative() || player.isSpectator() || player.isCrouching() && !(this.distanceTo((Entity)player) < (float)ConfigEntries.behemothAggroRangeSneaking))) {
            this.setTarget((LivingEntity)player);
        }
        if (this.getTarget() != null && (this.getTarget().distanceTo((Entity)this) > 16.0f || !this.getTarget().isAlive())) {
            this.setTarget(null);
        }
        if (!this.isAngry() && this.tickCount % 20 == 0) {
            this.playSound(SoundEvents.SNIFFER_SNIFFING, 2.0f, 1.0f);
            if (this.level().isClientSide() && this.getRandom().nextInt(2) == 0) {
                this.level().addParticle((ParticleOptions)ModParticles.ZZZ.get(), this.getX() - Math.sin((double)(-this.getYRot()) * Math.PI / 180.0), this.getY() + 0.3, this.getZ() - Math.cos((double)this.getYRot() * Math.PI / 180.0), 0.0, 0.05, 0.0);
            }
        }
    }
}

