/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.lyof.phantasm.entities.animations.BehemothAnimation;
import net.lyof.phantasm.entities.custom.BehemothEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BehemothModel<T extends BehemothEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"phantasm", (String)"behemoth_model"), "main");
    public static final float rad = (float)Math.PI / 180;
    private final ModelPart body;
    private final ModelPart left_horn;
    private final ModelPart right_horn;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart zzz;

    public BehemothModel(ModelPart root) {
        this.body = root.getChild("body");
        this.left_horn = this.body.getChild("left_horn");
        this.right_horn = this.body.getChild("right_horn");
        this.left_leg = this.body.getChild("left_leg");
        this.right_leg = this.body.getChild("right_leg");
        this.zzz = root.getChild("zzz");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition body = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -28.0f, -9.0f, 18.0f, 28.0f, 18.0f, new CubeDeformation(0.0f)).texOffs(0, 87).addBox(-8.0f, -27.0f, -7.0f, 16.0f, 27.0f, 14.0f, new CubeDeformation(0.0f)).texOffs(0, 47).addBox(-9.0f, 0.0f, -9.0f, 18.0f, 2.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.0f, (float)0.0f));
        PartDefinition left_horn = body.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(65, 39).addBox(0.0f, -6.0f, -9.0f, 6.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)9.0f, (float)-26.0f, (float)5.0f));
        PartDefinition right_horn = body.addOrReplaceChild("right_horn", CubeListBuilder.create().texOffs(65, 39).mirror().addBox(-6.0f, -6.0f, -9.0f, 6.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-9.0f, (float)-26.0f, (float)5.0f));
        PartDefinition left_leg = body.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(55, 0).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = body.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(55, 0).mirror().addBox(-3.0f, -2.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition zzz = modelPartData.addOrReplaceChild("zzz", CubeListBuilder.create().texOffs(60, 101).addBox(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)0.0f, (float)8.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        switch (((BehemothEntity)((Object)entity)).animation) {
            case WALKING: {
                this.body.xRot = Mth.sin((float)((float)(((BehemothEntity)((Object)entity)).animTicks * 3) * ((float)Math.PI / 180))) * 0.1f;
                this.left_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
                this.right_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
                break;
            }
            case SLEEPING: {
                this.body.xRot = -1.5707964f;
                this.body.zScale = (float)(1.0 + Math.sin((float)((BehemothEntity)((Object)entity)).animTicks * ((float)Math.PI / 180)) * 0.1);
                this.left_horn.zScale = 1.0f;
                this.right_horn.zScale = 1.0f;
                break;
            }
            case WAKING_UP: {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.body.xRot = Mth.cos((float)((float)Math.PI / 180 * (float)((BehemothEntity)((Object)entity)).animTicks * 90.0f / (float)BehemothAnimation.WAKING_UP.maxTime)) * ((float)Math.PI / 180) * -90.0f;
                break;
            }
            case WAKING_DOWN: {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.body.xRot = Mth.sin((float)((float)Math.PI / 180 * (float)((BehemothEntity)((Object)entity)).animTicks * 90.0f / (float)BehemothAnimation.WAKING_DOWN.maxTime)) * ((float)Math.PI / 180) * -90.0f;
            }
        }
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int light, int overlay, int color) {
        this.root().render(stack, consumer, light, overlay, color);
    }

    public ModelPart root() {
        return this.body;
    }
}

