/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.block.custom;

import net.lyof.phantasm.world.ModConfiguredFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;

public class NihiliumBlock
extends Block
implements BonemealableBlock {
    public NihiliumBlock(BlockBehaviour.Properties behaviour) {
        super(behaviour);
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        int i = reader.getMaxLightLevel();
        return i > 4 || reader.getBlockState(pos.below()).is(Blocks.END_STONE);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.setBlock(pos, Blocks.END_STONE.defaultBlockState(), 3);
        }
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return levelReader.getBlockState(blockPos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource source, BlockPos pos, BlockState state) {
        return false;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        for (int i = 0; i < 6; ++i) {
            BlockPos.MutableBlockPos target = pos.mutable().move(random.nextIntBetweenInclusive(-1, 1), random.nextIntBetweenInclusive(-1, 1), random.nextIntBetweenInclusive(-1, 1));
            if (!this.canSurvive(level.getBlockState((BlockPos)target), (LevelReader)level, (BlockPos)target) || level.getBlockState((BlockPos)target).getBlock() != Blocks.END_STONE) continue;
            level.setBlock((BlockPos)target, this.defaultBlockState(), 3);
            BlockState block = level.getBlockState((BlockPos)target);
            if (random.nextInt(3) != 0) continue;
            ((BonemealableBlock)block.getBlock()).performBonemeal(level, random, (BlockPos)target, block);
        }
        Holder holder = level.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getHolder(ModConfiguredFeatures.VIVID_NIHILIUM).orElse(null);
        BlockGrowFeatureEvent event = new BlockGrowFeatureEvent((LevelAccessor)level, random, pos, holder);
        if ((holder = event.getFeature()) != null) {
            ConfiguredFeature configuredfeature = (ConfiguredFeature)holder.value();
            BlockState blockstate = level.getFluidState(pos).createLegacyBlock();
            level.setBlock(pos, blockstate, 4);
            if (configuredfeature.place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, pos) && level.getBlockState(pos) == blockstate) {
                level.sendBlockUpdated(pos, state, blockstate, 2);
            }
        }
    }
}

