/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.block.custom;

import net.lyof.phantasm.block.ModBlocks;
import net.lyof.phantasm.block.custom.HangingPlantBlock;
import net.lyof.phantasm.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingFruitBlock
extends HangingPlantBlock
implements BonemealableBlock {
    public static final BooleanProperty HAS_FRUIT = BooleanProperty.create((String)"has_fruit");
    private final String getFruitID;

    public HangingFruitBlock(BlockBehaviour.Properties properties, TagKey<Block> growable_on, VoxelShape shape, String getFruitID) {
        super(properties.randomTicks(), growable_on, shape);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HAS_FRUIT, (Comparable)Boolean.valueOf(false)));
        this.growableOn = growable_on;
        this.getFruitID = getFruitID;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HAS_FRUIT});
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextDouble() < 0.05 && !((Boolean)state.getValue((Property)HAS_FRUIT)).booleanValue()) {
            this.performBonemeal(level, random, pos, state);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        if (level.getBlockState(pos.above()).isAir()) {
            level.removeBlock(pos, false);
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)HAS_FRUIT) == false;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)HAS_FRUIT)).booleanValue()) {
            player.swing(hand);
            ItemStack fruitStack = ItemStack.EMPTY;
            switch (this.getFruitID) {
                case "pream_berry": {
                    fruitStack = new ItemStack((ItemLike)ModItems.PREAM_BERRY.get());
                    break;
                }
                case "oblifruit": {
                    fruitStack = new ItemStack((ItemLike)ModItems.OBLIFRUIT.get());
                }
            }
            player.spawnAtLocation(fruitStack);
            level.setBlock(pos, (BlockState)state.setValue((Property)HAS_FRUIT, (Comparable)Boolean.valueOf(false)), 3);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return (Boolean)blockState.getValue((Property)HAS_FRUIT) == false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return this.canSurvive(state, (LevelReader)level, pos);
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)HAS_FRUIT, (Comparable)Boolean.valueOf(true)), 3);
        if (this.getFruitID.equals("oblifruit") && level.getBlockState(pos.below()).isAir() && (double)random.nextFloat() > 0.875) {
            level.setBlock(pos.below(), ((Block)ModBlocks.CRYSTALILY.get()).defaultBlockState(), 3);
        }
    }
}

