/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.block.custom;

import net.lyof.phantasm.block.custom.HangingFruitBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class DragonMintBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public DragonMintBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HangingFruitBlock.HAS_FRUIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HangingFruitBlock.HAS_FRUIT});
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)HangingFruitBlock.HAS_FRUIT)).booleanValue()) {
            return;
        }
        if (random.nextDouble() < 0.02 && this.isBonemealSuccess((Level)level, random, pos, state)) {
            this.performBonemeal(level, random, pos, state);
        }
    }

    public static BlockState getOtherHalf(LevelReader reader, BlockPos pos, BlockState state) {
        return state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.LOWER ? reader.getBlockState(pos.above()) : reader.getBlockState(pos.below());
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)HangingFruitBlock.HAS_FRUIT) == false && (Boolean)DragonMintBlock.getOtherHalf(level, pos, state).getValue((Property)HangingFruitBlock.HAS_FRUIT) == false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)HangingFruitBlock.HAS_FRUIT) == false && (Boolean)DragonMintBlock.getOtherHalf((LevelReader)level, pos, state).getValue((Property)HangingFruitBlock.HAS_FRUIT) == false;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (random.nextInt(3) == 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)HangingFruitBlock.HAS_FRUIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.is(Items.GLASS_BOTTLE) && ((Boolean)state.getValue((Property)HangingFruitBlock.HAS_FRUIT)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)HangingFruitBlock.HAS_FRUIT, (Comparable)Boolean.valueOf(false)), 3);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            player.getInventory().placeItemBackInInventory(Items.DRAGON_BREATH.getDefaultInstance());
            player.awardStat(Stats.ITEM_USED.get((Object)Items.GLASS_BOTTLE));
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }
}

