/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.block.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DirectionalBlock
extends Block {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing");
    public static final Map<Direction, VoxelShape> SHAPES = Map.of(Direction.DOWN, Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Direction.UP, Block.box((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Direction.NORTH, Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)10.0), Direction.SOUTH, Block.box((double)3.0, (double)3.0, (double)6.0, (double)13.0, (double)13.0, (double)16.0), Direction.EAST, Block.box((double)6.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), Direction.WEST, Block.box((double)0.0, (double)3.0, (double)3.0, (double)10.0, (double)13.0, (double)13.0));

    public DirectionalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.DOWN));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        BlockPos blockPos = pos.relative((Direction)state.getValue((Property)FACING));
        BlockState support = reader.getBlockState(blockPos);
        return support.isFaceSturdy((BlockGetter)reader, blockPos, (Direction)state.getValue((Property)FACING));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState other, LevelAccessor accessor, BlockPos pos, BlockPos otherPos) {
        BlockState result = super.updateShape(state, direction, other, accessor, pos, otherPos);
        if (!result.is((Block)this)) {
            return result;
        }
        return this.canSurvive(state, (LevelReader)accessor, pos) ? result : Blocks.AIR.defaultBlockState();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    public BlockState getPlacementState(LevelReader world, BlockPos pos) {
        ArrayList<Direction> possible = new ArrayList<Direction>();
        for (Direction dir : Direction.values()) {
            if (!this.canSurvive((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir), world, pos)) continue;
            possible.add(dir);
        }
        Collections.shuffle(possible);
        if (possible.isEmpty()) {
            return Blocks.AIR.defaultBlockState();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)possible.get(0)));
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.nextInt(20) == 0) {
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
        super.animateTick(state, world, pos, random);
    }
}

