/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrystalShardBlock
extends Block
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = CrystalShardBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final BooleanProperty IS_UP = BooleanProperty.create((String)"is_up");
    public static final BooleanProperty IS_TIP = BooleanProperty.create((String)"is_tip");
    public static final BooleanProperty WATERLOGGED = BooleanProperty.create((String)"waterlogged");

    public CrystalShardBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_TIP, (Comparable)Boolean.valueOf(true))).setValue((Property)IS_UP, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{IS_TIP}).add(new Property[]{IS_UP}).add(new Property[]{WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.getBlockState(pos.above()).isSolid() || reader.getBlockState(pos.above()).is(this.asBlock()) || reader.getBlockState(pos.below()).isSolid() || reader.getBlockState(pos.below()).is(this.asBlock());
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos1, boolean b) {
        super.neighborChanged(state, level, pos, block, pos1, b);
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean up;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).is((Fluid)Fluids.WATER)));
        boolean down = level.getBlockState(pos.above()).isFaceSturdy((BlockGetter)level, pos, Direction.DOWN) || level.getBlockState(pos.above()).getBlock() == this.asBlock();
        boolean bl = up = level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos, Direction.UP) || level.getBlockState(pos.below()).getBlock() == this.asBlock();
        if (down && up ? context.getNearestLookingVerticalDirection() == Direction.UP : down) {
            return (BlockState)state.setValue((Property)IS_UP, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        if (this.isValidPos(accessor, neighborPos, direction.getOpposite())) {
            if (direction == CrystalShardBlock.getDirection((Boolean)state.getValue((Property)IS_UP))) {
                return (BlockState)state.setValue((Property)IS_TIP, (Comparable)Boolean.valueOf(false));
            }
        } else if (direction == CrystalShardBlock.getDirection((Boolean)state.getValue((Property)IS_UP)).getOpposite()) {
            return Blocks.AIR.defaultBlockState();
        }
        if (direction == CrystalShardBlock.getDirection((Boolean)state.getValue((Property)IS_UP))) {
            return (BlockState)state.setValue((Property)IS_TIP, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public boolean isValidPos(LevelAccessor accessor, BlockPos pos, Direction direction) {
        BlockState state = accessor.getBlockState(pos);
        return state.isFaceSturdy((BlockGetter)accessor, pos, direction) || state.getBlock() == this.asBlock();
    }

    public static Direction getDirection(boolean up) {
        return up ? Direction.UP : Direction.DOWN;
    }
}

