/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.structure;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.structure.StructureTemplate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class LavenderStructures {
    private static final Map<ResourceLocation, JsonObject> PENDING_STRUCTURES = new HashMap<ResourceLocation, JsonObject>();
    private static final Map<ResourceLocation, StructureTemplate> LOADED_STRUCTURES = new HashMap<ResourceLocation, StructureTemplate>();
    private static boolean tagsAvailable = false;

    @ApiStatus.Internal
    public static void initialize() {
        ResourceManagerHelper.get((PackType)PackType.CLIENT_RESOURCES).registerReloadListener((IdentifiableResourceReloadListener)new ReloadListener());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            tagsAvailable = false;
        });
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            tagsAvailable = true;
            LavenderStructures.tryParseStructures();
        });
    }

    public static Set<ResourceLocation> loadedStructures() {
        return Collections.unmodifiableSet(LOADED_STRUCTURES.keySet());
    }

    @Nullable
    public static StructureTemplate get(ResourceLocation structureId) {
        return LOADED_STRUCTURES.get(structureId);
    }

    private static void tryParseStructures() {
        LOADED_STRUCTURES.clear();
        PENDING_STRUCTURES.forEach((identifier, pending) -> {
            try {
                LOADED_STRUCTURES.put((ResourceLocation)identifier, StructureTemplate.parse(identifier, pending));
            }
            catch (JsonParseException e) {
                Lavender.LOGGER.warn("Failed to load structure info {}", identifier, (Object)e);
            }
        });
    }

    private static class ReloadListener
    extends SimpleJsonResourceReloadListener
    implements IdentifiableResourceReloadListener {
        public ReloadListener() {
            super(new GsonBuilder().setLenient().disableHtmlEscaping().create(), "lavender/structures");
        }

        public ResourceLocation getFabricId() {
            return Lavender.id("structure_info_loader");
        }

        protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
            PENDING_STRUCTURES.clear();
            prepared.forEach((resourceId, jsonElement) -> {
                if (!jsonElement.isJsonObject()) {
                    return;
                }
                PENDING_STRUCTURES.put((ResourceLocation)resourceId, jsonElement.getAsJsonObject());
            });
            if (tagsAvailable) {
                LavenderStructures.tryParseStructures();
            }
        }
    }
}

