/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.structure;

import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public interface BlockStatePredicate {
    public static final BlockStatePredicate NULL_PREDICATE = new BlockStatePredicate(){

        @Override
        public BlockState preview() {
            return Blocks.AIR.defaultBlockState();
        }

        @Override
        public Result test(BlockState blockState) {
            return Result.STATE_MATCH;
        }

        @Override
        public boolean isOf(MatchCategory type) {
            return type == MatchCategory.ANY || type == MatchCategory.NULL;
        }
    };
    public static final BlockStatePredicate AIR_PREDICATE = new BlockStatePredicate(){

        @Override
        public BlockState preview() {
            return Blocks.AIR.defaultBlockState();
        }

        @Override
        public Result test(BlockState blockState) {
            return blockState.isAir() ? Result.STATE_MATCH : Result.NO_MATCH;
        }

        @Override
        public boolean isOf(MatchCategory type) {
            return type == MatchCategory.ANY || type == MatchCategory.NON_NULL || type == MatchCategory.AIR;
        }
    };

    public Result test(BlockState var1);

    default public boolean matches(BlockState state) {
        return this.test(state) == Result.STATE_MATCH;
    }

    public BlockState preview();

    default public boolean isOf(MatchCategory type) {
        return type != MatchCategory.AIR && type != MatchCategory.NULL;
    }

    public static enum Result {
        NO_MATCH,
        BLOCK_MATCH,
        STATE_MATCH;

    }

    public static enum MatchCategory {
        ANY,
        NON_NULL,
        NON_AIR,
        AIR,
        NULL;

    }
}

