/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.md.features;

import com.google.common.primitives.Ints;
import io.wispforest.lavender.book.StructureComponent;
import io.wispforest.lavender.client.StructureOverlayRenderer;
import io.wispforest.lavender.md.compiler.BookCompiler;
import io.wispforest.lavender.structure.LavenderStructures;
import io.wispforest.lavender.structure.StructureTemplate;
import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.owo.ui.component.SlimSliderComponent;
import io.wispforest.owo.ui.core.ParentComponent;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class StructureFeature
implements MarkdownFeature {
    private final BookCompiler.ComponentSource bookComponentSource;

    public StructureFeature(BookCompiler.ComponentSource bookComponentSource) {
        this.bookComponentSource = bookComponentSource;
    }

    public String name() {
        return "structures";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return compiler instanceof OwoUICompiler;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken(this.structureLexer("structure", true), '<');
        registrar.registerToken(this.structureLexer("structure-visualizer", false), '<');
    }

    private Lexer.LexFunction structureLexer(String token, boolean placeable) {
        String marker = "<" + token + ";";
        return (nibbler, tokens) -> {
            ResourceLocation structureId;
            if (!nibbler.tryConsume(marker)) {
                return false;
            }
            String structureIdString = nibbler.consumeUntil('>');
            if (structureIdString == null) {
                return false;
            }
            int angle = 35;
            if (structureIdString.matches("-?\\d+;.+")) {
                Integer parsedAngle = Ints.tryParse((String)structureIdString.substring(0, structureIdString.indexOf(59)));
                if (parsedAngle == null) {
                    return false;
                }
                angle = parsedAngle;
                structureIdString = structureIdString.substring(structureIdString.indexOf(59) + 1);
            }
            if ((structureId = ResourceLocation.tryParse((String)structureIdString)) == null) {
                return false;
            }
            StructureTemplate structure = LavenderStructures.get(structureId);
            if (structure == null) {
                return false;
            }
            tokens.add(new StructureToken(structureIdString, structure, angle, placeable));
            return true;
        };
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, structureToken, tokens) -> new StructureNode(structureToken.structure, structureToken.angle, structureToken.placeable), (token, tokens) -> {
            StructureToken structure;
            return token instanceof StructureToken ? (structure = (StructureToken)((Object)token)) : null;
        });
    }

    private static class StructureToken
    extends Lexer.Token {
        public final StructureTemplate structure;
        public final int angle;
        public final boolean placeable;

        public StructureToken(String content, StructureTemplate structure, int angle, boolean placeable) {
            super(content);
            this.structure = structure;
            this.angle = angle;
            this.placeable = placeable;
        }
    }

    private class StructureNode
    extends Parser.Node {
        private final StructureTemplate structure;
        private final int angle;
        private final boolean placeable;

        public StructureNode(StructureTemplate structure, int angle, boolean placeable) {
            this.structure = structure;
            this.angle = angle;
            this.placeable = placeable;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            ParentComponent structureComponent = StructureFeature.this.bookComponentSource.builtinTemplate(ParentComponent.class, this.structure.ySize > 1 ? "structure-preview-with-layers" : "structure-preview", Map.of("structure", this.structure.id.toString(), "angle", String.valueOf(this.angle)));
            StructureComponent structurePreview = ((StructureComponent)structureComponent.childById(StructureComponent.class, "structure")).placeable(this.placeable);
            SlimSliderComponent layerSlider = (SlimSliderComponent)structureComponent.childById(SlimSliderComponent.class, "layer-slider");
            if (layerSlider != null) {
                layerSlider.max(0.0).min((double)this.structure.ySize).tooltipSupplier(layer -> layer > 0.0 ? Component.translatable((String)"text.lavender.structure_component.layer_tooltip", (Object[])new Object[]{layer.intValue()}) : Component.translatable((String)"text.lavender.structure_component.all_layers_tooltip")).onChanged().subscribe(layer -> structurePreview.visibleLayer((int)layer - 1));
                layerSlider.value((double)(StructureOverlayRenderer.getLayerRestriction(this.structure.id) + 1));
            }
            ((OwoUICompiler)compiler).visitComponent((io.wispforest.owo.ui.core.Component)structureComponent);
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }
}

