/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.md.features;

import io.wispforest.lavender.md.ItemListComponent;
import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.owo.ui.core.Component;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class ItemTagFeature
implements MarkdownFeature {
    public String name() {
        return "item_tags";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return compiler instanceof OwoUICompiler;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.tryConsume("<item-tag;")) {
                return false;
            }
            String tagString = nibbler.consumeUntil('>');
            if (tagString == null) {
                return false;
            }
            ResourceLocation tagId = ResourceLocation.tryParse((String)tagString);
            if (tagId == null) {
                return false;
            }
            TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagId);
            if (BuiltInRegistries.ITEM.getTag(tagKey).isEmpty()) {
                return false;
            }
            tokens.add(new ItemTagToken(tagString, (TagKey<Item>)tagKey));
            return true;
        }, '<');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, tagToken, tokens) -> new ItemStackNode(tagToken.tag), (token, tokens) -> {
            ItemTagToken tag;
            return token instanceof ItemTagToken ? (tag = (ItemTagToken)((Object)token)) : null;
        });
    }

    private static class ItemTagToken
    extends Lexer.Token {
        public final TagKey<Item> tag;

        public ItemTagToken(String content, TagKey<Item> tag) {
            super(content);
            this.tag = tag;
        }
    }

    private static class ItemStackNode
    extends Parser.Node {
        private final TagKey<Item> tag;

        public ItemStackNode(TagKey<Item> tag) {
            this.tag = tag;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            ((OwoUICompiler)compiler).visitComponent((Component)new ItemListComponent().tag(this.tag));
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }
}

