/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.md.compiler;

import com.google.common.primitives.Ints;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.Category;
import io.wispforest.lavender.book.Entry;
import io.wispforest.lavender.client.LavenderBookScreen;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.lavendermd.feature.OwoUITemplateFeature;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BookCompiler
extends OwoUICompiler {
    private static final Style UNICODE_FONT_STYLE = Style.EMPTY.withFont(Minecraft.UNIFORM_FONT);
    private final FlowLayout resultContainer = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
    private final ComponentSource bookComponentSource;
    private boolean addImageBackground = false;

    public BookCompiler(ComponentSource bookComponentSource) {
        this.push(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()));
        this.bookComponentSource = bookComponentSource;
    }

    protected LabelComponent makeLabel(MutableComponent text) {
        return new BookLabelComponent((Component)text.withStyle(style -> style.applyTo(UNICODE_FONT_STYLE))).color(Color.BLACK).lineHeight(7);
    }

    public void visitImage(ResourceLocation image, String description, boolean fit) {
        this.addImageBackground = fit;
        super.visitImage(image, description, fit);
    }

    public void visitHorizontalRule() {
        this.append(this.bookComponentSource.builtinTemplate(io.wispforest.owo.ui.core.Component.class, "horizontal-rule"));
    }

    public void visitPageBreak() {
        this.resultContainer.child((io.wispforest.owo.ui.core.Component)this.components.peek());
        this.pop();
        this.push(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()));
    }

    protected void append(io.wispforest.owo.ui.core.Component component) {
        if (this.addImageBackground) {
            this.addImageBackground = false;
            if (component instanceof StackLayout) {
                StackLayout stack = (StackLayout)component;
                ((io.wispforest.owo.ui.core.Component)stack.children().get(0)).margins(Insets.of((int)3));
                stack.child(0, (io.wispforest.owo.ui.core.Component)this.bookComponentSource.builtinTemplate(TextureComponent.class, "fit-image-background"));
            }
        }
        super.append(component);
    }

    public ParentComponent compile() {
        this.pop();
        return super.compile();
    }

    public String name() {
        return "lavender_builtin_book";
    }

    @FunctionalInterface
    public static interface ComponentSource
    extends OwoUITemplateFeature.TemplateProvider {
        public <C extends io.wispforest.owo.ui.core.Component> C template(UIModel var1, Class<C> var2, String var3, Map<String, String> var4);

        default public <C extends io.wispforest.owo.ui.core.Component> C template(ResourceLocation model, Class<C> expectedClass, String templateName, Map<String, String> templateParams) {
            return this.template(UIModelLoader.get((ResourceLocation)model), expectedClass, templateName, templateParams);
        }

        default public <C extends io.wispforest.owo.ui.core.Component> C builtinTemplate(Class<C> expectedComponentClass, String name, Map<String, String> params) {
            return this.template(UIModelLoader.get((ResourceLocation)Lavender.id("book_components")), expectedComponentClass, name, params);
        }

        default public <C extends io.wispforest.owo.ui.core.Component> C builtinTemplate(Class<C> expectedComponentClass, String name) {
            return this.builtinTemplate(expectedComponentClass, name, Map.of());
        }

        default public <C extends io.wispforest.owo.ui.core.Component> C template(UIModel model, Class<C> expectedComponentClass, String name) {
            return this.template(model, expectedComponentClass, name, Map.of());
        }
    }

    public static class BookLabelComponent
    extends LabelComponent {
        @Nullable
        private LavenderBookScreen owner;

        protected BookLabelComponent(Component text) {
            super(text);
            this.margins(Insets.horizontal((int)1));
            this.textClickHandler(style -> {
                if (style == null || this.owner == null) {
                    return false;
                }
                ClickEvent clickEvent = style.getClickEvent();
                if (clickEvent != null && clickEvent.getAction() == ClickEvent.Action.OPEN_URL && clickEvent.getValue().startsWith("^")) {
                    LinkTarget linkTarget = this.resolveLinkTarget(clickEvent.getValue());
                    if (linkTarget != null && linkTarget.supplier != null) {
                        this.owner.navPush(linkTarget.supplier.get());
                        return true;
                    }
                    return false;
                }
                return this.owner.handleComponentClicked((Style)style);
            });
        }

        public void setOwner(@NotNull LavenderBookScreen screen) {
            this.owner = screen;
        }

        @Nullable
        protected LinkTarget resolveLinkTarget(String link) {
            int targetPage;
            if (this.owner == null) {
                return null;
            }
            String rawLinkText = link.substring(1);
            int pageSeparatorIndex = rawLinkText.indexOf(35);
            if (pageSeparatorIndex > 0) {
                Integer parsed = Ints.tryParse((String)rawLinkText.substring(pageSeparatorIndex + 1));
                if (parsed == null) {
                    return null;
                }
                targetPage = Math.max(0, (parsed - 1) / 2 * 2);
                rawLinkText = rawLinkText.substring(0, pageSeparatorIndex);
            } else {
                targetPage = 0;
            }
            ResourceLocation entryId = ResourceLocation.tryParse((String)rawLinkText);
            if (entryId == null) {
                return null;
            }
            Entry entry = this.owner.book.entryById(entryId);
            if (entry != null) {
                return new LinkTarget((Component)Component.literal((String)entry.title()), entry.canPlayerView(Minecraft.getInstance().player) ? () -> new LavenderBookScreen.NavFrame(new LavenderBookScreen.EntryPageSupplier(this.owner, entry), targetPage) : null);
            }
            Category category = this.owner.book.categoryById(entryId);
            if (category != null) {
                return new LinkTarget((Component)Component.literal((String)category.title()), this.owner.book.shouldDisplayCategory(category, Minecraft.getInstance().player) ? () -> new LavenderBookScreen.NavFrame(new LavenderBookScreen.CategoryPageSupplier(this.owner, category), targetPage) : null);
            }
            return null;
        }

        protected Style styleAt(int mouseX, int mouseY) {
            Style style = super.styleAt(mouseX, mouseY);
            if (style == null) {
                return null;
            }
            HoverEvent event = style.getHoverEvent();
            if (this.owner != null && event != null && event.getAction() == HoverEvent.Action.SHOW_TEXT && ((Component)event.getValue(HoverEvent.Action.SHOW_TEXT)).getString().startsWith("^")) {
                String rawLink = ((Component)event.getValue(HoverEvent.Action.SHOW_TEXT)).getString();
                LinkTarget linkTarget = this.resolveLinkTarget(rawLink);
                style = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, linkTarget != null ? (linkTarget.supplier != null ? linkTarget.title : Component.translatable((String)"text.lavender.locked_internal_link")) : Component.translatable((String)"text.lavender.invalid_internal_link", (Object[])new Object[]{rawLink})));
            }
            return style;
        }

        protected record LinkTarget(Component title, @Nullable Supplier<LavenderBookScreen.NavFrame> supplier) {
        }
    }
}

