/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.md;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ItemListComponent
extends ItemComponent {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    @Nullable
    private ImmutableList<ItemStack> items;
    private float time = 0.0f;
    private List<ClientTooltipComponent> extraTooltipSection = List.of();
    private int currentStackIndex;

    public ItemListComponent() {
        super(ItemStack.EMPTY);
        this.setTooltipFromStack(true);
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
        this.time += delta;
        if (this.time >= 20.0f) {
            this.time -= 20.0f;
            this.updateForItems();
        }
    }

    public Component tooltip(List<ClientTooltipComponent> tooltip) {
        if (tooltip == null) {
            return super.tooltip((List)null);
        }
        tooltip = new ArrayList<ClientTooltipComponent>(tooltip);
        tooltip.addAll(this.extraTooltipSection);
        this.tooltip = tooltip;
        return this;
    }

    private void updateForItems() {
        if (this.items != null && !this.items.isEmpty()) {
            this.currentStackIndex = (this.currentStackIndex + 1) % this.items.size();
            this.stack((ItemStack)this.items.get(this.currentStackIndex));
        } else {
            this.currentStackIndex = 0;
            this.stack(ItemStack.EMPTY);
        }
    }

    public ItemListComponent ingredient(Ingredient ingredient) {
        this.items = ImmutableList.copyOf((Object[])ingredient.getItems());
        this.updateForItems();
        return this;
    }

    public ItemListComponent tag(TagKey<Item> tag) {
        this.items = BuiltInRegistries.ITEM.getTag(tag).map(entries -> (ImmutableList)entries.stream().map(Holder::value).map(Item::getDefaultInstance).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
        this.updateForItems();
        return this;
    }

    public void extraTooltipSection(List<ClientTooltipComponent> section) {
        this.extraTooltipSection = section;
        this.updateTooltipForStack();
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, (String)"tag", tagElement -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)UIParsing.parseIdentifier((Node)tagElement)), this::tag);
        UIParsing.apply(children, (String)"ingredient", ingredientElement -> (Ingredient)Ingredient.CODEC_NONEMPTY.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson(ingredientElement.getTextContent().strip(), JsonElement.class))).getOrThrow(), this::ingredient);
    }
}

