/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.client;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.client.BasicVertexConsumerProvider;
import io.wispforest.lavender.client.LavenderClient;
import io.wispforest.lavender.pond.LavenderFramebufferExtension;
import io.wispforest.lavender.structure.BlockStatePredicate;
import io.wispforest.lavender.structure.LavenderStructures;
import io.wispforest.lavender.structure.StructureTemplate;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import io.wispforest.owo.ui.hud.Hud;
import io.wispforest.owo.ui.util.Delta;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL30C;

public class StructureOverlayRenderer {
    private static final Supplier<RenderTarget> FRAMEBUFFER = Suppliers.memoize(() -> {
        Window window = Minecraft.getInstance().getWindow();
        TextureTarget framebuffer = new TextureTarget(window.getWidth(), window.getHeight(), true, Minecraft.ON_OSX);
        ((LavenderFramebufferExtension)framebuffer).lavender$setBlitProgram(() -> {
            LavenderClient.BLIT_ALPHA_PROGRAM.setAlpha(0.5f);
            return LavenderClient.BLIT_ALPHA_PROGRAM.program();
        });
        framebuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        return framebuffer;
    });
    private static final Map<BlockPos, OverlayEntry> ACTIVE_OVERLAYS = new HashMap<BlockPos, OverlayEntry>();
    private static final BasicVertexConsumerProvider CONSUMERS = new BasicVertexConsumerProvider(4096);
    @Nullable
    private static OverlayEntry PENDING_OVERLAY = null;
    private static final ResourceLocation HUD_COMPONENT_ID = Lavender.id("structure_overlay");
    private static final ResourceLocation BARS_TEXTURE = Lavender.id("textures/gui/structure_overlay_bars.png");

    public static void addPendingOverlay(ResourceLocation structure) {
        PENDING_OVERLAY = new OverlayEntry(structure, Rotation.NONE);
    }

    public static void addOverlay(BlockPos anchorPoint, ResourceLocation structure, Rotation rotation) {
        ACTIVE_OVERLAYS.put(anchorPoint, new OverlayEntry(structure, rotation));
    }

    public static boolean isShowingOverlay(ResourceLocation structure) {
        if (PENDING_OVERLAY != null && structure.equals((Object)StructureOverlayRenderer.PENDING_OVERLAY.structureId)) {
            return true;
        }
        for (OverlayEntry entry : ACTIVE_OVERLAYS.values()) {
            if (!structure.equals((Object)entry.structureId)) continue;
            return true;
        }
        return false;
    }

    public static void removeAllOverlays(ResourceLocation structure) {
        if (PENDING_OVERLAY != null && structure.equals((Object)StructureOverlayRenderer.PENDING_OVERLAY.structureId)) {
            StructureOverlayRenderer.addPendingOverlay(null);
        }
        ACTIVE_OVERLAYS.values().removeIf(entry -> structure.equals((Object)entry.structureId));
    }

    public static int getLayerRestriction(ResourceLocation structure) {
        for (OverlayEntry entry : ACTIVE_OVERLAYS.values()) {
            if (entry.visibleLayer == -1) continue;
            return entry.visibleLayer;
        }
        return -1;
    }

    public static void restrictVisibleLayer(ResourceLocation structure, int visibleLayer) {
        if (PENDING_OVERLAY != null && structure.equals((Object)StructureOverlayRenderer.PENDING_OVERLAY.structureId)) {
            StructureOverlayRenderer.PENDING_OVERLAY.visibleLayer = visibleLayer;
        }
        for (OverlayEntry entry : ACTIVE_OVERLAYS.values()) {
            if (!structure.equals((Object)entry.structureId)) continue;
            entry.visibleLayer = visibleLayer;
        }
    }

    public static void clearOverlays() {
        ACTIVE_OVERLAYS.clear();
    }

    public static void rotatePending(boolean clockwise) {
        if (PENDING_OVERLAY == null) {
            return;
        }
        StructureOverlayRenderer.PENDING_OVERLAY.rotation = StructureOverlayRenderer.PENDING_OVERLAY.rotation.getRotated(clockwise ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
    }

    public static boolean hasPending() {
        return PENDING_OVERLAY != null;
    }

    public static void initialize() {
        Hud.add((ResourceLocation)HUD_COMPONENT_ID, () -> Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(15).positioning(Positioning.relative((int)5, (int)100)));
        WorldRenderEvents.LAST.register(context -> RenderSystem.runAsFancy(() -> {
            Component patt0$temp = Hud.getComponent((ResourceLocation)HUD_COMPONENT_ID);
            if (!(patt0$temp instanceof FlowLayout)) {
                return;
            }
            FlowLayout hudComponent = (FlowLayout)patt0$temp;
            PoseStack matrices = context.matrixStack();
            matrices.pushPose();
            matrices.translate(-context.camera().getPosition().x, -context.camera().getPosition().y, -context.camera().getPosition().z);
            Minecraft client = Minecraft.getInstance();
            MultiBufferSource.BufferSource effectConsumers = client.renderBuffers().crumblingBufferSource();
            BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos();
            RenderTarget framebuffer = FRAMEBUFFER.get();
            framebuffer.clear(Minecraft.ON_OSX);
            framebuffer.bindWrite(false);
            GL30C.glBindFramebuffer((int)36008, (int)client.getMainRenderTarget().frameBufferId);
            GL30C.glBlitFramebuffer((int)0, (int)0, (int)framebuffer.width, (int)framebuffer.height, (int)0, (int)0, (int)client.getMainRenderTarget().width, (int)client.getMainRenderTarget().height, (int)256, (int)9728);
            hudComponent.configure(layout -> {
                layout.clearChildren().padding(Insets.bottom((int)((client.getWindow().getGuiScaledWidth() - 182) / 2 < 200 ? 50 : 5)));
                ACTIVE_OVERLAYS.keySet().removeIf(anchor -> {
                    OverlayEntry entry = ACTIVE_OVERLAYS.get(anchor);
                    StructureTemplate structure = entry.fetchStructure();
                    if (structure == null) {
                        return true;
                    }
                    MutableBoolean hasInvalidBlock = new MutableBoolean();
                    if (entry.decayTime < 0.0f) {
                        SheetedDecalTextureGenerator overlayConsumer = new SheetedDecalTextureGenerator(effectConsumers.getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get(5 + (int)(Math.sin((double)System.currentTimeMillis() / 200.0) * 5.0))), matrices.last(), 1.0f);
                        matrices.pushPose();
                        matrices.translate((float)anchor.getX(), (float)anchor.getY(), (float)anchor.getZ());
                        structure.forEachPredicate((pos, predicate) -> {
                            BlockState state = context.world().getBlockState((BlockPos)testPos.set((Vec3i)anchor).move((Vec3i)pos)).rotate(StructureTemplate.inverse(entry.rotation));
                            BlockStatePredicate.Result result = predicate.test(state);
                            if (result == BlockStatePredicate.Result.STATE_MATCH) {
                                return;
                            }
                            if (!state.isAir() && result == BlockStatePredicate.Result.NO_MATCH) {
                                hasInvalidBlock.setTrue();
                                matrices.pushPose();
                                matrices.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                                client.getBlockRenderer().renderBreakingTexture(state, (BlockPos)testPos, (BlockAndTintGetter)context.world(), matrices, (VertexConsumer)overlayConsumer);
                                matrices.popPose();
                            }
                            if (entry.visibleLayer != -1 && pos.getY() != entry.visibleLayer) {
                                return;
                            }
                            StructureOverlayRenderer.renderOverlayBlock(matrices, (MultiBufferSource)CONSUMERS, pos, predicate, entry.rotation);
                        }, entry.rotation);
                        matrices.popPose();
                    }
                    int valid = structure.countValidStates((Level)client.level, (BlockPos)anchor, entry.rotation, BlockStatePredicate.MatchCategory.NON_AIR);
                    int total = structure.predicatesOfType(BlockStatePredicate.MatchCategory.NON_AIR);
                    boolean complete = structure.validate((Level)client.level, (BlockPos)anchor, entry.rotation);
                    if (entry.decayTime >= 0.0f) {
                        valid = total;
                    }
                    int barTextureOffset = 0;
                    if (hasInvalidBlock.booleanValue()) {
                        barTextureOffset = 20;
                    }
                    if (complete) {
                        barTextureOffset = 10;
                    }
                    DeltaTracker renderTickCounter = client.getTimer();
                    entry.visualCompleteness += Delta.compute((float)entry.visualCompleteness, (float)((float)valid / (float)total), (float)renderTickCounter.getGameTimeDeltaTicks());
                    layout.child(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.lavender.structure_hud.completion", (Object[])new Object[]{net.minecraft.network.chat.Component.translatable((String)Util.makeDescriptionId((String)"structure", (ResourceLocation)entry.structureId)), valid, total})).shadow(true)).child((Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)Components.texture((ResourceLocation)BARS_TEXTURE, (int)0, (int)barTextureOffset, (int)182, (int)5, (int)256, (int)48)).child((Component)Components.texture((ResourceLocation)BARS_TEXTURE, (int)0, (int)(barTextureOffset + 5), (int)Math.round(182.0f * entry.visualCompleteness), (int)5, (int)256, (int)48).positioning(Positioning.absolute((int)0, (int)0))).child((Component)Components.texture((ResourceLocation)BARS_TEXTURE, (int)0, (int)30, (int)182, (int)5, (int)256, (int)48).blend(true).positioning(Positioning.absolute((int)0, (int)0)))).gap(2).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.bottom((int)((int)(Easing.CUBIC.apply((Math.max(0.0f, entry.decayTime - 30.0f) + renderTickCounter.getGameTimeDeltaPartialTick(false)) / 20.0f) * -32.0f)))));
                    if (entry.decayTime < 0.0f && complete) {
                        entry.decayTime = 0.0f;
                        client.player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    } else if (entry.decayTime >= 0.0f) {
                        entry.decayTime += renderTickCounter.getGameTimeDeltaTicks();
                    }
                    return entry.decayTime >= 50.0f;
                });
            });
            if (PENDING_OVERLAY != null) {
                StructureTemplate structure = PENDING_OVERLAY.fetchStructure();
                if (structure != null) {
                    HitResult patt1$temp = client.player.pick(5.0, client.getTimer().getGameTimeDeltaPartialTick(false), false);
                    if (patt1$temp instanceof BlockHitResult) {
                        BlockHitResult target = (BlockHitResult)patt1$temp;
                        BlockPos targetPos = target.getBlockPos().offset(StructureOverlayRenderer.getPendingOffset(structure));
                        if (!client.player.isShiftKeyDown()) {
                            targetPos = targetPos.relative(target.getDirection());
                        }
                        matrices.translate((float)targetPos.getX(), (float)targetPos.getY(), (float)targetPos.getZ());
                        structure.forEachPredicate((pos, predicate) -> StructureOverlayRenderer.renderOverlayBlock(matrices, (MultiBufferSource)CONSUMERS, pos, predicate, StructureOverlayRenderer.PENDING_OVERLAY.rotation), StructureOverlayRenderer.PENDING_OVERLAY.rotation);
                    }
                } else {
                    PENDING_OVERLAY = null;
                }
            }
            matrices.popPose();
            GlStateManager._depthMask((boolean)true);
            CONSUMERS.endBatch();
            effectConsumers.endBatch();
            client.getMainRenderTarget().bindWrite(false);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.backupProjectionMatrix();
            framebuffer.blitToScreen(framebuffer.width, framebuffer.height, false);
            RenderSystem.restoreProjectionMatrix();
        }));
        WindowResizeCallback.EVENT.register((client, window) -> FRAMEBUFFER.get().resize(window.getWidth(), window.getHeight(), Minecraft.ON_OSX));
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (PENDING_OVERLAY == null) {
                return InteractionResult.PASS;
            }
            StructureTemplate structure = PENDING_OVERLAY.fetchStructure();
            BlockPos targetPos = hitResult.getBlockPos().offset(StructureOverlayRenderer.getPendingOffset(structure));
            if (!player.isShiftKeyDown()) {
                targetPos = targetPos.relative(hitResult.getDirection());
            }
            ACTIVE_OVERLAYS.put(targetPos, PENDING_OVERLAY);
            PENDING_OVERLAY = null;
            player.swing(hand);
            return InteractionResult.FAIL;
        });
    }

    private static Vec3i getPendingOffset(StructureTemplate structure) {
        if (PENDING_OVERLAY == null) {
            return Vec3i.ZERO;
        }
        return switch (StructureOverlayRenderer.PENDING_OVERLAY.rotation) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE -> new Vec3i(-structure.anchor().getX(), -structure.anchor().getY(), -structure.anchor().getZ());
            case Rotation.CLOCKWISE_90 -> new Vec3i(-structure.anchor().getZ(), -structure.anchor().getY(), -structure.anchor().getX());
            case Rotation.CLOCKWISE_180 -> new Vec3i(-structure.xSize + structure.anchor.getX() + 1, -structure.anchor().getY(), -structure.zSize + structure.anchor.getZ() + 1);
            case Rotation.COUNTERCLOCKWISE_90 -> new Vec3i(-structure.zSize + structure.anchor.getZ() + 1, -structure.anchor().getY(), -structure.xSize + structure.anchor.getX() + 1);
        };
    }

    private static void renderOverlayBlock(PoseStack matrices, MultiBufferSource consumers, BlockPos offsetInStructure, BlockStatePredicate block, Rotation rotation) {
        matrices.pushPose();
        matrices.translate((float)offsetInStructure.getX(), (float)offsetInStructure.getY(), (float)offsetInStructure.getZ());
        matrices.translate(0.5, 0.5, 0.5);
        matrices.scale(1.0001f, 1.0001f, 1.0001f);
        matrices.translate(-0.5, -0.5, -0.5);
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(block.preview().rotate(rotation), matrices, consumers, 240, OverlayTexture.NO_OVERLAY);
        matrices.popPose();
    }

    private static class OverlayEntry {
        public final ResourceLocation structureId;
        public Rotation rotation;
        public int visibleLayer = -1;
        public float decayTime = -1.0f;
        public float visualCompleteness = 0.0f;

        public OverlayEntry(ResourceLocation structureId, Rotation rotation) {
            this.structureId = structureId;
            this.rotation = rotation;
        }

        @Nullable
        public StructureTemplate fetchStructure() {
            return LavenderStructures.get(this.structureId);
        }
    }
}

