/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.client;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.client.LavenderBookScreen;
import io.wispforest.lavender.client.LavenderClient;
import io.wispforest.lavender.pond.LavenderFramebufferExtension;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class OffhandBookRenderer {
    public static boolean rendering = false;
    private static final Supplier<RenderTarget> BACK_BUFFER = Suppliers.memoize(() -> {
        Window window = Minecraft.getInstance().getWindow();
        TextureTarget framebuffer = new TextureTarget(window.getWidth(), window.getHeight(), true, Minecraft.ON_OSX);
        ((LavenderFramebufferExtension)framebuffer).lavender$setBlitProgram(() -> {
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            return LavenderClient.BLIT_CUTOUT_PROGRAM.program();
        });
        framebuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        return framebuffer;
    });
    private static final Supplier<RenderTarget> DISPLAY_BUFFER = Suppliers.memoize(() -> {
        Window window = Minecraft.getInstance().getWindow();
        TextureTarget framebuffer = new TextureTarget(window.getWidth(), window.getHeight(), true, Minecraft.ON_OSX);
        framebuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        return framebuffer;
    });
    private static LavenderBookScreen cachedScreen = null;
    private static boolean cacheExpired = true;

    public static void initialize() {
        WindowResizeCallback.EVENT.register((client, window) -> {
            DISPLAY_BUFFER.get().resize(window.getWidth(), window.getHeight(), Minecraft.ON_OSX);
            BACK_BUFFER.get().resize(window.getWidth(), window.getHeight(), Minecraft.ON_OSX);
            cachedScreen = null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginFrame(@Nullable Book book) {
        cacheExpired = true;
        if (book == null) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        rendering = true;
        RenderTarget backBuffer = BACK_BUFFER.get();
        try {
            LavenderBookScreen screen = cachedScreen;
            if (screen == null || screen.book != book) {
                cachedScreen = screen = new LavenderBookScreen(book, true);
                screen.init(client, client.getWindow().getGuiScaledWidth(), client.getWindow().getGuiScaledHeight());
                screen.adapter().dispose();
            }
            Matrix4fStack modelView = RenderSystem.getModelViewStack();
            modelView.pushMatrix();
            modelView.identity();
            modelView.translate(0.0f, 0.0f, -2000.0f);
            RenderSystem.applyModelViewMatrix();
            backBuffer.clear(Minecraft.ON_OSX);
            backBuffer.bindWrite(false);
            screen.render(new GuiGraphics(client, client.renderBuffers().bufferSource()), -69, -69, 0.0f);
            RenderSystem.disableDepthTest();
            modelView.popMatrix();
            RenderSystem.applyModelViewMatrix();
            RenderTarget displayBuffer = DISPLAY_BUFFER.get();
            displayBuffer.clear(Minecraft.ON_OSX);
            displayBuffer.bindWrite(false);
            backBuffer.blitToScreen(backBuffer.width, backBuffer.height, false);
            client.getMainRenderTarget().bindWrite(false);
        }
        finally {
            rendering = false;
        }
    }

    public static void render(PoseStack matrices, int light) {
        cacheExpired = false;
        Minecraft client = Minecraft.getInstance();
        RenderTarget framebuffer = DISPLAY_BUFFER.get();
        FramebufferTexture texture = new FramebufferTexture(framebuffer.getColorTextureId());
        client.getTextureManager().register(Lavender.id("offhand_book_framebuffer"), (AbstractTexture)texture);
        boolean rightHanded = client.player.getMainArm() == HumanoidArm.RIGHT;
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotationDegrees(rightHanded ? 15.0f : -15.0f));
        matrices.mulPose(Axis.XP.rotationDegrees(-10.0f));
        matrices.scale(1.0f * ((float)framebuffer.width / (float)framebuffer.height), 1.0f, 1.0f);
        matrices.translate(rightHanded ? -0.4f : -0.6f, -0.35f, -0.165f);
        VertexConsumer buffer = client.renderBuffers().bufferSource().getBuffer(RenderType.text((ResourceLocation)Lavender.id("offhand_book_framebuffer")));
        Matrix4f matrix = matrices.last().pose();
        buffer.addVertex(matrix, 0.0f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 1.0f).setLight(light);
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f).setLight(light);
        buffer.addVertex(matrix, 1.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f).setLight(light);
        buffer.addVertex(matrix, 1.0f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 1.0f).setLight(light);
        client.renderBuffers().bufferSource().endBatch();
        matrices.popPose();
    }

    public static void endFrame() {
        if (cacheExpired) {
            cachedScreen = null;
        }
    }

    private static class FramebufferTexture
    extends AbstractTexture {
        private FramebufferTexture(int textureId) {
            this.id = textureId;
        }

        public void load(ResourceManager manager) {
        }

        public void releaseId() {
        }
    }
}

