/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.client;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.book.BookContentLoader;
import io.wispforest.lavender.book.BookLoader;
import io.wispforest.lavender.book.Category;
import io.wispforest.lavender.book.Entry;
import io.wispforest.lavender.book.LavenderBookItem;
import io.wispforest.lavender.book.LavenderClientStorage;
import io.wispforest.lavender.book.StructureComponent;
import io.wispforest.lavender.client.AlphanumComparator;
import io.wispforest.lavender.client.UnreadNotificationComponent;
import io.wispforest.lavender.md.ItemListComponent;
import io.wispforest.lavender.md.compiler.BookCompiler;
import io.wispforest.lavender.md.features.ItemTagFeature;
import io.wispforest.lavender.md.features.OwoUIModelFeature;
import io.wispforest.lavender.md.features.PageBreakFeature;
import io.wispforest.lavender.md.features.RecipeFeature;
import io.wispforest.lavender.md.features.StructureFeature;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.MarkdownProcessor;
import io.wispforest.lavendermd.feature.BlockStateFeature;
import io.wispforest.lavendermd.feature.EntityFeature;
import io.wispforest.lavendermd.feature.ImageFeature;
import io.wispforest.lavendermd.feature.ItemStackFeature;
import io.wispforest.lavendermd.feature.KeybindFeature;
import io.wispforest.lavendermd.feature.OwoUITemplateFeature;
import io.wispforest.lavendermd.feature.TranslationsFeature;
import io.wispforest.owo.Owo;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextAreaComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.Animation;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.CommandOpenedScreen;
import io.wispforest.owo.ui.util.UISounds;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class LavenderBookScreen
extends BaseUIModelScreen<FlowLayout>
implements CommandOpenedScreen {
    private static final ResourceLocation DEFAULT_BOOK_TEXTURE = Lavender.id("textures/gui/brown_book.png");
    private static final Map<ResourceLocation, Map<RecipeType<?>, RecipeFeature.RecipePreviewBuilder<?>>> RECIPE_HANDLERS = new HashMap();
    private static final Map<ResourceLocation, FeatureProvider> FEATURE_PROVIDERS = new HashMap<ResourceLocation, FeatureProvider>();
    private static final Map<ResourceLocation, List<NavFrame.Replicator>> NAV_TRAILS = new HashMap<ResourceLocation, List<NavFrame.Replicator>>();
    private final BookCompiler.ComponentSource bookComponentSource = this::template;
    public final Book book;
    public final boolean isOverlay;
    private final MarkdownProcessor<ParentComponent> processor;
    private Window window;
    private int scaleFactor;
    private ButtonComponent previousButton;
    private ButtonComponent returnButton;
    private ButtonComponent nextButton;
    private TextBoxComponent searchBox;
    private FlowLayout leftPageAnchor;
    private FlowLayout rightPageAnchor;
    private FlowLayout bookmarkPanel;
    private final Deque<NavFrame> navStack = new ArrayDeque<NavFrame>();

    public LavenderBookScreen(Book book, boolean isOverlay) {
        super(FlowLayout.class, Lavender.id("book"));
        this.book = book;
        this.isOverlay = isOverlay;
        MarkdownProcessor processor = MarkdownProcessor.richText((int)0).copyWith(() -> new BookCompiler(this.bookComponentSource)).copyWith(new MarkdownFeature[]{new ImageFeature(), new BlockStateFeature(), new ItemStackFeature((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()), new EntityFeature(), new PageBreakFeature(), new OwoUITemplateFeature((OwoUITemplateFeature.TemplateProvider)this.bookComponentSource), new RecipeFeature(this.bookComponentSource, RECIPE_HANDLERS.get(this.book.id())), new StructureFeature(this.bookComponentSource), new KeybindFeature(), new ItemTagFeature(), new OwoUIModelFeature(), new TranslationsFeature()});
        if (FEATURE_PROVIDERS.get(book.id()) != null) {
            processor = processor.copyWith((MarkdownFeature[])FEATURE_PROVIDERS.get(book.id()).createFeatures(this.bookComponentSource).toArray(MarkdownFeature[]::new));
        }
        this.processor = processor;
    }

    public LavenderBookScreen(Book book) {
        this(book, false);
    }

    protected void init() {
        this.window = this.minecraft.getWindow();
        double gameScale = this.window.getGuiScale();
        this.scaleFactor = this.window.calculateScale(!this.isOverlay ? (Integer)this.minecraft.options.guiScale().get() : 0, true);
        this.window.setGuiScale((double)this.scaleFactor);
        this.width = this.window.getGuiScaledWidth();
        this.height = this.window.getGuiScaledHeight();
        super.init();
        this.window.setGuiScale(gameScale);
    }

    protected <C extends io.wispforest.owo.ui.core.Component> C template(Class<C> expectedComponentClass, String name) {
        return this.template(expectedComponentClass, name, Map.of());
    }

    protected <C extends io.wispforest.owo.ui.core.Component> C template(Class<C> expectedComponentClass, String name, Map<String, String> parameters) {
        return this.template(this.model, expectedComponentClass, name, parameters);
    }

    protected <C extends io.wispforest.owo.ui.core.Component> C template(UIModel model, Class<C> expectedComponentClass, String name, Map<String, String> parameters) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("book-texture", this.bookTexture().toString());
        params.putAll(parameters);
        return (C)model.expandTemplate(expectedComponentClass, name, params);
    }

    protected ResourceLocation bookTexture() {
        return this.book.texture() != null ? this.book.texture() : DEFAULT_BOOK_TEXTURE;
    }

    @NotNull
    protected <C extends io.wispforest.owo.ui.core.Component> C component(Class<C> expectedClass, String id) {
        return (C)super.component(expectedClass, id);
    }

    protected void build(FlowLayout rootComponent) {
        if (this.isOverlay) {
            rootComponent.surface(Surface.BLANK);
        }
        rootComponent.child(this.template(io.wispforest.owo.ui.core.Component.class, "primary-panel"));
        this.leftPageAnchor = this.component(FlowLayout.class, "left-page-anchor");
        this.rightPageAnchor = this.component(FlowLayout.class, "right-page-anchor");
        this.bookmarkPanel = this.component(FlowLayout.class, "bookmark-panel");
        this.previousButton = this.component(ButtonComponent.class, "previous-button");
        this.previousButton.onPress(button -> this.turnPage(true));
        this.nextButton = this.component(ButtonComponent.class, "next-button");
        this.nextButton.onPress(button -> this.turnPage(false));
        this.returnButton = this.component(ButtonComponent.class, "back-button");
        this.returnButton.onPress(button -> {
            if (Screen.hasShiftDown()) {
                while (this.navStack.size() > 1) {
                    this.navStack.pop();
                }
                this.rebuildContent(this.book.flippingSound());
            } else {
                this.navPop();
            }
        });
        if (Owo.DEBUG && !this.isOverlay) {
            this.component(FlowLayout.class, "primary-panel").child((io.wispforest.owo.ui.core.Component)this.template(ButtonComponent.class, "reload-button").onPress(buttonComponent -> {
                BookLoader.reload(this.minecraft.getResourceManager());
                BookContentLoader.reloadContents(this.minecraft.getResourceManager());
                Book newBook = BookLoader.get(this.book.id());
                if (newBook != null) {
                    this.minecraft.setScreen((Screen)new LavenderBookScreen(newBook));
                } else {
                    this.minecraft.setScreen(null);
                }
            }));
        }
        this.searchBox = this.component(TextBoxComponent.class, "search-box");
        this.searchBox.active = false;
        this.searchBox.visible = false;
        this.searchBox.onChanged().subscribe(value -> {
            NavFrame frame = this.currentNavFrame();
            this.navStack.pop();
            this.navPush(new NavFrame(frame.pageSupplier.replicator().apply(this), frame.selectedPage), true);
            this.rebuildContent(null);
        });
        List<NavFrame.Replicator> navTrail = LavenderBookScreen.getNavTrail(this.book);
        for (int i = navTrail.size() - 1; i >= 0; --i) {
            NavFrame frame = navTrail.get(i).createFrame(this);
            if (frame == null) continue;
            this.navPush(frame, true);
        }
        if (this.book.introEntry() != null && !LavenderClientStorage.wasBookOpened(this.book.id())) {
            this.navPush(new NavFrame(new EntryPageSupplier(this, this.book.introEntry()), 0), true);
        }
        LavenderClientStorage.markBookOpened(this.book.id());
        this.rebuildContent(!this.isOverlay ? this.book.openSound() : null);
    }

    private void rebuildContent(@Nullable SoundEvent sound) {
        PageSupplier pageSupplier = this.currentNavFrame().replicator().pageSupplier.apply(this);
        int selectedPage = this.currentNavFrame().selectedPage;
        if (pageSupplier == null) {
            this.navPop();
            return;
        }
        if (sound != null) {
            this.minecraft.player.playSound(sound, 1.0f, 1.0f);
        }
        if (selectedPage >= pageSupplier.pageCount()) {
            selectedPage = this.currentNavFrame().selectedPage = (pageSupplier.pageCount() - 1) / 2 * 2;
        }
        if (!this.isOverlay) {
            this.returnButton.active(this.navStack.size() > 1);
            this.previousButton.active(selectedPage > 0);
            this.nextButton.active(selectedPage + 2 < pageSupplier.pageCount());
        }
        this.searchBox.visible = this.searchBox.active = pageSupplier.searchable();
        for (int index = 0; index < 2; ++index) {
            FlowLayout anchor = index == 0 ? this.leftPageAnchor : this.rightPageAnchor;
            anchor.clearChildren();
            if (selectedPage + index < pageSupplier.pageCount()) {
                anchor.child(pageSupplier.getPageContent(selectedPage + index));
                continue;
            }
            anchor.child(this.template(io.wispforest.owo.ui.core.Component.class, "empty-page-content"));
        }
        this.bookmarkPanel.configure(bookmarkContainer -> {
            bookmarkContainer.clearChildren();
            List<LavenderClientStorage.Bookmark> bookmarks = LavenderClientStorage.getBookmarks(this.book);
            for (LavenderClientStorage.Bookmark bookmark : bookmarks) {
                Book.BookmarkableElement element = bookmark.tryResolve(this.book);
                if (element == null) continue;
                ParentComponent bookmarkComponent = this.createBookmarkButton("bookmark");
                bookmarkComponent.tooltip(List.of(Component.literal((String)element.title()), Component.translatable((String)"text.lavender.book.bookmark.remove_hint")));
                ((StackLayout)bookmarkComponent.childById(StackLayout.class, "bookmark-preview")).child(element.iconFactory().apply(Sizing.fill()).cursorStyle(CursorStyle.HAND));
                ((ButtonComponent)bookmarkComponent.childById(ButtonComponent.class, "bookmark-button")).configure(bookmarkButton -> bookmarkButton.onPress($ -> {
                    if (Screen.hasShiftDown()) {
                        LavenderClientStorage.removeBookmark(this.book, bookmark);
                        this.rebuildContent(null);
                    } else if (element instanceof Entry) {
                        Entry entry = (Entry)element;
                        this.navPush(new EntryPageSupplier(this, entry));
                    } else if (element instanceof Category) {
                        Category category = (Category)element;
                        this.navPush(new CategoryPageSupplier(this, category));
                    }
                }));
                bookmarkContainer.child((io.wispforest.owo.ui.core.Component)bookmarkComponent);
            }
            PageSupplier patt0$temp = this.currentNavFrame().pageSupplier;
            if (patt0$temp instanceof PageSupplier.Bookmarkable) {
                PageSupplier.Bookmarkable bookmarkable = (PageSupplier.Bookmarkable)((Object)patt0$temp);
                ParentComponent addBookmarkButton = this.createBookmarkButton("add-bookmark");
                ((ButtonComponent)addBookmarkButton.childById(ButtonComponent.class, "bookmark-button")).configure(bookmarkButton -> {
                    bookmarkButton.tooltip((Component)Component.translatable((String)"text.lavender.book.bookmark.add"));
                    bookmarkButton.onPress($ -> {
                        bookmarkable.addBookmark();
                        this.rebuildContent(null);
                        this.component(ScrollContainer.class, "bookmark-scroll").scrollTo(1.0);
                    });
                });
                bookmarkContainer.child((io.wispforest.owo.ui.core.Component)addBookmarkButton);
            }
        });
    }

    protected ParentComponent createBookmarkButton(String templateName) {
        ParentComponent bookmark = this.template(ParentComponent.class, templateName);
        bookmark.mouseEnter().subscribe(() -> bookmark.margins(Insets.none()));
        bookmark.mouseLeave().subscribe(() -> bookmark.margins(Insets.top((int)1)));
        return bookmark;
    }

    protected NavFrame currentNavFrame() {
        return this.navStack.peek();
    }

    private void turnPage(boolean left) {
        NavFrame frame = this.currentNavFrame();
        int previousPage = frame.selectedPage;
        frame.selectedPage = Math.max(0, Math.min(frame.selectedPage + (left ? -2 : 2), frame.pageSupplier.pageCount() - 1)) / 2 * 2;
        if (frame.selectedPage != previousPage) {
            this.rebuildContent(this.book.flippingSound());
        }
    }

    public void navPush(PageSupplier supplier) {
        this.navPush(new NavFrame(supplier, 0));
    }

    public void navPush(NavFrame frame) {
        this.navPush(frame, false);
    }

    public void navPush(NavFrame frame, boolean suppressUpdate) {
        NavFrame topFrame = this.navStack.peek();
        if (topFrame != null && frame.pageSupplier.canMerge(topFrame.pageSupplier)) {
            topFrame.selectedPage = frame.selectedPage;
        } else {
            if (frame.selectedPage >= frame.pageSupplier.pageCount() - 1) {
                frame.selectedPage = frame.pageSupplier.pageCount() / 2 * 2;
            }
            this.navStack.push(frame);
        }
        if (!suppressUpdate) {
            this.rebuildContent(this.book.flippingSound());
        }
    }

    public void navPop() {
        if (this.navStack.size() <= 1) {
            return;
        }
        this.navStack.pop();
        this.rebuildContent(this.book.flippingSound());
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        mouseX = (int)((double)mouseX * this.window.getGuiScale() / (double)this.scaleFactor);
        mouseY = (int)((double)mouseY * this.window.getGuiScale() / (double)this.scaleFactor);
        double gameScale = this.window.getGuiScale();
        this.window.setGuiScale((double)this.scaleFactor);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)this.window.getWidth() / (float)this.scaleFactor, (float)this.window.getHeight() / (float)this.scaleFactor, 0.0f, 1000.0f, 21000.0f), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        super.render(context, mouseX, mouseY, delta);
        context.flush();
        RenderSystem.restoreProjectionMatrix();
        this.window.setGuiScale(gameScale);
    }

    public boolean charTyped(char chr, int modifiers) {
        if (super.charTyped(chr, modifiers)) {
            return true;
        }
        if (chr == 'e' && (modifiers & 4) != 0) {
            this.navPush(new EditorPageSupplier(this));
            return true;
        }
        this.searchBox.focusHandler().focus((io.wispforest.owo.ui.core.Component)this.searchBox, Component.FocusSource.MOUSE_CLICK);
        this.searchBox.charTyped(chr, modifiers);
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 259) {
            this.navPop();
        } else if (keyCode == 263 || keyCode == 267) {
            this.turnPage(true);
        } else if (keyCode == 262 || keyCode == 266) {
            this.turnPage(false);
        } else {
            return false;
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX = mouseX * this.window.getGuiScale() / (double)this.scaleFactor, mouseY = mouseY * this.window.getGuiScale() / (double)this.scaleFactor, button)) {
            return true;
        }
        if (button == 1) {
            this.navPop();
        } else if (button == 3) {
            this.turnPage(true);
        } else if (button == 4) {
            this.turnPage(false);
        } else {
            return false;
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        mouseX = mouseX * this.window.getGuiScale() / (double)this.scaleFactor;
        mouseY = mouseY * this.window.getGuiScale() / (double)this.scaleFactor;
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        mouseX = mouseX * this.window.getGuiScale() / (double)this.scaleFactor;
        mouseY = mouseY * this.window.getGuiScale() / (double)this.scaleFactor;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.mouseScrolled(mouseX = mouseX * this.window.getGuiScale() / (double)this.scaleFactor, mouseY = mouseY * this.window.getGuiScale() / (double)this.scaleFactor, horizontalAmount, verticalAmount)) {
            return true;
        }
        this.turnPage(verticalAmount < 0.0);
        return true;
    }

    public void removed() {
        super.removed();
        ArrayList<NavFrame.Replicator> trail = new ArrayList<NavFrame.Replicator>();
        for (NavFrame frame : this.navStack) {
            trail.add(frame.replicator());
        }
        NAV_TRAILS.put(this.book.id(), trail);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public OwoUIAdapter<?> adapter() {
        return this.uiAdapter;
    }

    protected static List<NavFrame.Replicator> getNavTrail(Book book) {
        return NAV_TRAILS.computeIfAbsent(book.id(), $ -> (List)Util.make(new ArrayList(), trail -> trail.add(0, new NavFrame.Replicator(LandingPageSupplier::new, 0))));
    }

    public static void pushEntry(Book book, Entry entry) {
        LavenderBookScreen.getNavTrail(book).add(0, new NavFrame.Replicator(screen -> new EntryPageSupplier((LavenderBookScreen)((Object)screen), entry), 0));
    }

    @Deprecated(forRemoval=true)
    public static <R extends Recipe<?>> void registerRecipeHandler(ResourceLocation bookId, RecipeType<R> recipeType, RecipeFeature.RecipeHandler<R> handler) {
        LavenderBookScreen.registerRecipePreviewBuilder(bookId, recipeType, handler);
    }

    public static <R extends Recipe<?>> void registerRecipePreviewBuilder(ResourceLocation bookId, RecipeType<R> recipeType, RecipeFeature.RecipePreviewBuilder<R> builder) {
        RECIPE_HANDLERS.computeIfAbsent(bookId, $ -> new HashMap()).put(recipeType, builder);
    }

    public static void registerFeatureFactory(ResourceLocation bookId, FeatureProvider provider) {
        FEATURE_PROVIDERS.put(bookId, provider);
    }

    static {
        UIParsing.registerFactory((ResourceLocation)Lavender.id("structure"), StructureComponent::parse);
        UIParsing.registerFactory((ResourceLocation)Lavender.id("unread-notification"), UnreadNotificationComponent::parse);
    }

    @FunctionalInterface
    public static interface FeatureProvider {
        public List<MarkdownFeature> createFeatures(BookCompiler.ComponentSource var1);
    }

    public static class NavFrame {
        public final PageSupplier pageSupplier;
        public int selectedPage;

        public NavFrame(PageSupplier pageSupplier, int selectedPage) {
            this.pageSupplier = pageSupplier;
            this.selectedPage = selectedPage;
        }

        public Replicator replicator() {
            return new Replicator(this.pageSupplier.replicator(), this.selectedPage);
        }

        public record Replicator(Function<LavenderBookScreen, @Nullable PageSupplier> pageSupplier, int selectedPage) {
            @Nullable
            public NavFrame createFrame(LavenderBookScreen screen) {
                PageSupplier supplier = this.pageSupplier.apply(screen);
                if (supplier == null) {
                    return null;
                }
                return new NavFrame(supplier, this.selectedPage);
            }
        }
    }

    public static class EntryPageSupplier
    extends PageSupplier
    implements PageSupplier.Bookmarkable {
        private final Entry entry;

        public EntryPageSupplier(LavenderBookScreen context, Entry entry) {
            super(context);
            this.entry = entry;
            ParentComponent pages = this.parseMarkdown(entry.content());
            boolean firstPage = true;
            while (!pages.children().isEmpty()) {
                io.wispforest.owo.ui.core.Component component = (io.wispforest.owo.ui.core.Component)pages.children().get(0);
                pages.removeChild(component);
                if (firstPage) {
                    firstPage = false;
                    this.pages.add(this.pageWithHeader((Component)Component.literal((String)entry.title())).child(component));
                    continue;
                }
                this.pages.add(component);
            }
            LavenderClientStorage.markEntryViewed(this.context.book, entry);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean canMerge(PageSupplier other) {
            if (!(other instanceof EntryPageSupplier)) return false;
            EntryPageSupplier supplier = (EntryPageSupplier)other;
            if (!supplier.entry.id().equals((Object)this.entry.id())) return false;
            return true;
        }

        @Override
        public Function<LavenderBookScreen, @Nullable PageSupplier> replicator() {
            ResourceLocation entryId = this.entry.id();
            return context -> {
                Entry entry = context.book.entryById(entryId);
                return entry != null && entry.canPlayerView(((LavenderBookScreen)context).minecraft.player) ? new EntryPageSupplier((LavenderBookScreen)((Object)context), entry) : null;
            };
        }

        @Override
        public void addBookmark() {
            LavenderClientStorage.addBookmark(this.context.book, this.entry);
        }
    }

    public static abstract class PageSupplier {
        protected final LavenderBookScreen context;
        protected final List<io.wispforest.owo.ui.core.Component> pages = new ArrayList<io.wispforest.owo.ui.core.Component>();

        protected PageSupplier(LavenderBookScreen context) {
            this.context = context;
        }

        public int pageCount() {
            return this.pages.size();
        }

        public io.wispforest.owo.ui.core.Component getPageContent(int pageIndex) {
            return this.pages.get(pageIndex);
        }

        public boolean searchable() {
            return false;
        }

        abstract boolean canMerge(PageSupplier var1);

        abstract Function<LavenderBookScreen, @Nullable PageSupplier> replicator();

        protected FlowLayout pageWithHeader(@NotNull Component title) {
            return Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100)).child(this.pageTitleHeader(title));
        }

        protected io.wispforest.owo.ui.core.Component pageTitleHeader(Component text) {
            ParentComponent component = this.context.template(ParentComponent.class, "page-title-header");
            ((LabelComponent)component.childById(LabelComponent.class, "title-label")).text(text);
            return component;
        }

        protected ParentComponent parseMarkdown(String markdown) {
            ParentComponent component = (ParentComponent)this.context.processor.process(markdown);
            component.forEachDescendant(descendant -> {
                block7: {
                    Entry entry;
                    ItemComponent item;
                    block9: {
                        block8: {
                            if (descendant instanceof BookCompiler.BookLabelComponent) {
                                BookCompiler.BookLabelComponent label = (BookCompiler.BookLabelComponent)((Object)descendant);
                                label.setOwner(this.context);
                            }
                            if (!(descendant instanceof ItemComponent)) break block7;
                            item = (ItemComponent)descendant;
                            entry = this.context.book.entryByAssociatedItem(item.stack());
                            if (entry == null) break block8;
                            PageSupplier patt0$temp = this;
                            if (!(patt0$temp instanceof EntryPageSupplier)) break block9;
                            EntryPageSupplier entrySupplier = (EntryPageSupplier)patt0$temp;
                            if (entry != entrySupplier.entry) break block9;
                        }
                        return;
                    }
                    if (!entry.canPlayerView(((LavenderBookScreen)this.context).minecraft.player)) {
                        return;
                    }
                    ArrayList<ClientTooltipComponent> newTooltip = new ArrayList<ClientTooltipComponent>();
                    newTooltip.add(ClientTooltipComponent.create((FormattedCharSequence)Component.empty().getVisualOrderText()));
                    newTooltip.add(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"text.lavender.book.click_to_open").getVisualOrderText()));
                    newTooltip.add(ClientTooltipComponent.create((FormattedCharSequence)TextOps.withFormatting((String)entry.title(), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.GRAY}).getVisualOrderText()));
                    if (item instanceof ItemListComponent) {
                        ItemListComponent ingredient = (ItemListComponent)item;
                        ingredient.extraTooltipSection(newTooltip);
                    } else {
                        newTooltip.addAll(0, item.tooltip());
                        item.tooltip(newTooltip);
                    }
                    item.mouseDown().subscribe((mouseX, mouseY, button) -> {
                        if (button != 0) {
                            return false;
                        }
                        this.context.navPush(new EntryPageSupplier(this.context, entry));
                        UISounds.playInteractionSound();
                        return true;
                    });
                }
            });
            return component;
        }

        protected List<FlowLayout> buildEntryIndex(Collection<Entry> entries, boolean respectOrdinals, int ... pageSizes) {
            ArrayList<FlowLayout> indexSections = new ArrayList<FlowLayout>();
            MutableInt currentSectionHeight = new MutableInt(0);
            indexSections.add(Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()));
            String searchText = this.context.searchBox.getValue().strip();
            String[] filter = searchText.isEmpty() ? new String[]{} : searchText.split(" ");
            for (int i = 0; i < filter.length; ++i) {
                filter[i] = filter[i].strip().toLowerCase(Locale.ROOT);
            }
            entries.stream().sorted((o1, o2) -> AlphanumComparator.compare(o1.title(), o2.title())).sorted(respectOrdinals ? Comparator.comparingInt(Entry::ordinal) : (o1, o2) -> 0).sorted(Comparator.comparing(entry -> !entry.canPlayerView(((LavenderBookScreen)this.context).minecraft.player))).forEach(entry -> {
                FlowLayout indexItem;
                boolean hasUnreadNotification;
                boolean entryVisible = entry.canPlayerView(((LavenderBookScreen)this.context).minecraft.player);
                if (entry.secret() && !entryVisible) {
                    return;
                }
                if (filter.length > 0) {
                    boolean entryMatches;
                    if (!entryVisible) {
                        return;
                    }
                    String entryTitle = entry.title().toLowerCase(Locale.ROOT);
                    boolean bl = entryMatches = Arrays.stream(filter).allMatch(entryTitle::contains) || entry.additionalSearchTerms().stream().anyMatch(term -> Arrays.stream(filter).allMatch(term::contains));
                    if (!entryMatches) {
                        return;
                    }
                }
                if (entryVisible) {
                    hasUnreadNotification = this.context.book.shouldDisplayUnreadNotification((Entry)entry);
                    indexItem = this.context.template(FlowLayout.class, "index-item");
                    ((StackLayout)indexItem.childById(StackLayout.class, "icon-anchor")).child(entry.iconFactory().apply(Sizing.fill()));
                    LabelComponent label = (LabelComponent)indexItem.childById(LabelComponent.class, "index-label");
                    label.text((Component)Component.literal((String)entry.title()).withStyle($ -> $.withFont(Minecraft.UNIFORM_FONT).withItalic(Boolean.valueOf(false))));
                    label.mouseDown().subscribe((mouseX, mouseY, button) -> {
                        if (button != 0) {
                            return false;
                        }
                        this.context.navPush(new EntryPageSupplier(this.context, (Entry)entry));
                        UISounds.playInteractionSound();
                        return true;
                    });
                    Animation animation = label.color().animate(150, Easing.SINE, (Animatable)Color.ofFormatting((ChatFormatting)ChatFormatting.GOLD));
                    label.mouseEnter().subscribe(() -> ((Animation)animation).forwards());
                    label.mouseLeave().subscribe(() -> ((Animation)animation).backwards());
                    if (hasUnreadNotification) {
                        indexItem.child((io.wispforest.owo.ui.core.Component)new UnreadNotificationComponent(this.context.bookTexture(), false));
                    }
                } else {
                    hasUnreadNotification = false;
                    indexItem = this.context.template(FlowLayout.class, "locked-index-item");
                    ((LabelComponent)indexItem.childById(LabelComponent.class, "index-label")).text((Component)Component.translatable((String)"text.lavender.entry.locked"));
                }
                int sectionIndex = indexSections.size() - 1;
                int entryHeight = entry.canPlayerView(((LavenderBookScreen)this.context).minecraft.player) ? Math.max(8, this.lineCount(entry.title(), hasUnreadNotification) * 7) + 2 : 10;
                if (currentSectionHeight.intValue() + entryHeight >= (sectionIndex < pageSizes.length ? pageSizes[sectionIndex] : 150)) {
                    indexSections.add(Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()));
                    currentSectionHeight.setValue(0);
                }
                ((FlowLayout)Iterables.getLast((Iterable)indexSections)).child((io.wispforest.owo.ui.core.Component)indexItem);
                currentSectionHeight.add(entryHeight);
            });
            return indexSections;
        }

        protected FlowLayout buildCategoryIndex(Stream<Category> categories) {
            FlowLayout categoryContainer = Containers.ltrTextFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4);
            categories.sorted(Comparator.comparingInt(Category::ordinal)).sorted(Comparator.comparing($ -> !this.context.book.shouldDisplayCategory((Category)$, ((LavenderBookScreen)this.context).minecraft.player))).forEach(category_ -> {
                if (this.context.book.shouldDisplayCategory((Category)category_, ((LavenderBookScreen)this.context).minecraft.player)) {
                    io.wispforest.owo.ui.core.Component icon = category_.iconFactory().apply(Sizing.fixed((int)16)).configure(categoryButton -> {
                        categoryButton.tooltip((Component)Component.literal((String)category_.title())).margins(Insets.of((int)4)).cursorStyle(CursorStyle.HAND);
                        categoryButton.mouseDown().subscribe((mouseX, mouseY, button) -> {
                            if (button != 0) {
                                return false;
                            }
                            this.context.navPush(new CategoryPageSupplier(this.context, (Category)category_));
                            UISounds.playInteractionSound();
                            return true;
                        });
                    });
                    if (this.context.book.shouldDisplayUnreadNotification((Category)category_, ((LavenderBookScreen)this.context).minecraft.player)) {
                        categoryContainer.child((io.wispforest.owo.ui.core.Component)Containers.stack((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(icon).child((io.wispforest.owo.ui.core.Component)new UnreadNotificationComponent(this.context.bookTexture(), true).positioning(Positioning.relative((int)100, (int)100)).margins(Insets.of((int)0, (int)1, (int)0, (int)1))));
                    } else {
                        categoryContainer.child(icon);
                    }
                } else if (!category_.secret()) {
                    categoryContainer.child(this.context.template(io.wispforest.owo.ui.core.Component.class, "locked-category-button"));
                }
            });
            return categoryContainer;
        }

        protected int lineCount(String entryTitle, boolean hasNotification) {
            return ((LavenderBookScreen)this.context).minecraft.font.getSplitter().splitLines(entryTitle, hasNotification ? 90 : 98, Style.EMPTY.withFont(Minecraft.UNIFORM_FONT)).size();
        }

        public static interface Bookmarkable {
            public void addBookmark();
        }
    }

    public static class EditorPageSupplier
    extends PageSupplier {
        private static String editorTextCache = "";

        protected EditorPageSupplier(LavenderBookScreen context) {
            super(context);
            TextAreaComponent editorComponent = (TextAreaComponent)Components.textArea((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100)).configure(editor -> editor.onChanged().subscribe(value -> {
                editorTextCache = value;
                if (this.pages.size() > 1) {
                    this.pages.subList(1, this.pages.size()).clear();
                }
                ParentComponent compiled = (ParentComponent)this.context.processor.process(editorTextCache);
                boolean firstPage = true;
                while (!compiled.children().isEmpty()) {
                    io.wispforest.owo.ui.core.Component component = (io.wispforest.owo.ui.core.Component)compiled.children().get(0);
                    compiled.removeChild(component);
                    if (firstPage) {
                        firstPage = false;
                        this.pages.add(this.pageWithHeader((Component)Component.literal((String)"Title Here")).child(component));
                        continue;
                    }
                    this.pages.add(component);
                }
                this.context.rebuildContent(null);
            }));
            this.pages.add(editorComponent);
            editorComponent.text(editorTextCache);
        }

        @Override
        public io.wispforest.owo.ui.core.Component getPageContent(int pageIndex) {
            return pageIndex % 2 == 0 ? super.getPageContent(0) : super.getPageContent(pageIndex / 2 + 1);
        }

        @Override
        public int pageCount() {
            return Math.max(1, (super.pageCount() - 1) * 2);
        }

        @Override
        boolean canMerge(PageSupplier other) {
            return other instanceof EditorPageSupplier;
        }

        @Override
        Function<LavenderBookScreen, @Nullable PageSupplier> replicator() {
            return EditorPageSupplier::new;
        }
    }

    public static class CategoryPageSupplier
    extends PageSupplier
    implements PageSupplier.Bookmarkable {
        private final Category category;

        public CategoryPageSupplier(LavenderBookScreen context, Category category) {
            super(context);
            this.category = category;
            ParentComponent parsedLandingPage = this.parseMarkdown(category.content());
            io.wispforest.owo.ui.core.Component landingPageContent = (io.wispforest.owo.ui.core.Component)parsedLandingPage.children().get(0);
            parsedLandingPage.removeChild(landingPageContent);
            FlowLayout landingPage = this.pageWithHeader((Component)Component.literal((String)category.title())).child(landingPageContent);
            this.pages.add(landingPage);
            FlowLayout categoryContainer = this.buildCategoryIndex(this.context.book.categories().stream().filter(category_ -> Objects.equals(category_.parent(), category.id())));
            int spaceOnCategoryPage = !categoryContainer.children().isEmpty() ? 110 - Mth.positiveCeilDiv((int)categoryContainer.children().size(), (int)4) * 24 : 125;
            Collection<Entry> entries = this.context.book.entriesByCategory(this.category);
            if (entries != null) {
                List<FlowLayout> indexPages = this.buildEntryIndex(entries, true, spaceOnCategoryPage);
                for (int i = 0; i < indexPages.size(); ++i) {
                    FlowLayout page;
                    FlowLayout flowLayout = page = i == 0 ? this.pageWithHeader((Component)Component.translatable((String)"text.lavender.index")).child((io.wispforest.owo.ui.core.Component)indexPages.get(0)) : indexPages.get(i);
                    if (i == 0 && !categoryContainer.children().isEmpty()) {
                        page.child(1, (io.wispforest.owo.ui.core.Component)categoryContainer).child(2, this.context.bookComponentSource.builtinTemplate(io.wispforest.owo.ui.core.Component.class, "horizontal-rule").margins(Insets.vertical((int)6)));
                    }
                    this.pages.add(page);
                }
                if (this.context.book.displayCompletion()) {
                    FlowLayout completionBar = this.context.template(FlowLayout.class, "completion-bar", Map.of("progress", String.valueOf((int)(100.0f * ((float)this.countVisibleEntries(entries, ((LavenderBookScreen)this.context).minecraft.player) / (float)entries.size())))));
                    ((LabelComponent)completionBar.childById(LabelComponent.class, "completion-label")).text((Component)Component.translatable((String)"text.lavender.book.unlock_progress", (Object[])new Object[]{this.countVisibleEntries(entries, ((LavenderBookScreen)this.context).minecraft.player), entries.size()}));
                    landingPage.child((io.wispforest.owo.ui.core.Component)completionBar);
                }
            } else {
                this.pages.add(this.pageWithHeader((Component)Component.translatable((String)"text.lavender.index")).child((io.wispforest.owo.ui.core.Component)categoryContainer).child(this.context.bookComponentSource.builtinTemplate(io.wispforest.owo.ui.core.Component.class, "horizontal-rule").margins(Insets.vertical((int)6))));
            }
        }

        protected int countVisibleEntries(Collection<Entry> entries, LocalPlayer player) {
            int visible = 0;
            for (Entry entry : entries) {
                if (!entry.canPlayerView(player)) continue;
                ++visible;
            }
            return visible;
        }

        @Override
        public boolean searchable() {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean canMerge(PageSupplier other) {
            if (!(other instanceof CategoryPageSupplier)) return false;
            CategoryPageSupplier supplier = (CategoryPageSupplier)other;
            if (!supplier.category.id().equals((Object)this.category.id())) return false;
            return true;
        }

        @Override
        public Function<LavenderBookScreen, @Nullable PageSupplier> replicator() {
            ResourceLocation categoryId = this.category.id();
            return context -> {
                Category category = context.book.categoryById(categoryId);
                return category != null && context.book.shouldDisplayCategory(category, ((LavenderBookScreen)context).minecraft.player) ? new CategoryPageSupplier((LavenderBookScreen)((Object)context), category) : null;
            };
        }

        @Override
        public void addBookmark() {
            LavenderClientStorage.addBookmark(this.context.book, this.category);
        }
    }

    public static class IndexPageSupplier
    extends PageSupplier {
        public IndexPageSupplier(LavenderBookScreen context) {
            super(context);
            List<FlowLayout> entries = this.buildEntryIndex(this.context.book.entries(), false, 125);
            this.pages.add(this.pageWithHeader((Component)Component.translatable((String)"text.lavender.index_category.title")).child((io.wispforest.owo.ui.core.Component)entries.remove(0)));
            this.pages.addAll(entries);
        }

        @Override
        public boolean searchable() {
            return true;
        }

        @Override
        boolean canMerge(PageSupplier other) {
            return other instanceof IndexPageSupplier;
        }

        @Override
        Function<LavenderBookScreen, @Nullable PageSupplier> replicator() {
            return IndexPageSupplier::new;
        }
    }

    public static class LandingPageSupplier
    extends PageSupplier {
        public LandingPageSupplier(LavenderBookScreen context) {
            super(context);
            Book book = this.context.book;
            Entry landingPageEntry = book.landingPage();
            if (landingPageEntry != null) {
                FlowLayout landingPage = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100));
                landingPage.child(this.context.template(io.wispforest.owo.ui.core.Component.class, "landing-page-header", Map.of("page-title", landingPageEntry.title())));
                landingPage.child((io.wispforest.owo.ui.core.Component)this.parseMarkdown(landingPageEntry.content()));
                if (book.displayCompletion()) {
                    FlowLayout completionBar = this.context.template(FlowLayout.class, "completion-bar", Map.of("progress", String.valueOf((int)(100.0f * ((float)book.countVisibleEntries(((LavenderBookScreen)this.context).minecraft.player) / (float)book.entries().size())))));
                    ((LabelComponent)completionBar.childById(LabelComponent.class, "completion-label")).text((Component)Component.translatable((String)"text.lavender.book.unlock_progress", (Object[])new Object[]{book.countVisibleEntries(((LavenderBookScreen)this.context).minecraft.player), book.entries().size()}));
                    landingPage.child((io.wispforest.owo.ui.core.Component)completionBar);
                }
                this.pages.add(landingPage);
            } else {
                this.pages.add(this.context.template(io.wispforest.owo.ui.core.Component.class, "empty-page-content"));
            }
            FlowLayout indexPage = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
            this.pages.add(indexPage);
            List<Category> rootCategories = book.categories().stream().filter(category -> category.parent() == null).toList();
            if (!book.categories().isEmpty()) {
                FlowLayout categories = this.pageWithHeader((Component)Component.translatable((String)"text.lavender.categories"));
                categories.verticalSizing(Sizing.content());
                FlowLayout categoryContainer = this.buildCategoryIndex(rootCategories.stream());
                categories.child((io.wispforest.owo.ui.core.Component)categoryContainer);
                categoryContainer.child(Components.item((ItemStack)LavenderBookItem.itemOf(this.context.book)).configure(categoryButton -> {
                    categoryButton.tooltip((Component)Component.translatable((String)"text.lavender.index_category")).margins(Insets.of((int)4)).cursorStyle(CursorStyle.HAND);
                    categoryButton.mouseDown().subscribe((mouseX, mouseY, button) -> {
                        if (button != 0) {
                            return false;
                        }
                        this.context.navPush(new IndexPageSupplier(this.context));
                        UISounds.playInteractionSound();
                        return true;
                    });
                }));
                indexPage.child((io.wispforest.owo.ui.core.Component)categories);
            }
            indexPage.child(book.categories().isEmpty() ? this.pageTitleHeader((Component)Component.translatable((String)"text.lavender.index")) : this.context.bookComponentSource.builtinTemplate(io.wispforest.owo.ui.core.Component.class, "horizontal-rule").margins(Insets.vertical((int)6)));
            int entriesOnCategoryPage = !book.categories().isEmpty() ? 114 - Mth.positiveCeilDiv((int)(rootCategories.size() + 1), (int)4) * 24 : 150;
            List<FlowLayout> orphanedEntries = this.buildEntryIndex(book.orphanedEntries(), true, entriesOnCategoryPage);
            indexPage.child((io.wispforest.owo.ui.core.Component)orphanedEntries.remove(0));
            this.pages.addAll(orphanedEntries);
        }

        @Override
        public boolean searchable() {
            return true;
        }

        @Override
        public boolean canMerge(PageSupplier other) {
            return other instanceof LandingPageSupplier;
        }

        @Override
        public Function<LavenderBookScreen, @Nullable PageSupplier> replicator() {
            return LandingPageSupplier::new;
        }
    }
}

